/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class Geometry
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGGEOMETRYBASE_H_
#define _OSGGEOMETRYBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGSystemDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGMaterialDrawable.h> // Parent

#include <OSGGeoPTypesFields.h> // Types type
#include <OSGGeoPLengthsFields.h> // Lengths type
#include <OSGGeoPositionsFields.h> // Positions type
#include <OSGGeoNormalsFields.h> // Normals type
#include <OSGGeoColorsFields.h> // Colors type
#include <OSGGeoColorsFields.h> // SecondaryColors type
#include <OSGGeoTexCoordsFields.h> // TexCoords type
#include <OSGGeoTexCoordsFields.h> // TexCoords1 type
#include <OSGGeoTexCoordsFields.h> // TexCoords2 type
#include <OSGGeoTexCoordsFields.h> // TexCoords3 type
#include <OSGGeoTexCoordsFields.h> // TexCoords4 type
#include <OSGGeoTexCoordsFields.h> // TexCoords5 type
#include <OSGGeoTexCoordsFields.h> // TexCoords6 type
#include <OSGGeoTexCoordsFields.h> // TexCoords7 type
#include <OSGGeoIndicesFields.h> // Indices type
#include <OSGUInt16Fields.h> // IndexMapping type
#include <OSGBoolFields.h> // DlistCache type
#include <OSGInt32Fields.h> // GLId type
#include <OSGInt32Fields.h> // IgnoreGLForAspect type
#include <OSGUInt32Fields.h> // Minindex type
#include <OSGUInt32Fields.h> // Maxindex type
#include <OSGUInt32Fields.h> // Lowindices type
#include <OSGUInt32Fields.h> // Highindices type
#include <OSGBoolFields.h> // Vbo type

#include <OSGGeometryFields.h>

OSG_BEGIN_NAMESPACE

class Geometry;
class BinaryDataHandler;

//! \brief Geometry Base Class.

class OSG_SYSTEMLIB_DLLMAPPING GeometryBase : public MaterialDrawable
{
  private:

    typedef MaterialDrawable    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef GeometryPtr  Ptr;

    enum
    {
        TypesFieldId             = Inherited::NextFieldId,
        LengthsFieldId           = TypesFieldId             + 1,
        PositionsFieldId         = LengthsFieldId           + 1,
        NormalsFieldId           = PositionsFieldId         + 1,
        ColorsFieldId            = NormalsFieldId           + 1,
        SecondaryColorsFieldId   = ColorsFieldId            + 1,
        TexCoordsFieldId         = SecondaryColorsFieldId   + 1,
        TexCoords1FieldId        = TexCoordsFieldId         + 1,
        TexCoords2FieldId        = TexCoords1FieldId        + 1,
        TexCoords3FieldId        = TexCoords2FieldId        + 1,
        TexCoords4FieldId        = TexCoords3FieldId        + 1,
        TexCoords5FieldId        = TexCoords4FieldId        + 1,
        TexCoords6FieldId        = TexCoords5FieldId        + 1,
        TexCoords7FieldId        = TexCoords6FieldId        + 1,
        IndicesFieldId           = TexCoords7FieldId        + 1,
        IndexMappingFieldId      = IndicesFieldId           + 1,
        DlistCacheFieldId        = IndexMappingFieldId      + 1,
        GLIdFieldId              = DlistCacheFieldId        + 1,
        IgnoreGLForAspectFieldId = GLIdFieldId              + 1,
        MinindexFieldId          = IgnoreGLForAspectFieldId + 1,
        MaxindexFieldId          = MinindexFieldId          + 1,
        LowindicesFieldId        = MaxindexFieldId          + 1,
        HighindicesFieldId       = LowindicesFieldId        + 1,
        VboFieldId               = HighindicesFieldId       + 1,
        NextFieldId              = VboFieldId               + 1
    };

    static const OSG::BitVector TypesFieldMask;
    static const OSG::BitVector LengthsFieldMask;
    static const OSG::BitVector PositionsFieldMask;
    static const OSG::BitVector NormalsFieldMask;
    static const OSG::BitVector ColorsFieldMask;
    static const OSG::BitVector SecondaryColorsFieldMask;
    static const OSG::BitVector TexCoordsFieldMask;
    static const OSG::BitVector TexCoords1FieldMask;
    static const OSG::BitVector TexCoords2FieldMask;
    static const OSG::BitVector TexCoords3FieldMask;
    static const OSG::BitVector TexCoords4FieldMask;
    static const OSG::BitVector TexCoords5FieldMask;
    static const OSG::BitVector TexCoords6FieldMask;
    static const OSG::BitVector TexCoords7FieldMask;
    static const OSG::BitVector IndicesFieldMask;
    static const OSG::BitVector IndexMappingFieldMask;
    static const OSG::BitVector DlistCacheFieldMask;
    static const OSG::BitVector GLIdFieldMask;
    static const OSG::BitVector IgnoreGLForAspectFieldMask;
    static const OSG::BitVector MinindexFieldMask;
    static const OSG::BitVector MaxindexFieldMask;
    static const OSG::BitVector LowindicesFieldMask;
    static const OSG::BitVector HighindicesFieldMask;
    static const OSG::BitVector VboFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFGeoPTypesPtr      *getSFTypes          (void);
           SFGeoPLengthsPtr    *getSFLengths        (void);
           SFGeoPositionsPtr   *getSFPositions      (void);
           SFGeoNormalsPtr     *getSFNormals        (void);
           SFGeoColorsPtr      *getSFColors         (void);
           SFGeoColorsPtr      *getSFSecondaryColors(void);
           SFGeoTexCoordsPtr   *getSFTexCoords      (void);
           SFGeoTexCoordsPtr   *getSFTexCoords1     (void);
           SFGeoTexCoordsPtr   *getSFTexCoords2     (void);
           SFGeoTexCoordsPtr   *getSFTexCoords3     (void);
           SFGeoTexCoordsPtr   *getSFTexCoords4     (void);
           SFGeoTexCoordsPtr   *getSFTexCoords5     (void);
           SFGeoTexCoordsPtr   *getSFTexCoords6     (void);
           SFGeoTexCoordsPtr   *getSFTexCoords7     (void);
           SFGeoIndicesPtr     *getSFIndices        (void);
           MFUInt16            *getMFIndexMapping   (void);
           SFBool              *getSFDlistCache     (void);
           SFInt32             *getSFIgnoreGLForAspect(void);
           SFUInt32            *getSFMinindex       (void);
           SFUInt32            *getSFMaxindex       (void);
           MFUInt32            *getMFLowindices     (void);
           MFUInt32            *getMFHighindices    (void);
           SFBool              *getSFVbo            (void);

           GeoPTypesPtr        &getTypes          (void);
     const GeoPTypesPtr        &getTypes          (void) const;
           GeoPLengthsPtr      &getLengths        (void);
     const GeoPLengthsPtr      &getLengths        (void) const;
           GeoPositionsPtr     &getPositions      (void);
     const GeoPositionsPtr     &getPositions      (void) const;
           GeoNormalsPtr       &getNormals        (void);
     const GeoNormalsPtr       &getNormals        (void) const;
           GeoColorsPtr        &getColors         (void);
     const GeoColorsPtr        &getColors         (void) const;
           GeoColorsPtr        &getSecondaryColors(void);
     const GeoColorsPtr        &getSecondaryColors(void) const;
           GeoTexCoordsPtr     &getTexCoords      (void);
     const GeoTexCoordsPtr     &getTexCoords      (void) const;
           GeoTexCoordsPtr     &getTexCoords1     (void);
     const GeoTexCoordsPtr     &getTexCoords1     (void) const;
           GeoTexCoordsPtr     &getTexCoords2     (void);
     const GeoTexCoordsPtr     &getTexCoords2     (void) const;
           GeoTexCoordsPtr     &getTexCoords3     (void);
     const GeoTexCoordsPtr     &getTexCoords3     (void) const;
           GeoTexCoordsPtr     &getTexCoords4     (void);
     const GeoTexCoordsPtr     &getTexCoords4     (void) const;
           GeoTexCoordsPtr     &getTexCoords5     (void);
     const GeoTexCoordsPtr     &getTexCoords5     (void) const;
           GeoTexCoordsPtr     &getTexCoords6     (void);
     const GeoTexCoordsPtr     &getTexCoords6     (void) const;
           GeoTexCoordsPtr     &getTexCoords7     (void);
     const GeoTexCoordsPtr     &getTexCoords7     (void) const;
           GeoIndicesPtr       &getIndices        (void);
     const GeoIndicesPtr       &getIndices        (void) const;
           bool                &getDlistCache     (void);
     const bool                &getDlistCache     (void) const;
           Int32               &getIgnoreGLForAspect(void);
     const Int32               &getIgnoreGLForAspect(void) const;
           UInt32              &getMinindex       (void);
     const UInt32              &getMinindex       (void) const;
           UInt32              &getMaxindex       (void);
     const UInt32              &getMaxindex       (void) const;
           bool                &getVbo            (void);
     const bool                &getVbo            (void) const;
           UInt16              &getIndexMapping   (const UInt32 index);
           MFUInt16            &getIndexMapping   (void);
     const MFUInt16            &getIndexMapping   (void) const;
           UInt32              &getLowindices     (const UInt32 index);
           MFUInt32            &getLowindices     (void);
     const MFUInt32            &getLowindices     (void) const;
           UInt32              &getHighindices    (const UInt32 index);
           MFUInt32            &getHighindices    (void);
     const MFUInt32            &getHighindices    (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setTypes          ( const GeoPTypesPtr &value );
     void setLengths        ( const GeoPLengthsPtr &value );
     void setPositions      ( const GeoPositionsPtr &value );
     void setNormals        ( const GeoNormalsPtr &value );
     void setColors         ( const GeoColorsPtr &value );
     void setSecondaryColors( const GeoColorsPtr &value );
     void setTexCoords      ( const GeoTexCoordsPtr &value );
     void setTexCoords1     ( const GeoTexCoordsPtr &value );
     void setTexCoords2     ( const GeoTexCoordsPtr &value );
     void setTexCoords3     ( const GeoTexCoordsPtr &value );
     void setTexCoords4     ( const GeoTexCoordsPtr &value );
     void setTexCoords5     ( const GeoTexCoordsPtr &value );
     void setTexCoords6     ( const GeoTexCoordsPtr &value );
     void setTexCoords7     ( const GeoTexCoordsPtr &value );
     void setIndices        ( const GeoIndicesPtr &value );
     void setDlistCache     ( const bool &value );
     void setIgnoreGLForAspect( const Int32 &value );
     void setMinindex       ( const UInt32 &value );
     void setMaxindex       ( const UInt32 &value );
     void setVbo            ( const bool &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  GeometryPtr      create          (void); 
    static  GeometryPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFGeoPTypesPtr      _sfTypes;
    SFGeoPLengthsPtr    _sfLengths;
    SFGeoPositionsPtr   _sfPositions;
    SFGeoNormalsPtr     _sfNormals;
    SFGeoColorsPtr      _sfColors;
    SFGeoColorsPtr      _sfSecondaryColors;
    SFGeoTexCoordsPtr   _sfTexCoords;
    SFGeoTexCoordsPtr   _sfTexCoords1;
    SFGeoTexCoordsPtr   _sfTexCoords2;
    SFGeoTexCoordsPtr   _sfTexCoords3;
    SFGeoTexCoordsPtr   _sfTexCoords4;
    SFGeoTexCoordsPtr   _sfTexCoords5;
    SFGeoTexCoordsPtr   _sfTexCoords6;
    SFGeoTexCoordsPtr   _sfTexCoords7;
    SFGeoIndicesPtr     _sfIndices;
    MFUInt16            _mfIndexMapping;
    SFBool              _sfDlistCache;
    SFInt32             _sfGLId;
    SFInt32             _sfIgnoreGLForAspect;
    SFUInt32            _sfMinindex;
    SFUInt32            _sfMaxindex;
    MFUInt32            _mfLowindices;
    MFUInt32            _mfHighindices;
    SFBool              _sfVbo;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    GeometryBase(void);
    GeometryBase(const GeometryBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~GeometryBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFInt32             *getSFGLId           (void);

           Int32               &getGLId           (void);
     const Int32               &getGLId           (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setGLId           (const Int32 &value);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      GeometryBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      GeometryBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const GeometryBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef GeometryBase *GeometryBaseP;

typedef osgIF<GeometryBase::isNodeCore,
              CoredNodePtr<Geometry>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet GeometryNodePtr;

typedef RefPtr<GeometryPtr> GeometryRefPtr;

OSG_END_NAMESPACE

#define OSGGEOMETRYBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGGEOMETRYBASE_H_ */
