/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *                     Copyright 2000,2001 by OpenSG Forum                   *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE

inline Real32 TileGeometryLoad::getFaceDistribution(UInt32 dir,Real32 cut)
{
    if(cut<=0)
    {
        return 0.0;
    }
    if(cut >=1.0)
    {
        return 1.0;
    }
    cut*=FACE_DISTRIBUTION_SAMPLING_COUNT-1;
    
    UInt32 a=(UInt32)(floor(cut));
    Real32 f=cut-a;

    return _faceDistribution[dir][a] +
        (_faceDistribution[dir][a+1] - _faceDistribution[dir][a]) * f;
}

OSG_END_NAMESPACE

#define OSGTILEGEOMETRYLOAD_INLINE_CVSID "@(#)$Id:$"





