/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class RenderOptions!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILERENDEROPTIONSINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGRenderOptionsBase.h"
#include "OSGRenderOptions.h"

#include <OSGGL.h>                        // PolygonMode default header

OSG_BEGIN_NAMESPACE

const OSG::BitVector  RenderOptionsBase::StatisticFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::StatisticFieldId);

const OSG::BitVector  RenderOptionsBase::PolygonModeFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::PolygonModeFieldId);

const OSG::BitVector  RenderOptionsBase::TwoSidedLightingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::TwoSidedLightingFieldId);

const OSG::BitVector  RenderOptionsBase::SpecTexLightingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::SpecTexLightingFieldId);

const OSG::BitVector  RenderOptionsBase::SortTransFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::SortTransFieldId);

const OSG::BitVector  RenderOptionsBase::ZWriteTransFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::ZWriteTransFieldId);

const OSG::BitVector  RenderOptionsBase::LocalLightsFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::LocalLightsFieldId);

const OSG::BitVector  RenderOptionsBase::CorrectTwoSidedLightingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::CorrectTwoSidedLightingFieldId);

const OSG::BitVector  RenderOptionsBase::OcclusionCullingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::OcclusionCullingFieldId);

const OSG::BitVector  RenderOptionsBase::OcclusionCullingModeFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::OcclusionCullingModeFieldId);

const OSG::BitVector  RenderOptionsBase::OcclusionCullingPixelsFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::OcclusionCullingPixelsFieldId);

const OSG::BitVector  RenderOptionsBase::AntialiasingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::AntialiasingFieldId);

const OSG::BitVector  RenderOptionsBase::AntialiasingDistanceFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::AntialiasingDistanceFieldId);

const OSG::BitVector  RenderOptionsBase::AntialiasingScaleFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::AntialiasingScaleFieldId);

const OSG::BitVector  RenderOptionsBase::AntialiasingTriggerFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::AntialiasingTriggerFieldId);

const OSG::BitVector  RenderOptionsBase::FrustumCullingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::FrustumCullingFieldId);

const OSG::BitVector  RenderOptionsBase::BackfaceCullingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::BackfaceCullingFieldId);

const OSG::BitVector  RenderOptionsBase::SmallFeatureCullingFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::SmallFeatureCullingFieldId);

const OSG::BitVector  RenderOptionsBase::SmallFeaturePixelsFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::SmallFeaturePixelsFieldId);

const OSG::BitVector  RenderOptionsBase::SmallFeatureThresholdFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::SmallFeatureThresholdFieldId);

const OSG::BitVector  RenderOptionsBase::FirstFrameFieldMask = 
    (TypeTraits<BitVector>::One << RenderOptionsBase::FirstFrameFieldId);

const OSG::BitVector RenderOptionsBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var bool            RenderOptionsBase::_sfStatistic
    
*/
/*! \var GLenum          RenderOptionsBase::_sfPolygonMode
    
*/
/*! \var bool            RenderOptionsBase::_sfTwoSidedLighting
    
*/
/*! \var bool            RenderOptionsBase::_sfSpecTexLighting
    
*/
/*! \var bool            RenderOptionsBase::_sfSortTrans
    
*/
/*! \var bool            RenderOptionsBase::_sfZWriteTrans
    
*/
/*! \var bool            RenderOptionsBase::_sfLocalLights
    
*/
/*! \var bool            RenderOptionsBase::_sfCorrectTwoSidedLighting
    
*/
/*! \var bool            RenderOptionsBase::_sfOcclusionCulling
    
*/
/*! \var Int32           RenderOptionsBase::_sfOcclusionCullingMode
    OcclusionStopAndWait (1) or OcclusionMultiFrame (2)
*/
/*! \var UInt32          RenderOptionsBase::_sfOcclusionCullingPixels
    culls objects with this number of visible pixels default is zero.
*/
/*! \var bool            RenderOptionsBase::_sfAntialiasing
    
*/
/*! \var Real32          RenderOptionsBase::_sfAntialiasingDistance
    
*/
/*! \var Real32          RenderOptionsBase::_sfAntialiasingScale
    
*/
/*! \var UInt32          RenderOptionsBase::_sfAntialiasingTrigger
    
*/
/*! \var bool            RenderOptionsBase::_sfFrustumCulling
    
*/
/*! \var bool            RenderOptionsBase::_sfBackfaceCulling
    
*/
/*! \var bool            RenderOptionsBase::_sfSmallFeatureCulling
    
*/
/*! \var Real32          RenderOptionsBase::_sfSmallFeaturePixels
    
*/
/*! \var UInt32          RenderOptionsBase::_sfSmallFeatureThreshold
    
*/
/*! \var bool            RenderOptionsBase::_sfFirstFrame
    
*/

//! RenderOptions description

FieldDescription *RenderOptionsBase::_desc[] = 
{
    new FieldDescription(SFBool::getClassType(), 
                     "statistic", 
                     StatisticFieldId, StatisticFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFStatistic),
    new FieldDescription(SFGLenum::getClassType(), 
                     "polygonMode", 
                     PolygonModeFieldId, PolygonModeFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFPolygonMode),
    new FieldDescription(SFBool::getClassType(), 
                     "twoSidedLighting", 
                     TwoSidedLightingFieldId, TwoSidedLightingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFTwoSidedLighting),
    new FieldDescription(SFBool::getClassType(), 
                     "specTexLighting", 
                     SpecTexLightingFieldId, SpecTexLightingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFSpecTexLighting),
    new FieldDescription(SFBool::getClassType(), 
                     "sortTrans", 
                     SortTransFieldId, SortTransFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFSortTrans),
    new FieldDescription(SFBool::getClassType(), 
                     "zWriteTrans", 
                     ZWriteTransFieldId, ZWriteTransFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFZWriteTrans),
    new FieldDescription(SFBool::getClassType(), 
                     "localLights", 
                     LocalLightsFieldId, LocalLightsFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFLocalLights),
    new FieldDescription(SFBool::getClassType(), 
                     "correctTwoSidedLighting", 
                     CorrectTwoSidedLightingFieldId, CorrectTwoSidedLightingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFCorrectTwoSidedLighting),
    new FieldDescription(SFBool::getClassType(), 
                     "occlusionCulling", 
                     OcclusionCullingFieldId, OcclusionCullingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFOcclusionCulling),
    new FieldDescription(SFInt32::getClassType(), 
                     "occlusionCullingMode", 
                     OcclusionCullingModeFieldId, OcclusionCullingModeFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFOcclusionCullingMode),
    new FieldDescription(SFUInt32::getClassType(), 
                     "occlusionCullingPixels", 
                     OcclusionCullingPixelsFieldId, OcclusionCullingPixelsFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFOcclusionCullingPixels),
    new FieldDescription(SFBool::getClassType(), 
                     "antialiasing", 
                     AntialiasingFieldId, AntialiasingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFAntialiasing),
    new FieldDescription(SFReal32::getClassType(), 
                     "antialiasingDistance", 
                     AntialiasingDistanceFieldId, AntialiasingDistanceFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFAntialiasingDistance),
    new FieldDescription(SFReal32::getClassType(), 
                     "antialiasingScale", 
                     AntialiasingScaleFieldId, AntialiasingScaleFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFAntialiasingScale),
    new FieldDescription(SFUInt32::getClassType(), 
                     "antialiasingTrigger", 
                     AntialiasingTriggerFieldId, AntialiasingTriggerFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFAntialiasingTrigger),
    new FieldDescription(SFBool::getClassType(), 
                     "frustumCulling", 
                     FrustumCullingFieldId, FrustumCullingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFFrustumCulling),
    new FieldDescription(SFBool::getClassType(), 
                     "backfaceCulling", 
                     BackfaceCullingFieldId, BackfaceCullingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFBackfaceCulling),
    new FieldDescription(SFBool::getClassType(), 
                     "smallFeatureCulling", 
                     SmallFeatureCullingFieldId, SmallFeatureCullingFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFSmallFeatureCulling),
    new FieldDescription(SFReal32::getClassType(), 
                     "smallFeaturePixels", 
                     SmallFeaturePixelsFieldId, SmallFeaturePixelsFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFSmallFeaturePixels),
    new FieldDescription(SFUInt32::getClassType(), 
                     "smallFeatureThreshold", 
                     SmallFeatureThresholdFieldId, SmallFeatureThresholdFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFSmallFeatureThreshold),
    new FieldDescription(SFBool::getClassType(), 
                     "firstFrame", 
                     FirstFrameFieldId, FirstFrameFieldMask,
                     false,
                     (FieldAccessMethod) &RenderOptionsBase::getSFFirstFrame)
};


FieldContainerType RenderOptionsBase::_type(
    "RenderOptions",
    "Attachment",
    NULL,
    (PrototypeCreateF) &RenderOptionsBase::createEmpty,
    RenderOptions::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(RenderOptionsBase, RenderOptionsPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &RenderOptionsBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &RenderOptionsBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr RenderOptionsBase::shallowCopy(void) const 
{ 
    RenderOptionsPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const RenderOptions *>(this)); 

    return returnValue; 
}

UInt32 RenderOptionsBase::getContainerSize(void) const 
{ 
    return sizeof(RenderOptions); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void RenderOptionsBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((RenderOptionsBase *) &other, whichField);
}
#else
void RenderOptionsBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((RenderOptionsBase *) &other, whichField, sInfo);
}
void RenderOptionsBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void RenderOptionsBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

RenderOptionsBase::RenderOptionsBase(void) :
    _sfStatistic              (bool(false)), 
    _sfPolygonMode            (GLenum(GL_FILL)), 
    _sfTwoSidedLighting       (bool(false)), 
    _sfSpecTexLighting        (bool(false)), 
    _sfSortTrans              (bool(true)), 
    _sfZWriteTrans            (bool(true)), 
    _sfLocalLights            (bool(true)), 
    _sfCorrectTwoSidedLighting(bool(true)), 
    _sfOcclusionCulling       (bool(false)), 
    _sfOcclusionCullingMode   (Int32(1)), 
    _sfOcclusionCullingPixels (UInt32(0)), 
    _sfAntialiasing           (bool(false)), 
    _sfAntialiasingDistance   (Real32(0.2)), 
    _sfAntialiasingScale      (Real32(2.0)), 
    _sfAntialiasingTrigger    (UInt32(0)), 
    _sfFrustumCulling         (bool(false)), 
    _sfBackfaceCulling        (bool(false)), 
    _sfSmallFeatureCulling    (), 
    _sfSmallFeaturePixels     (), 
    _sfSmallFeatureThreshold  (), 
    _sfFirstFrame             (bool(true)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

RenderOptionsBase::RenderOptionsBase(const RenderOptionsBase &source) :
    _sfStatistic              (source._sfStatistic              ), 
    _sfPolygonMode            (source._sfPolygonMode            ), 
    _sfTwoSidedLighting       (source._sfTwoSidedLighting       ), 
    _sfSpecTexLighting        (source._sfSpecTexLighting        ), 
    _sfSortTrans              (source._sfSortTrans              ), 
    _sfZWriteTrans            (source._sfZWriteTrans            ), 
    _sfLocalLights            (source._sfLocalLights            ), 
    _sfCorrectTwoSidedLighting(source._sfCorrectTwoSidedLighting), 
    _sfOcclusionCulling       (source._sfOcclusionCulling       ), 
    _sfOcclusionCullingMode   (source._sfOcclusionCullingMode   ), 
    _sfOcclusionCullingPixels (source._sfOcclusionCullingPixels ), 
    _sfAntialiasing           (source._sfAntialiasing           ), 
    _sfAntialiasingDistance   (source._sfAntialiasingDistance   ), 
    _sfAntialiasingScale      (source._sfAntialiasingScale      ), 
    _sfAntialiasingTrigger    (source._sfAntialiasingTrigger    ), 
    _sfFrustumCulling         (source._sfFrustumCulling         ), 
    _sfBackfaceCulling        (source._sfBackfaceCulling        ), 
    _sfSmallFeatureCulling    (source._sfSmallFeatureCulling    ), 
    _sfSmallFeaturePixels     (source._sfSmallFeaturePixels     ), 
    _sfSmallFeatureThreshold  (source._sfSmallFeatureThreshold  ), 
    _sfFirstFrame             (source._sfFirstFrame             ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

RenderOptionsBase::~RenderOptionsBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 RenderOptionsBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (StatisticFieldMask & whichField))
    {
        returnValue += _sfStatistic.getBinSize();
    }

    if(FieldBits::NoField != (PolygonModeFieldMask & whichField))
    {
        returnValue += _sfPolygonMode.getBinSize();
    }

    if(FieldBits::NoField != (TwoSidedLightingFieldMask & whichField))
    {
        returnValue += _sfTwoSidedLighting.getBinSize();
    }

    if(FieldBits::NoField != (SpecTexLightingFieldMask & whichField))
    {
        returnValue += _sfSpecTexLighting.getBinSize();
    }

    if(FieldBits::NoField != (SortTransFieldMask & whichField))
    {
        returnValue += _sfSortTrans.getBinSize();
    }

    if(FieldBits::NoField != (ZWriteTransFieldMask & whichField))
    {
        returnValue += _sfZWriteTrans.getBinSize();
    }

    if(FieldBits::NoField != (LocalLightsFieldMask & whichField))
    {
        returnValue += _sfLocalLights.getBinSize();
    }

    if(FieldBits::NoField != (CorrectTwoSidedLightingFieldMask & whichField))
    {
        returnValue += _sfCorrectTwoSidedLighting.getBinSize();
    }

    if(FieldBits::NoField != (OcclusionCullingFieldMask & whichField))
    {
        returnValue += _sfOcclusionCulling.getBinSize();
    }

    if(FieldBits::NoField != (OcclusionCullingModeFieldMask & whichField))
    {
        returnValue += _sfOcclusionCullingMode.getBinSize();
    }

    if(FieldBits::NoField != (OcclusionCullingPixelsFieldMask & whichField))
    {
        returnValue += _sfOcclusionCullingPixels.getBinSize();
    }

    if(FieldBits::NoField != (AntialiasingFieldMask & whichField))
    {
        returnValue += _sfAntialiasing.getBinSize();
    }

    if(FieldBits::NoField != (AntialiasingDistanceFieldMask & whichField))
    {
        returnValue += _sfAntialiasingDistance.getBinSize();
    }

    if(FieldBits::NoField != (AntialiasingScaleFieldMask & whichField))
    {
        returnValue += _sfAntialiasingScale.getBinSize();
    }

    if(FieldBits::NoField != (AntialiasingTriggerFieldMask & whichField))
    {
        returnValue += _sfAntialiasingTrigger.getBinSize();
    }

    if(FieldBits::NoField != (FrustumCullingFieldMask & whichField))
    {
        returnValue += _sfFrustumCulling.getBinSize();
    }

    if(FieldBits::NoField != (BackfaceCullingFieldMask & whichField))
    {
        returnValue += _sfBackfaceCulling.getBinSize();
    }

    if(FieldBits::NoField != (SmallFeatureCullingFieldMask & whichField))
    {
        returnValue += _sfSmallFeatureCulling.getBinSize();
    }

    if(FieldBits::NoField != (SmallFeaturePixelsFieldMask & whichField))
    {
        returnValue += _sfSmallFeaturePixels.getBinSize();
    }

    if(FieldBits::NoField != (SmallFeatureThresholdFieldMask & whichField))
    {
        returnValue += _sfSmallFeatureThreshold.getBinSize();
    }

    if(FieldBits::NoField != (FirstFrameFieldMask & whichField))
    {
        returnValue += _sfFirstFrame.getBinSize();
    }


    return returnValue;
}

void RenderOptionsBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (StatisticFieldMask & whichField))
    {
        _sfStatistic.copyToBin(pMem);
    }

    if(FieldBits::NoField != (PolygonModeFieldMask & whichField))
    {
        _sfPolygonMode.copyToBin(pMem);
    }

    if(FieldBits::NoField != (TwoSidedLightingFieldMask & whichField))
    {
        _sfTwoSidedLighting.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SpecTexLightingFieldMask & whichField))
    {
        _sfSpecTexLighting.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SortTransFieldMask & whichField))
    {
        _sfSortTrans.copyToBin(pMem);
    }

    if(FieldBits::NoField != (ZWriteTransFieldMask & whichField))
    {
        _sfZWriteTrans.copyToBin(pMem);
    }

    if(FieldBits::NoField != (LocalLightsFieldMask & whichField))
    {
        _sfLocalLights.copyToBin(pMem);
    }

    if(FieldBits::NoField != (CorrectTwoSidedLightingFieldMask & whichField))
    {
        _sfCorrectTwoSidedLighting.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OcclusionCullingFieldMask & whichField))
    {
        _sfOcclusionCulling.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OcclusionCullingModeFieldMask & whichField))
    {
        _sfOcclusionCullingMode.copyToBin(pMem);
    }

    if(FieldBits::NoField != (OcclusionCullingPixelsFieldMask & whichField))
    {
        _sfOcclusionCullingPixels.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingFieldMask & whichField))
    {
        _sfAntialiasing.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingDistanceFieldMask & whichField))
    {
        _sfAntialiasingDistance.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingScaleFieldMask & whichField))
    {
        _sfAntialiasingScale.copyToBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingTriggerFieldMask & whichField))
    {
        _sfAntialiasingTrigger.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FrustumCullingFieldMask & whichField))
    {
        _sfFrustumCulling.copyToBin(pMem);
    }

    if(FieldBits::NoField != (BackfaceCullingFieldMask & whichField))
    {
        _sfBackfaceCulling.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SmallFeatureCullingFieldMask & whichField))
    {
        _sfSmallFeatureCulling.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SmallFeaturePixelsFieldMask & whichField))
    {
        _sfSmallFeaturePixels.copyToBin(pMem);
    }

    if(FieldBits::NoField != (SmallFeatureThresholdFieldMask & whichField))
    {
        _sfSmallFeatureThreshold.copyToBin(pMem);
    }

    if(FieldBits::NoField != (FirstFrameFieldMask & whichField))
    {
        _sfFirstFrame.copyToBin(pMem);
    }


}

void RenderOptionsBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (StatisticFieldMask & whichField))
    {
        _sfStatistic.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (PolygonModeFieldMask & whichField))
    {
        _sfPolygonMode.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (TwoSidedLightingFieldMask & whichField))
    {
        _sfTwoSidedLighting.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SpecTexLightingFieldMask & whichField))
    {
        _sfSpecTexLighting.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SortTransFieldMask & whichField))
    {
        _sfSortTrans.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (ZWriteTransFieldMask & whichField))
    {
        _sfZWriteTrans.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (LocalLightsFieldMask & whichField))
    {
        _sfLocalLights.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (CorrectTwoSidedLightingFieldMask & whichField))
    {
        _sfCorrectTwoSidedLighting.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OcclusionCullingFieldMask & whichField))
    {
        _sfOcclusionCulling.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OcclusionCullingModeFieldMask & whichField))
    {
        _sfOcclusionCullingMode.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (OcclusionCullingPixelsFieldMask & whichField))
    {
        _sfOcclusionCullingPixels.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingFieldMask & whichField))
    {
        _sfAntialiasing.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingDistanceFieldMask & whichField))
    {
        _sfAntialiasingDistance.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingScaleFieldMask & whichField))
    {
        _sfAntialiasingScale.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (AntialiasingTriggerFieldMask & whichField))
    {
        _sfAntialiasingTrigger.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FrustumCullingFieldMask & whichField))
    {
        _sfFrustumCulling.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (BackfaceCullingFieldMask & whichField))
    {
        _sfBackfaceCulling.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SmallFeatureCullingFieldMask & whichField))
    {
        _sfSmallFeatureCulling.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SmallFeaturePixelsFieldMask & whichField))
    {
        _sfSmallFeaturePixels.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (SmallFeatureThresholdFieldMask & whichField))
    {
        _sfSmallFeatureThreshold.copyFromBin(pMem);
    }

    if(FieldBits::NoField != (FirstFrameFieldMask & whichField))
    {
        _sfFirstFrame.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void RenderOptionsBase::executeSyncImpl(      RenderOptionsBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (StatisticFieldMask & whichField))
        _sfStatistic.syncWith(pOther->_sfStatistic);

    if(FieldBits::NoField != (PolygonModeFieldMask & whichField))
        _sfPolygonMode.syncWith(pOther->_sfPolygonMode);

    if(FieldBits::NoField != (TwoSidedLightingFieldMask & whichField))
        _sfTwoSidedLighting.syncWith(pOther->_sfTwoSidedLighting);

    if(FieldBits::NoField != (SpecTexLightingFieldMask & whichField))
        _sfSpecTexLighting.syncWith(pOther->_sfSpecTexLighting);

    if(FieldBits::NoField != (SortTransFieldMask & whichField))
        _sfSortTrans.syncWith(pOther->_sfSortTrans);

    if(FieldBits::NoField != (ZWriteTransFieldMask & whichField))
        _sfZWriteTrans.syncWith(pOther->_sfZWriteTrans);

    if(FieldBits::NoField != (LocalLightsFieldMask & whichField))
        _sfLocalLights.syncWith(pOther->_sfLocalLights);

    if(FieldBits::NoField != (CorrectTwoSidedLightingFieldMask & whichField))
        _sfCorrectTwoSidedLighting.syncWith(pOther->_sfCorrectTwoSidedLighting);

    if(FieldBits::NoField != (OcclusionCullingFieldMask & whichField))
        _sfOcclusionCulling.syncWith(pOther->_sfOcclusionCulling);

    if(FieldBits::NoField != (OcclusionCullingModeFieldMask & whichField))
        _sfOcclusionCullingMode.syncWith(pOther->_sfOcclusionCullingMode);

    if(FieldBits::NoField != (OcclusionCullingPixelsFieldMask & whichField))
        _sfOcclusionCullingPixels.syncWith(pOther->_sfOcclusionCullingPixels);

    if(FieldBits::NoField != (AntialiasingFieldMask & whichField))
        _sfAntialiasing.syncWith(pOther->_sfAntialiasing);

    if(FieldBits::NoField != (AntialiasingDistanceFieldMask & whichField))
        _sfAntialiasingDistance.syncWith(pOther->_sfAntialiasingDistance);

    if(FieldBits::NoField != (AntialiasingScaleFieldMask & whichField))
        _sfAntialiasingScale.syncWith(pOther->_sfAntialiasingScale);

    if(FieldBits::NoField != (AntialiasingTriggerFieldMask & whichField))
        _sfAntialiasingTrigger.syncWith(pOther->_sfAntialiasingTrigger);

    if(FieldBits::NoField != (FrustumCullingFieldMask & whichField))
        _sfFrustumCulling.syncWith(pOther->_sfFrustumCulling);

    if(FieldBits::NoField != (BackfaceCullingFieldMask & whichField))
        _sfBackfaceCulling.syncWith(pOther->_sfBackfaceCulling);

    if(FieldBits::NoField != (SmallFeatureCullingFieldMask & whichField))
        _sfSmallFeatureCulling.syncWith(pOther->_sfSmallFeatureCulling);

    if(FieldBits::NoField != (SmallFeaturePixelsFieldMask & whichField))
        _sfSmallFeaturePixels.syncWith(pOther->_sfSmallFeaturePixels);

    if(FieldBits::NoField != (SmallFeatureThresholdFieldMask & whichField))
        _sfSmallFeatureThreshold.syncWith(pOther->_sfSmallFeatureThreshold);

    if(FieldBits::NoField != (FirstFrameFieldMask & whichField))
        _sfFirstFrame.syncWith(pOther->_sfFirstFrame);


}
#else
void RenderOptionsBase::executeSyncImpl(      RenderOptionsBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (StatisticFieldMask & whichField))
        _sfStatistic.syncWith(pOther->_sfStatistic);

    if(FieldBits::NoField != (PolygonModeFieldMask & whichField))
        _sfPolygonMode.syncWith(pOther->_sfPolygonMode);

    if(FieldBits::NoField != (TwoSidedLightingFieldMask & whichField))
        _sfTwoSidedLighting.syncWith(pOther->_sfTwoSidedLighting);

    if(FieldBits::NoField != (SpecTexLightingFieldMask & whichField))
        _sfSpecTexLighting.syncWith(pOther->_sfSpecTexLighting);

    if(FieldBits::NoField != (SortTransFieldMask & whichField))
        _sfSortTrans.syncWith(pOther->_sfSortTrans);

    if(FieldBits::NoField != (ZWriteTransFieldMask & whichField))
        _sfZWriteTrans.syncWith(pOther->_sfZWriteTrans);

    if(FieldBits::NoField != (LocalLightsFieldMask & whichField))
        _sfLocalLights.syncWith(pOther->_sfLocalLights);

    if(FieldBits::NoField != (CorrectTwoSidedLightingFieldMask & whichField))
        _sfCorrectTwoSidedLighting.syncWith(pOther->_sfCorrectTwoSidedLighting);

    if(FieldBits::NoField != (OcclusionCullingFieldMask & whichField))
        _sfOcclusionCulling.syncWith(pOther->_sfOcclusionCulling);

    if(FieldBits::NoField != (OcclusionCullingModeFieldMask & whichField))
        _sfOcclusionCullingMode.syncWith(pOther->_sfOcclusionCullingMode);

    if(FieldBits::NoField != (OcclusionCullingPixelsFieldMask & whichField))
        _sfOcclusionCullingPixels.syncWith(pOther->_sfOcclusionCullingPixels);

    if(FieldBits::NoField != (AntialiasingFieldMask & whichField))
        _sfAntialiasing.syncWith(pOther->_sfAntialiasing);

    if(FieldBits::NoField != (AntialiasingDistanceFieldMask & whichField))
        _sfAntialiasingDistance.syncWith(pOther->_sfAntialiasingDistance);

    if(FieldBits::NoField != (AntialiasingScaleFieldMask & whichField))
        _sfAntialiasingScale.syncWith(pOther->_sfAntialiasingScale);

    if(FieldBits::NoField != (AntialiasingTriggerFieldMask & whichField))
        _sfAntialiasingTrigger.syncWith(pOther->_sfAntialiasingTrigger);

    if(FieldBits::NoField != (FrustumCullingFieldMask & whichField))
        _sfFrustumCulling.syncWith(pOther->_sfFrustumCulling);

    if(FieldBits::NoField != (BackfaceCullingFieldMask & whichField))
        _sfBackfaceCulling.syncWith(pOther->_sfBackfaceCulling);

    if(FieldBits::NoField != (SmallFeatureCullingFieldMask & whichField))
        _sfSmallFeatureCulling.syncWith(pOther->_sfSmallFeatureCulling);

    if(FieldBits::NoField != (SmallFeaturePixelsFieldMask & whichField))
        _sfSmallFeaturePixels.syncWith(pOther->_sfSmallFeaturePixels);

    if(FieldBits::NoField != (SmallFeatureThresholdFieldMask & whichField))
        _sfSmallFeatureThreshold.syncWith(pOther->_sfSmallFeatureThreshold);

    if(FieldBits::NoField != (FirstFrameFieldMask & whichField))
        _sfFirstFrame.syncWith(pOther->_sfFirstFrame);



}

void RenderOptionsBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<RenderOptionsPtr>::_type("RenderOptionsPtr", "AttachmentPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(RenderOptionsPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(RenderOptionsPtr, OSG_SYSTEMLIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGRenderOptionsBase.cpp,v 1.7 2007/07/03 09:16:10 yjung Exp $";
    static Char8 cvsid_hpp       [] = OSGRENDEROPTIONSBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGRENDEROPTIONSBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGRENDEROPTIONSFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

