/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *                 Copyright (C) 2000 by the OpenSG Forum                    *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGVRMLJOINT_HPP_
#define _OSGVRMLJOINT_HPP_
#ifdef __sgi
#pragma once
#endif

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <OSGBaseTypes.h>
#include <OSGVRMLTransform.h>
#include <OSGSFBaseTypes.h>
#include <OSGMFBaseTypes.h>
#include <OSGMFSysTypes.h>

OSG_BEGIN_NAMESPACE

//---------------------------------------------------------------------------
//  Forward References
//---------------------------------------------------------------------------

class VRMLHumanoid;

//---------------------------------------------------------------------------
//   Types
//---------------------------------------------------------------------------

typedef SFQuaternion SFRotation;

//---------------------------------------------------------------------------
//  Class
//---------------------------------------------------------------------------

//! VRMLJoint
//! \ingroup VRMLNodeLib

class OSG_VRML_DLLMAPPING VRMLJoint : public VRMLTransform
{
  private:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef VRMLTransform Inherited;

  public:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef       VRMLJoint *Ptr;
    typedef const VRMLJoint *ConstPtr;

    //-----------------------------------------------------------------------
    //   constants                                                           
    //-----------------------------------------------------------------------

    OSG_RC_FIRST_ELEM_IDM_DECL(LLimitField                                 );

    OSG_RC_ELEM_IDM_DECL      (LimitOrientationField, LLimitField          );
    OSG_RC_ELEM_IDM_DECL      (NameField,             LimitOrientationField);

    OSG_RC_ELEM_IDM_DECL      (SkinCoordIndexField,   NameField            );
    OSG_RC_ELEM_IDM_DECL      (SkinCoordWeightField,  SkinCoordIndexField  );

    OSG_RC_ELEM_IDM_DECL      (StiffnessField,        SkinCoordWeightField );
    OSG_RC_ELEM_IDM_DECL      (ULimitField,           StiffnessField       );

    OSG_RC_LAST_ELEM_IDM_DECL (ULimitField                                 );

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

  private:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend classes                                                      
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend functions                                                    
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    //! prohibit default function (move to 'public' if needed) 
    void operator =(const VRMLJoint &source);

  protected:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    static VRMLObjectType _type;

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    MFReal32   _mfLLimit;
    SFRotation _sfLimitOrientation;
    SFString   _sfName;

    MFInt32    _mfSkinCoordIndex;
    MFReal32   _mfSkinCoordWeight;

    MFReal32   _mfStiffness;
    MFReal32   _mfULimit;

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    VRMLJoint(void);
    VRMLJoint(const VRMLJoint &source);

  public :

    OSG_VRMLOBJ_DECL(Ptr);

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    virtual ~VRMLJoint(void); 

    /*----------------------------- access ----------------------------------*/

    /*------------------------------ init -----------------------------------*/

    /*------------------------------ init -----------------------------------*/

    /*------------------------------ run ------------------------------------*/

    /*-------------------------- field access -------------------------------*/

    MFReal32   *getMFLLimit          (void);
    SFRotation *getSFLimitOrientation(void);
    SFString   *getSFName            (void);

    MFInt32    *getMFSkinCoordIndex  (void);
    MFReal32   *getMFSkinCoordWeight (void);

    MFReal32   *getMFStiffness       (void);
    MFReal32   *getMFULimit          (void);
};

OSG_END_NAMESPACE

#define OSGVRMLJOINT_HEADER_CVSID "@(#)$Id: $"

#endif /* _OSGVRMLJOINT_HPP_ */





