/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *                 Copyright (C) 2000 by the OpenSG Forum                    *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _OSGCONTAINERFACTORYMIXIN_HPP_
#define _OSGCONTAINERFACTORYMIXIN_HPP_
#ifdef __sgi
#pragma once
#endif

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <OSGBaseTypes.h>
#include <OSGFactoryBase.h>
#include <OSGLock.h>
#include <OSGSupportTypes.h>

#include <map>
#include <vector>

OSG_BEGIN_NAMESPACE

//---------------------------------------------------------------------------
//  Forward References
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//   Types
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//  Class
//---------------------------------------------------------------------------

//! ContainerFactoryMixin
//! \ingroup DataStoreLib

template <class FactoryDescT>
class ContainerFactoryMixin : public FactoryBase
{
  private:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

  public:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef          FactoryBase                  Inherited;

    typedef          FactoryDescT                 Desc;

    typedef typename FactoryDescT::FactoryT       Factory;
    typedef typename FactoryDescT::ContainerT     Container;
    typedef typename FactoryDescT::ContainerTypeT ContainerType;
    typedef typename FactoryDescT::ContainerPtrT  ContainerPtr;

    //-----------------------------------------------------------------------
    //   constants                                                           
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

  private:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend classes                                                      
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend functions                                                    
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    //! prohibit default function (move to 'public' if needed) 
    ContainerFactoryMixin(const ContainerFactoryMixin &source);
    //! prohibit default function (move to 'public' if needed) 
    void operator =(const ContainerFactoryMixin &source);

  protected:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef std::map   <UInt32,       ContainerType *>    TypeIdMap;
    typedef std::map   <IDStringLink, ContainerType *>    TypeNameMap;

    typedef std::vector<              ContainerType *>    UninitTypeStore;

    typedef typename TypeIdMap      ::iterator            TypeIdMapIt;
    typedef typename TypeNameMap    ::iterator            TypeNameMapIt;
    typedef typename UninitTypeStore::iterator            UninitTypeStoreIt;

    typedef typename TypeIdMap      ::const_iterator      TypeIdMapConstIt;
    typedef typename TypeNameMap    ::const_iterator      TypeNameMapCnstIt;

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    static Factory *_the;

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    bool             _bInitialized;

    TypeIdMap        _mTypeIdMap;
    TypeNameMap      _mTypeNameMap;

    UninitTypeStore  _vUnitTypesStore;

    Lock            *_pVecLock;

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    ContainerFactoryMixin(const Char8 *szName);
    virtual ~ContainerFactoryMixin(void); 

    virtual bool initialize      (void);
    virtual bool terminate       (void);

    virtual bool onLoadInitialize(void);

  public :

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    static Factory *the(void);

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    UInt32 registerType(ContainerType *pType);

   /*--------------------------- types -------------------------------------*/
        
    ContainerType *findType   (      UInt32  uiTypeId) const;
    ContainerType *findType   (const Char8  *szName  ) const;
    UInt32         getNumTypes(      void            ) const;

   /*------------------------------- get -----------------------------------*/

    ContainerType *findUninitializedType(const Char8 *szName) const;
};


//---------------------------------------------------------------------------
//  Class
//---------------------------------------------------------------------------

//! PrototypeFactoryMixin
//! \ingroup DataStoreLib

template <class ParentT>
class PrototypeFactoryMixin : public ParentT
{
  private:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

  public:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef          ParentT                Inherited;

    typedef typename Inherited::Desc        Desc;

    typedef typename Desc  ::FactoryT       Factory;
    typedef typename Desc  ::ContainerT     Container;
    typedef typename Desc  ::ContainerTypeT ContainerType;
    typedef typename Desc  ::ContainerPtrT  ContainerPtr;

    //-----------------------------------------------------------------------
    //   constants                                                           
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

  private:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend classes                                                      
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend functions                                                    
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    //! prohibit default function (move to 'public' if needed) 
    PrototypeFactoryMixin(const PrototypeFactoryMixin &source);
    //! prohibit default function (move to 'public' if needed) 
    void operator =(const PrototypeFactoryMixin &source);

  protected:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    PrototypeFactoryMixin(const Char8 *szName);
    virtual ~PrototypeFactoryMixin(void); 

  public :

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

   /*------------------------------- get -----------------------------------*/

    ContainerPtr createContainer(const Char8 *szName) const;
};




//---------------------------------------------------------------------------
//  Class
//---------------------------------------------------------------------------

//! ContainerStoreFactoryMixin
//! \ingroup DataStoreLib

template <class ParentT>
class ContainerStoreFactoryMixin : public ParentT
{
  private:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

  public:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef          ParentT                   Inherited;

    typedef typename Inherited::Desc           Desc;

    typedef typename Desc  ::FactoryT          Factory;
    typedef typename Desc  ::ContainerT        Container;
    typedef typename Desc  ::ContainerTypeT    ContainerType;
    typedef typename Desc  ::ContainerPtrT     ContainerPtr;


    typedef          std::vector<ContainerPtr> ContainerStore;
    typedef typename ContainerStore::iterator  ContainerStoreIt;

    //-----------------------------------------------------------------------
    //   constants                                                           
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

  private:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend classes                                                      
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend functions                                                    
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    //! prohibit default function (move to 'public' if needed) 
    ContainerStoreFactoryMixin(const ContainerStoreFactoryMixin &source);
    //! prohibit default function (move to 'public' if needed) 
    void operator =(const ContainerStoreFactoryMixin &source);

  protected:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    bool            _bInitialized;
    ContainerStore  _vContainerStore;

    Lock           *_pStoreLock;

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    ContainerStoreFactoryMixin(const Char8 *szName);
    virtual ~ContainerStoreFactoryMixin(void); 

    virtual bool   initialize        (void);
    virtual bool   terminate         (void);

  public :

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

   /*------------------------------- get -----------------------------------*/

    UInt32 registerContainer(const ContainerPtr &pContainer);

   /*------------------------------- get -----------------------------------*/

    ContainerPtr getContainer(UInt32 uiContainerId) const;

   /*---------------------------- get store --------------------------------*/

    const ContainerStore &getContainerStore(void);
};


//---------------------------------------------------------------------------
//  Class
//---------------------------------------------------------------------------

//! ChangListFactoryMixin
//! \ingroup DataStoreLib

template <class ParentT>
class ChangeListFactoryMixin : public ParentT
{
  private:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

  public:

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    typedef          ParentT                Inherited;

    typedef typename Inherited::Desc        Desc;

    typedef typename Desc  ::FactoryT       Factory;
    typedef typename Desc  ::ContainerPtrT  ContainerPtr;
    typedef typename Desc  ::ChangeListT    ChangeList;

    //-----------------------------------------------------------------------
    //   constants                                                           
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

  private:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend classes                                                      
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   friend functions                                                    
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    //! prohibit default function (move to 'public' if needed) 
    ChangeListFactoryMixin(const ChangeListFactoryMixin &source);
    //! prohibit default function (move to 'public' if needed) 
    void operator =(const ChangeListFactoryMixin &source);

  protected:

    //-----------------------------------------------------------------------
    //   enums                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   types                                                               
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class variables                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance variables                                                  
    //-----------------------------------------------------------------------

    ChangeList  _oChangeList;

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

    ChangeListFactoryMixin(const Char8 *szName);
    virtual ~ChangeListFactoryMixin(void); 

    virtual bool initialize(void);
    virtual bool terminate (void);

  public :

    //-----------------------------------------------------------------------
    //   class functions                                                     
    //-----------------------------------------------------------------------

    //-----------------------------------------------------------------------
    //   instance functions                                                  
    //-----------------------------------------------------------------------

   /*------------------------------- get -----------------------------------*/

    void beginEdit(ContainerPtr pContainer, BitVector bWhichField);
    void endEdit  (ContainerPtr pContainer, BitVector bWhichField);

   /*---------------------------- get store --------------------------------*/

    ChangeList &getChangeList(void);
};

OSG_END_NAMESPACE

#define OSGCONTAINERFACTORYMIXIN_HEADER_CVSID "@(#)$Id: $"

#endif /* _OSGCONTAINERFACTORYMIXIN_HPP_ */
