/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class BlendShapeDeformer!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline
OSG::FieldContainerType &BlendShapeDeformerBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline
OSG::UInt32 BlendShapeDeformerBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline
BlendShapeDeformerPtr BlendShapeDeformerBase::create(void) 
{
    BlendShapeDeformerPtr fc; 

    if(getClassType().getPrototype() != OSG::NullFC) 
    {
        fc = BlendShapeDeformerPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline
BlendShapeDeformerPtr BlendShapeDeformerBase::createEmpty(void) 
{ 
    BlendShapeDeformerPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

//! Get the BlendShapeDeformer::_mfWeight field.
inline
MFReal32 *BlendShapeDeformerBase::getMFWeight(void)
{
    return &_mfWeight;
}

//! Get the BlendShapeDeformer::_mfVertexIndices field.
inline
MFUInt32 *BlendShapeDeformerBase::getMFVertexIndices(void)
{
    return &_mfVertexIndices;
}

//! Get the BlendShapeDeformer::_mfTargetIndices field.
inline
MFUInt16 *BlendShapeDeformerBase::getMFTargetIndices(void)
{
    return &_mfTargetIndices;
}

//! Get the BlendShapeDeformer::_mfTargetVertices field.
inline
MFPnt3f *BlendShapeDeformerBase::getMFTargetVertices(void)
{
    return &_mfTargetVertices;
}

//! Get the BlendShapeDeformer::_mfNormalIndices field.
inline
MFUInt32 *BlendShapeDeformerBase::getMFNormalIndices(void)
{
    return &_mfNormalIndices;
}

//! Get the BlendShapeDeformer::_mfNormalTargetIndices field.
inline
MFUInt16 *BlendShapeDeformerBase::getMFNormalTargetIndices(void)
{
    return &_mfNormalTargetIndices;
}

//! Get the BlendShapeDeformer::_mfTargetNormals field.
inline
MFVec3f *BlendShapeDeformerBase::getMFTargetNormals(void)
{
    return &_mfTargetNormals;
}



//! Get the value of the \a index element the BlendShapeDeformer::_mfWeight field.
inline
Real32 &BlendShapeDeformerBase::getWeight(const UInt32 index)
{
    return _mfWeight[index];
}

//! Get the BlendShapeDeformer::_mfWeight field.
inline
MFReal32 &BlendShapeDeformerBase::getWeight(void)
{
    return _mfWeight;
}

//! Get the BlendShapeDeformer::_mfWeight field.
inline
const MFReal32 &BlendShapeDeformerBase::getWeight(void) const
{
    return _mfWeight;
}

//! Get the value of the \a index element the BlendShapeDeformer::_mfVertexIndices field.
inline
UInt32 &BlendShapeDeformerBase::getVertexIndices(const UInt32 index)
{
    return _mfVertexIndices[index];
}

//! Get the BlendShapeDeformer::_mfVertexIndices field.
inline
MFUInt32 &BlendShapeDeformerBase::getVertexIndices(void)
{
    return _mfVertexIndices;
}

//! Get the BlendShapeDeformer::_mfVertexIndices field.
inline
const MFUInt32 &BlendShapeDeformerBase::getVertexIndices(void) const
{
    return _mfVertexIndices;
}

//! Get the value of the \a index element the BlendShapeDeformer::_mfTargetIndices field.
inline
UInt16 &BlendShapeDeformerBase::getTargetIndices(const UInt32 index)
{
    return _mfTargetIndices[index];
}

//! Get the BlendShapeDeformer::_mfTargetIndices field.
inline
MFUInt16 &BlendShapeDeformerBase::getTargetIndices(void)
{
    return _mfTargetIndices;
}

//! Get the BlendShapeDeformer::_mfTargetIndices field.
inline
const MFUInt16 &BlendShapeDeformerBase::getTargetIndices(void) const
{
    return _mfTargetIndices;
}

//! Get the value of the \a index element the BlendShapeDeformer::_mfTargetVertices field.
inline
Pnt3f &BlendShapeDeformerBase::getTargetVertices(const UInt32 index)
{
    return _mfTargetVertices[index];
}

//! Get the BlendShapeDeformer::_mfTargetVertices field.
inline
MFPnt3f &BlendShapeDeformerBase::getTargetVertices(void)
{
    return _mfTargetVertices;
}

//! Get the BlendShapeDeformer::_mfTargetVertices field.
inline
const MFPnt3f &BlendShapeDeformerBase::getTargetVertices(void) const
{
    return _mfTargetVertices;
}

//! Get the value of the \a index element the BlendShapeDeformer::_mfNormalIndices field.
inline
UInt32 &BlendShapeDeformerBase::getNormalIndices(const UInt32 index)
{
    return _mfNormalIndices[index];
}

//! Get the BlendShapeDeformer::_mfNormalIndices field.
inline
MFUInt32 &BlendShapeDeformerBase::getNormalIndices(void)
{
    return _mfNormalIndices;
}

//! Get the BlendShapeDeformer::_mfNormalIndices field.
inline
const MFUInt32 &BlendShapeDeformerBase::getNormalIndices(void) const
{
    return _mfNormalIndices;
}

//! Get the value of the \a index element the BlendShapeDeformer::_mfNormalTargetIndices field.
inline
UInt16 &BlendShapeDeformerBase::getNormalTargetIndices(const UInt32 index)
{
    return _mfNormalTargetIndices[index];
}

//! Get the BlendShapeDeformer::_mfNormalTargetIndices field.
inline
MFUInt16 &BlendShapeDeformerBase::getNormalTargetIndices(void)
{
    return _mfNormalTargetIndices;
}

//! Get the BlendShapeDeformer::_mfNormalTargetIndices field.
inline
const MFUInt16 &BlendShapeDeformerBase::getNormalTargetIndices(void) const
{
    return _mfNormalTargetIndices;
}

//! Get the value of the \a index element the BlendShapeDeformer::_mfTargetNormals field.
inline
Vec3f &BlendShapeDeformerBase::getTargetNormals(const UInt32 index)
{
    return _mfTargetNormals[index];
}

//! Get the BlendShapeDeformer::_mfTargetNormals field.
inline
MFVec3f &BlendShapeDeformerBase::getTargetNormals(void)
{
    return _mfTargetNormals;
}

//! Get the BlendShapeDeformer::_mfTargetNormals field.
inline
const MFVec3f &BlendShapeDeformerBase::getTargetNormals(void) const
{
    return _mfTargetNormals;
}

OSG_END_NAMESPACE

#define OSGBLENDSHAPEDEFORMERBASE_INLINE_CVSID "@(#)$Id: FCBaseTemplate_inl.h,v 1.20 2002/12/04 14:22:22 dirk Exp $"

