/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CGFXMaterial
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGCGFXMATERIALBASE_H_
#define _OSGCGFXMATERIALBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGChunkMaterial.h> // Parent

#include <OSGStringFields.h> // EffectFile type
#include <OSGStringFields.h> // EffectString type
#include <OSGInt32Fields.h> // Technique type
#include <OSGShaderParameterFields.h> // Parameters type
#include <OSGImageFields.h> // Images type

#include <OSGCGFXMaterialFields.h>

OSG_BEGIN_NAMESPACE

class CGFXMaterial;
class BinaryDataHandler;

//! \brief CGFXMaterial Base Class.

class OSG_CONTRIBLIB_DLLMAPPING CGFXMaterialBase : public ChunkMaterial
{
  private:

    typedef ChunkMaterial    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef CGFXMaterialPtr  Ptr;

    enum
    {
        EffectFileFieldId   = Inherited::NextFieldId,
        EffectStringFieldId = EffectFileFieldId   + 1,
        TechniqueFieldId    = EffectStringFieldId + 1,
        ParametersFieldId   = TechniqueFieldId    + 1,
        ImagesFieldId       = ParametersFieldId   + 1,
        NextFieldId         = ImagesFieldId       + 1
    };

    static const OSG::BitVector EffectFileFieldMask;
    static const OSG::BitVector EffectStringFieldMask;
    static const OSG::BitVector TechniqueFieldMask;
    static const OSG::BitVector ParametersFieldMask;
    static const OSG::BitVector ImagesFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFString            *getSFEffectFile     (void);
           SFString            *getSFEffectString   (void);
           SFInt32             *getSFTechnique      (void);
           MFShaderParameterPtr *getMFParameters     (void);
           MFImagePtr          *getMFImages         (void);

           std::string         &getEffectFile     (void);
     const std::string         &getEffectFile     (void) const;
           std::string         &getEffectString   (void);
     const std::string         &getEffectString   (void) const;
           Int32               &getTechnique      (void);
     const Int32               &getTechnique      (void) const;
           ShaderParameterPtr  &getParameters     (const UInt32 index);
           MFShaderParameterPtr &getParameters     (void);
     const MFShaderParameterPtr &getParameters     (void) const;
           ImagePtr            &getImages         (const UInt32 index);
           MFImagePtr          &getImages         (void);
     const MFImagePtr          &getImages         (void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setEffectFile     ( const std::string &value );
     void setEffectString   ( const std::string &value );
     void setTechnique      ( const Int32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  CGFXMaterialPtr      create          (void); 
    static  CGFXMaterialPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFString            _sfEffectFile;
    SFString            _sfEffectString;
    SFInt32             _sfTechnique;
    MFShaderParameterPtr   _mfParameters;
    MFImagePtr          _mfImages;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    CGFXMaterialBase(void);
    CGFXMaterialBase(const CGFXMaterialBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~CGFXMaterialBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      CGFXMaterialBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      CGFXMaterialBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const CGFXMaterialBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef CGFXMaterialBase *CGFXMaterialBaseP;

typedef osgIF<CGFXMaterialBase::isNodeCore,
              CoredNodePtr<CGFXMaterial>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet CGFXMaterialNodePtr;

typedef RefPtr<CGFXMaterialPtr> CGFXMaterialRefPtr;

OSG_END_NAMESPACE

#define OSGCGFXMATERIALBASE_HEADER_CVSID "@(#)$Id: OSGCGFXMaterialBase.h,v 1.2 2006/06/25 09:43:04 a-m-z Exp $"

#endif /* _OSGCGFXMATERIALBASE_H_ */
