/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CGFXAnnotation!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECGFXANNOTATIONINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCGFXAnnotationBase.h"
#include "OSGCGFXAnnotation.h"


OSG_BEGIN_NAMESPACE

const OSG::BitVector  CGFXAnnotationBase::ParametersFieldMask = 
    (TypeTraits<BitVector>::One << CGFXAnnotationBase::ParametersFieldId);

const OSG::BitVector CGFXAnnotationBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var ShaderParameterPtr CGFXAnnotationBase::_mfParameters
    
*/

//! CGFXAnnotation description

FieldDescription *CGFXAnnotationBase::_desc[] = 
{
    new FieldDescription(MFShaderParameterPtr::getClassType(), 
                     "parameters", 
                     ParametersFieldId, ParametersFieldMask,
                     true,
                     (FieldAccessMethod) &CGFXAnnotationBase::getMFParameters)
};


FieldContainerType CGFXAnnotationBase::_type(
    "CGFXAnnotation",
    "Attachment",
    NULL,
    (PrototypeCreateF) &CGFXAnnotationBase::createEmpty,
    CGFXAnnotation::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CGFXAnnotationBase, CGFXAnnotationPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CGFXAnnotationBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CGFXAnnotationBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr CGFXAnnotationBase::shallowCopy(void) const 
{ 
    CGFXAnnotationPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const CGFXAnnotation *>(this)); 

    return returnValue; 
}

UInt32 CGFXAnnotationBase::getContainerSize(void) const 
{ 
    return sizeof(CGFXAnnotation); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CGFXAnnotationBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl((CGFXAnnotationBase *) &other, whichField);
}
#else
void CGFXAnnotationBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CGFXAnnotationBase *) &other, whichField, sInfo);
}
void CGFXAnnotationBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CGFXAnnotationBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

    _mfParameters.terminateShare(uiAspect, this->getContainerSize());
}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CGFXAnnotationBase::CGFXAnnotationBase(void) :
    _mfParameters             (), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CGFXAnnotationBase::CGFXAnnotationBase(const CGFXAnnotationBase &source) :
    _mfParameters             (source._mfParameters             ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CGFXAnnotationBase::~CGFXAnnotationBase(void)
{
}

/*------------------------------ access -----------------------------------*/

UInt32 CGFXAnnotationBase::getBinSize(const BitVector &whichField)
{
    UInt32 returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ParametersFieldMask & whichField))
    {
        returnValue += _mfParameters.getBinSize();
    }


    return returnValue;
}

void CGFXAnnotationBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ParametersFieldMask & whichField))
    {
        _mfParameters.copyToBin(pMem);
    }


}

void CGFXAnnotationBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ParametersFieldMask & whichField))
    {
        _mfParameters.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CGFXAnnotationBase::executeSyncImpl(      CGFXAnnotationBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ParametersFieldMask & whichField))
        _mfParameters.syncWith(pOther->_mfParameters);


}
#else
void CGFXAnnotationBase::executeSyncImpl(      CGFXAnnotationBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);


    if(FieldBits::NoField != (ParametersFieldMask & whichField))
        _mfParameters.syncWith(pOther->_mfParameters, sInfo);


}

void CGFXAnnotationBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

    if(FieldBits::NoField != (ParametersFieldMask & whichField))
        _mfParameters.beginEdit(uiAspect, uiContainerSize);

}
#endif



#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CGFXAnnotationPtr>::_type("CGFXAnnotationPtr", "AttachmentPtr");
#endif



/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGCGFXAnnotationBase.cpp,v 1.1 2006/04/05 16:10:24 a-m-z Exp $";
    static Char8 cvsid_hpp       [] = OSGCGFXANNOTATIONBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCGFXANNOTATIONBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCGFXANNOTATIONFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

