/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CGChunk
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#ifndef _OSGCGCHUNKBASE_H_
#define _OSGCGCHUNKBASE_H_
#ifdef __sgi
#pragma once
#endif


#include <OSGConfig.h>
#include <OSGContribDef.h>

#include <OSGBaseTypes.h>
#include <OSGRefPtr.h>
#include <OSGCoredNodePtr.h>

#include <OSGShaderChunk.h> // Parent

#include <OSGUInt32Fields.h> // VertexProfile type
#include <OSGUInt32Fields.h> // FragmentProfile type
#include <OSGStringFields.h> // VertexEntryPoint type
#include <OSGStringFields.h> // VertexArguments type
#include <OSGStringFields.h> // FragmentEntryPoint type
#include <OSGStringFields.h> // FragmentArguments type
#include <OSGUInt32Fields.h> // GLId type

#include <OSGCGChunkFields.h>

OSG_BEGIN_NAMESPACE

class CGChunk;
class BinaryDataHandler;

//! \brief CGChunk Base Class.

class OSG_CONTRIBLIB_DLLMAPPING CGChunkBase : public ShaderChunk
{
  private:

    typedef ShaderChunk    Inherited;

    /*==========================  PUBLIC  =================================*/
  public:

    typedef CGChunkPtr  Ptr;

    enum
    {
        VertexProfileFieldId      = Inherited::NextFieldId,
        FragmentProfileFieldId    = VertexProfileFieldId      + 1,
        VertexEntryPointFieldId   = FragmentProfileFieldId    + 1,
        VertexArgumentsFieldId    = VertexEntryPointFieldId   + 1,
        FragmentEntryPointFieldId = VertexArgumentsFieldId    + 1,
        FragmentArgumentsFieldId  = FragmentEntryPointFieldId + 1,
        GLIdFieldId               = FragmentArgumentsFieldId  + 1,
        NextFieldId               = GLIdFieldId               + 1
    };

    static const OSG::BitVector VertexProfileFieldMask;
    static const OSG::BitVector FragmentProfileFieldMask;
    static const OSG::BitVector VertexEntryPointFieldMask;
    static const OSG::BitVector VertexArgumentsFieldMask;
    static const OSG::BitVector FragmentEntryPointFieldMask;
    static const OSG::BitVector FragmentArgumentsFieldMask;
    static const OSG::BitVector GLIdFieldMask;


    static const OSG::BitVector MTInfluenceMask;

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */

    static        FieldContainerType &getClassType    (void); 
    static        UInt32              getClassTypeId  (void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                FieldContainer Get                            */
    /*! \{                                                                 */

    virtual       FieldContainerType &getType  (void); 
    virtual const FieldContainerType &getType  (void) const; 

    virtual       UInt32              getContainerSize(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Get                                 */
    /*! \{                                                                 */

           SFUInt32            *getSFVertexProfile  (void);
           SFUInt32            *getSFFragmentProfile(void);
           SFString            *getSFVertexEntryPoint(void);
           MFString            *getMFVertexArguments(void);
           SFString            *getSFFragmentEntryPoint(void);
           MFString            *getMFFragmentArguments(void);
           SFUInt32            *getSFGLId           (void);

           UInt32              &getVertexProfile  (void);
     const UInt32              &getVertexProfile  (void) const;
           UInt32              &getFragmentProfile(void);
     const UInt32              &getFragmentProfile(void) const;
           std::string         &getVertexEntryPoint(void);
     const std::string         &getVertexEntryPoint(void) const;
           std::string         &getFragmentEntryPoint(void);
     const std::string         &getFragmentEntryPoint(void) const;
           UInt32              &getGLId           (void);
     const UInt32              &getGLId           (void) const;
           std::string         &getVertexArguments(const UInt32 index);
           MFString            &getVertexArguments(void);
     const MFString            &getVertexArguments(void) const;
           std::string         &getFragmentArguments(const UInt32 index);
           MFString            &getFragmentArguments(void);
     const MFString            &getFragmentArguments(void) const;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    Field Set                                 */
    /*! \{                                                                 */

     void setVertexProfile  ( const UInt32 &value );
     void setFragmentProfile( const UInt32 &value );
     void setVertexEntryPoint( const std::string &value );
     void setFragmentEntryPoint( const std::string &value );
     void setGLId           ( const UInt32 &value );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Binary Access                              */
    /*! \{                                                                 */

    virtual UInt32 getBinSize (const BitVector         &whichField);
    virtual void   copyToBin  (      BinaryDataHandler &pMem,
                               const BitVector         &whichField);
    virtual void   copyFromBin(      BinaryDataHandler &pMem,
                               const BitVector         &whichField);


    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Construction                               */
    /*! \{                                                                 */

    static  CGChunkPtr      create          (void); 
    static  CGChunkPtr      createEmpty     (void); 

    /*! \}                                                                 */

    /*---------------------------------------------------------------------*/
    /*! \name                       Copy                                   */
    /*! \{                                                                 */

    virtual FieldContainerPtr     shallowCopy     (void) const; 

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
  protected:

    /*---------------------------------------------------------------------*/
    /*! \name                      Fields                                  */
    /*! \{                                                                 */

    SFUInt32            _sfVertexProfile;
    SFUInt32            _sfFragmentProfile;
    SFString            _sfVertexEntryPoint;
    MFString            _mfVertexArguments;
    SFString            _sfFragmentEntryPoint;
    MFString            _mfFragmentArguments;
    SFUInt32            _sfGLId;

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    CGChunkBase(void);
    CGChunkBase(const CGChunkBase &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~CGChunkBase(void); 

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                       Sync                                   */
    /*! \{                                                                 */

#if !defined(OSG_FIXED_MFIELDSYNC)
    void executeSyncImpl(      CGChunkBase *pOther,
                         const BitVector         &whichField);

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField);
#else
    void executeSyncImpl(      CGChunkBase *pOther,
                         const BitVector         &whichField,
                         const SyncInfo          &sInfo     );

    virtual void   executeSync(      FieldContainer    &other,
                               const BitVector         &whichField,
                               const SyncInfo          &sInfo);

    virtual void execBeginEdit     (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

            void execBeginEditImpl (const BitVector &whichField,
                                          UInt32     uiAspect,
                                          UInt32     uiContainerSize);

    virtual void onDestroyAspect(UInt32 uiId, UInt32 uiAspect);
#endif

    /*! \}                                                                 */
    /*==========================  PRIVATE  ================================*/
  private:

    friend class FieldContainer;

    static FieldDescription   *_desc[];
    static FieldContainerType  _type;


    // prohibit default functions (move to 'public' if you need one)
    void operator =(const CGChunkBase &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------


typedef CGChunkBase *CGChunkBaseP;

typedef osgIF<CGChunkBase::isNodeCore,
              CoredNodePtr<CGChunk>,
              FieldContainer::attempt_to_create_CoredNodePtr_on_non_NodeCore_FC
              >::_IRet CGChunkNodePtr;

typedef RefPtr<CGChunkPtr> CGChunkRefPtr;

OSG_END_NAMESPACE

#define OSGCGCHUNKBASE_HEADER_CVSID "@(#)$Id: FCBaseTemplate_h.h,v 1.40 2005/07/20 00:10:14 vossg Exp $"

#endif /* _OSGCGCHUNKBASE_H_ */
