<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./admin/s_attribute_type/functions.php");

include_once("./functions/item_attribute.php");
include_once("./functions/http.php");

function display_table_row($lookup_r, $row)
{
	echo("<tr>");
	
	echo("<td class=\"data\" align=center>");
	if(is_not_empty_array($lookup_r))
		echo get_input_field("delete_ind[$row]", NULL, NULL, "simple_checkbox()", "N", "Y", FALSE);
	else
		echo("&nbsp;");
	echo("</td>");

	echo("<td class=\"data\" align=center>".get_input_field("order_no[$row]", NULL, NULL, "number(3)", "N", $lookup_r['order_no'], FALSE)."</td>");

	// value
	if(is_not_empty_array($lookup_r))
	{
		echo("<td class=\"data\">".get_input_field("value[$row]", NULL, "Value", "readonly", "Y", $lookup_r['value'], FALSE).
			"<input type=hidden name=\"exists_ind[$row]\" value=\"Y\">".
			"</td>");
	}		
	else // Limit value to 50 characters, because this is really as large as they should get!
	{
		echo("<td class=\"data\">".get_input_field("value[$row]", NULL, "Value", "text(10,50)", "Y", NULL, FALSE).
			"<input type=hidden name=\"exists_ind[$row]\" value=\"N\">".
			"</td>");
	}
	
	//display
	echo("<td class=\"data\">".get_input_field("display[$row]", NULL, NULL, "text(20,255)", "N", $lookup_r['display'], FALSE)."</td>");

	//image

	// Get the theme specific source of the image.
	if($lookup_r['img'] != "none")
		$src = _theme_image_src($lookup_r['img']);
		
	echo("<td class=\"data\" align=center>");
	if($src!==FALSE && strlen($src)>0)
		echo("<img src=\"$src\">");
	else
		echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
	echo("</td>");

	echo("<td class=\"data\">".get_input_field("img[$row]", NULL, "Image", "url(15,*,\"gif,jpg,png\",N)", "N", $lookup_r['img']!="none"?$lookup_r['img']:NULL, FALSE, NULL, "if(this.value.length>0){this.form['none_img[$row]'].checked=false;}")."</td>");
	echo("<td class=\"data\" align=center>".get_input_field("none_img[$row]", NULL, NULL, "simple_checkbox(".($lookup_r['img'] == "none"?"CHECKED":"").")", "N", "Y", FALSE, NULL, "if(this.checked){this.form['img[$row]'].value='';}")."</td>");

	// Checked Indicator
	echo("<td class=\"data\" align=center>".get_input_field("checked_ind[$row]", NULL, NULL, "simple_checkbox(".(strtoupper($lookup_r['checked_ind'])== "Y"?"CHECKED":"").")", "N", "Y", FALSE)."</td>");

	echo("</tr>");
}

function display_s_attribute_type_chooser($scriptname, $type, $s_attribute_type=NULL, $include_type_func=NULL)
{
	echo("\n<p><form action=\"$scriptname\" method=\"get\">");
	echo("\n<input type=\"hidden\" name=\"op\" value=\"edit\">");
	echo("\n<input type=\"hidden\" name=\"type\" value=\"$type\">");

	$lookup_results = fetch_attribute_type_rs();
	echo(custom_select("s_attribute_type", $lookup_results, "%s_attribute_type% - %description%", 1, $s_attribute_type, "s_attribute_type", $include_type_func)
						." <input type=submit value=\"Edit\">");

	echo("</form></p>");
}

//
// Facility to administrate 's_attribute_type_lookup' table.
// 
// This script _only_ works on existing s_attribute_type records.
//
if (is_opendb_valid_session())
{
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if(!is_lookup_s_attribute_type($HTTP_VARS['s_attribute_type']))
		{
			display_s_attribute_type_chooser($PHP_SELF, $HTTP_VARS['type'], NULL, "is_lookup_input_type");
		}
		else // Update here and then display records again.
		{
			if($HTTP_VARS['op'] == 'update')
			{
				if(is_not_empty_array($HTTP_VARS['value']))
				{
					for($i=0; $i<count($HTTP_VARS['value']); $i++)
					{
						// If exists_ind and value is empty, this is fine.  Or as long as a display value is specified for an
						// empty value, and there is not already an empty value, then this is legal as well.
						if(strlen($HTTP_VARS['value'][$i])>0 || strlen($HTTP_VARS['display'][$i])>0 || $HTTP_VARS['exists_ind'][$i] == "Y")
						{
							// an update or delete.
							if($HTTP_VARS['exists_ind'][$i] == "Y")
							{
								if(is_exists_s_atribute_type_lookup($HTTP_VARS['s_attribute_type'], $HTTP_VARS['value'][$i]))
								{
									if($HTTP_VARS['delete_ind'][$i] === "Y")
									{
										if(!delete_s_attribute_type_lookup($HTTP_VARS['s_attribute_type'], $HTTP_VARS['value'][$i]))
										{
											$errors[] = array('error'=>'Lookup value ('.$HTTP_VARS['value'][$i].') not deleted','detail'=>mysql_error());
										}
									}
									else //update
									{
										if($HTTP_VARS['none_img'][$i] == "Y")
											$HTTP_VARS['img'][$i] = "none";
										else if(_theme_image_src($HTTP_VARS['img'][$i])==FALSE)
										 	$HTTP_VARS['img'][$i] = "";

										if(!update_s_attribute_type_lookup($HTTP_VARS['s_attribute_type'], $HTTP_VARS['value'][$i], $HTTP_VARS['display'][$i], $HTTP_VARS['img'][$i], $HTTP_VARS['checked_ind'][$i], $HTTP_VARS['order_no'][$i]))
										{
											$errors[] = array('error'=>'Lookup value ('.$HTTP_VARS['value'][$i].') not updated','detail'=>mysql_error());
										}
									}
								}
								else
								{
									$errors[] = array('error'=>'Lookup value ('.$HTTP_VARS['value'][$i].') not found','detail'=>'');
								}
							}
							else //insert!
							{
								// Get rid of all spaces, and illegal characters.
								$HTTP_VARS['value'][$i] = preg_replace("/[\s|'|\\\\|\"]+/", "", trim(strip_tags($HTTP_VARS['value'][$i])));

								if(!is_exists_s_atribute_type_lookup($HTTP_VARS['s_attribute_type'], $HTTP_VARS['value'][$i]))
								{
									if($HTTP_VARS['none_img'][$i] == "Y")
										$HTTP_VARS['img'][$i] = "none";
									else if(_theme_image_src($HTTP_VARS['img'][$i])===FALSE)// Image not found
										 	$HTTP_VARS['img'][$i] = "";

									// First of all we need to handle the image upload here.
									if(!insert_s_attribute_type_lookup($HTTP_VARS['s_attribute_type'], $HTTP_VARS['value'][$i], $HTTP_VARS['display'][$i], $HTTP_VARS['img'][$i], $HTTP_VARS['checked_ind'][$i], $HTTP_VARS['order_no'][$i]))
									{
										$errors[] = array('error'=>'Lookup value ('.$HTTP_VARS['value'][$i].') not inserted','detail'=>mysql_error());
									}
								}
								else
								{		 	
									$errors[] = array('error'=>'Lookup value ('.$HTTP_VARS['value'][$i].') already exists','detail'=>'');
								}
							}								
						}
					}

				}
			}
			
			// ################################################################
			// Do for both 'update' and 'edit'
			// ################################################################

			// Include validation javascript here.
			echo get_validation_javascript();
			
			display_s_attribute_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_attribute_type'], "is_lookup_input_type");

			if($HTTP_VARS['op'] == 'update')
			{
				echo format_error_block($errors);
			}
			
			echo("<table cellspacing=2 border=0>");
			echo("\n<form name=\"s_attribute_type_lookup\" action=\"$PHP_SELF\" method=\"post\">");

			echo("\n<input type=\"hidden\" name=\"op\" value=\"edit\">");
			echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");
			echo("\n<input type=\"hidden\" name=\"s_attribute_type\" value=\"".$HTTP_VARS['s_attribute_type']."\">");

			echo("<tr>"
				."<td class=\"navbar\">Delete</td>"
				."<td class=\"navbar\">Order</td>"
				."<td class=\"navbar\">Value</td>"
				."<td class=\"navbar\">Display</td>"
				."<td class=\"navbar\" colspan=2>Image</td>"
				."<td class=\"navbar\">No<br>Image</td>"
				."<td class=\"navbar\">Checked</td>"
				."</tr>");	
			$column_count = 9;

			$HTTP_VARS['total_items'] = fetch_s_attribute_type_lookup_cnt($HTTP_VARS['s_attribute_type']);
			if($HTTP_VARS['total_items']>0)
			{
				$attribute_type_lookup_rs = fetch_s_attribute_type_lookup_rs($HTTP_VARS['s_attribute_type']);

				// value, display, img, checked_ind, order_no
				$row = 0;
				while($lookup_r = mysql_fetch_array($attribute_type_lookup_rs, MYSQL_ASSOC))
				{
					display_table_row($lookup_r, $row);

					$row++;
				}
				mysql_free_result($attribute_type_lookup_rs);
			}
			
			if(is_numeric($HTTP_VARS['blank_rows']))
				$blank_rows = (int)$HTTP_VARS['blank_rows'];
			else
				$blank_rows = 5;

			for($i=$row; $i<$row+$blank_rows; $i++)
			{
				display_table_row(array(), $i);	
			}

			echo("<tr>");
			echo("<td colspan=1 align=center>".
				get_input_field("blank_rows", NULL, NULL, "value_select(\"1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20\",1)", "N", ifempty($HTTP_VARS['blank_rows'], "5"), FALSE, NULL, "this.form.submit();")
				."</td>");

			echo("<td colspan=".($column_count-1)." align=center><input type=button value=\"Refresh\" onclick=\"this.form['op'].value='edit'; this.form.submit();\">");
			echo("&nbsp;<input type=button value=\"Update\" onclick=\"this.form['op'].value='update'; this.form.submit();\"></td>");
			echo("</tr>");

			echo("</form>");
			echo("</table>");

			echo(format_help_block($edit_form_help));
		}
	}
}
?>