<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/site_plugin.php");
include_once("./functions/parseutils.php");

//
// Facility to administrate 's_attribute_type' table.
//

/**
	Will generate a function list, based on the format of the 
	$input_type_funcs and $display_type_funcs where the name
	of the function is the key.
*/ 
function build_function_list($name, $list_array, $function_type, $onchange_event=NULL)
{
	$select = "\n<select name=\"$name\" onchange=\"$onchange_event\">";

	while(list($key,) = each($list_array))
	{
		if(strcasecmp($function_type, $key)===0)
			$select .= "\n<option value=\"$key\" SELECTED>$key";
		else
			$select .= "\n<option value=\"$key\">$key";
	}

	$select .= "\n</select>";

	return $select;
}

/**
	Process display type to replace deprecated function specifications
	with replacements.  This allows us to simplify the administrator to
	avoid having to support old outmoded types.
*/
function prc_display_type($display_spec, $input_type)
{
	$widget = prc_function_spec($display_spec);

	// Display type functions allow a default of NULL or "" (empty string) to be
	// used.  When displayed, they default to %value%

	// Note where $display_spec is empty, we need to do cross field validation
	// to initially get the conversion to standard field types.
	// If display_type == '' AND input_type == 'hidden'
	//	Display type: 'hidden'
	// Else
	//  Display type: 'display(%value%)'
	if(strlen($widget['type'])==0)
	{
		// If no args.
		if(strlen(trim($display_spec))==0 && $input_type == 'hidden')
			$widget['type'] = 'hidden';
		else
		{
			$widget['type'] = 'display';
			if(strlen($widget['args']['0'])==0)
				$widget['args']['0'] = '%value%';
		}
	}
	else if($widget['type'] == "split")
	{
		$widget['args']['1'] = $widget['args']['0'];
		$widget['args']['0'] = 'plain';
		$widget['type'] = 'list';
	}
	else if($widget['type'] == "nl2br" || $widget['type'] == "ordered_list" || $widget['type'] == "unordered_list" || $widget['type'] == "ticks_list")
	{
		// No delimiter - use newline.
		$widget['args']['1'] = '';

		// Is list-link specified?
		$widget['args']['2'] = $widget['args']['0'];

		// Get the list_type from the original name.
		$widget['args']['0'] = substr($widget['type'], 0,strpos($widget['type'], '_list'));
		$widget['type'] = 'list';
	}

	return $widget;
}

/**
	Process display type to replace deprecated function specifications
	with replacements.  This allows us to simplify the administrator to
	avoid having to support old outmoded types.
*/
function prc_input_type($input_spec)
{
	$widget = prc_function_spec($input_spec);

	// Process any deprecated options.
	switch($widget['type'])
	{
		case 'vertical_check_boxes':
			$widget['type'] = 'checkbox_grid';
			$widget['args']['1'] = "1";
			break;
		
		case 'horizontal_check_boxes':
			$widget['type'] = 'checkbox_grid';
			$widget['args']['1'] = "*";
			break;
		
		case 'check_boxes':
			$widget['type'] = 'checkbox_grid';
			$widget['args']['0'] = $widget['args']['0'];
			
			if(strcasecmp($widget['args']['1'], 'VERTICAL')===0)
				$widget['args']['1'] = "1";
			else
				$widget['args']['1'] = "*";
			break;
		
		case 'vertical_radio_group':
			$widget['type'] = 'radio_grid';
			$widget['args']['1'] = "1";
			break;
		
		case 'horizontal_radio_group':
			$widget['type'] = 'radio_grid';
			$widget['args']['1'] = "*";
			break;
			
		case 'radio_group':
			$widget['type'] = 'radio_grid';
			$widget['args']['0'] = $widget['args']['0'];
			
			if(strcasecmp($widget['args']['1'], 'VERTICAL')===0)
				$widget['args']['1'] = "1";
			else
				$widget['args']['1'] = "*";
			break;
	}

	return $widget;
}

/**
	Produce full function spec for display in
	Function Help.  However this is not the
	same as format_function_args(...) because 
	this function instead acts on the 
	s_attribute_type configuration arrays.
*/
function get_function_spec($type, $func_args)
{
	$args = "";

	reset($func_args);
	while(list(,$value) = @each($func_args))
	{
		if(substr($value,-3) === "[Y]")
		{
			$value = substr($value,0,-3);
			if(strlen($args)==0)
				$args .= $value;
			else
				$args .= ", $value";
		}
		else
		{
			if(strlen($args)==0)
				$args .= "[$value]";
			else
				$args .= "[, $value]";
		}
	}

	if(strlen($args)>0)
		return $type."(".$args.")";
	else
		return $type;
}

function get_function_help_link($format)
{
	$fieldname = $format."_type";
	return "<a href=\"javascript:popup('admin.php?type=s_attribute_type&op=help&inc_header=N&inc_menu=N&format=$format&function='+document.forms['s_attribute_type']['$fieldname'].options[document.forms['s_attribute_type']['$fieldname'].options.selectedIndex].value,'700', '480')\">(?)</a>";
}

function display_edit_form($attribute_type_r)
{
	global $input_type_functions;
	global $display_type_functions;
	global $_FIELD_TYPES;
	
	// s_attribute_type
	if(is_array($attribute_type_r))
		echo get_input_field("s_attribute_type", NULL, "Attribute Type", "readonly", "Y", $attribute_type_r['s_attribute_type']);
	else
		echo get_input_field("s_attribute_type", NULL, "Attribute Type", "text(10,10)", "Y");
	
	//description
	echo get_input_field("description", NULL, "Description", "text(30,60)", "Y", $attribute_type_r['description']);
	
	//prompt
	echo get_input_field("prompt", NULL, "Prompt", "text(20,30)", "Y", $attribute_type_r['prompt']);

	if(!is_reserved_s_attribute_type($attribute_type_r['s_attribute_type']))
	{
		//input_type
		if(strlen($attribute_type_r['s_attribute_type'])>0)
			$input_type_r = prc_input_type($attribute_type_r['input_type']);
	
		echo format_field("Input type", 
						NULL, 
						build_function_list("input_type", $input_type_functions, $input_type_r['type']).
						get_input_field("input_type_args", NULL, NULL, "text(20,230)", "N", get_rebuilt_function(NULL, $input_type_r['args']), FALSE).
						get_function_help_link('input')
					
		);
	
		if(strlen($attribute_type_r['s_attribute_type'])>0)
			$display_type_r = prc_display_type($attribute_type_r['display_type'], $input_type_r['type']);
		
		echo format_field("Display type", 
						NULL, 		
						build_function_list("display_type", $display_type_functions, $display_type_r['type']).
						get_input_field("display_type_args", NULL, NULL, "text(20,230)", "N", get_rebuilt_function(NULL, $display_type_r['args']), FALSE).
						get_function_help_link('display')
			);

		if($attribute_type_r['s_field_type'] != 'ADDRESS' && $attribute_type_r['s_field_type'] != 'RATING')
		{
			echo format_field("Field type", 
					NULL,
					custom_select("s_field_type", $_FIELD_TYPES, "%key% - %value%", 1, $attribute_type_r['s_field_type'], "key"));	
			
			$sites = get_site_plugin_list_r();
			if(!is_array($sites))
				$sites[] = '';
			else if(!in_array('', $sites))
				$sites = array_merge(array(''),$sites);
				
			if(strlen($attribute_type_r['site_type'])>0 && !in_array($attribute_type_r['site_type'], $sites))
				$sites[] = $attribute_type_r['site_type'];
			
			echo format_field("Site type", 
						NULL,
						custom_select("site_type", $sites, "%value%", 1, $attribute_type_r['site_type']));
		}
		else
		{
			echo format_field("Field type", NULL, $attribute_type_r['s_field_type']);
		}
	}
	else
	{
		echo format_field("Input type", NULL, $attribute_type_r['input_type']);
		echo format_field("Display type", NULL, $attribute_type_r['display_type']);
		echo format_field("Field type", NULL, $attribute_type_r['s_field_type']);
		if($attribute_type_r['s_field_type'] != 'ADDRESS' && $attribute_type_r['s_field_type'] != 'RATING')
		{
			echo format_field("Site type", NULL, $attribute_type_r['site_type']);
		}
	}
}

/**
	The $func_array actually contains the $func_array record.
*/
function display_function_help($function, $func_array, $format)
{
	global $argument_types;

	echo("<h3>".get_function_spec($function, $func_array['args'])."</h3>");

	echo("<h3><i>Type: $format</i></h3>");
	echo("<p class=\"colortext\">".$func_array['description']."</p>");

	echo("<h3><i>Arguments</i></h3>");
	if(is_not_empty_array($func_array['args']))
	{
		echo("<ul class=\"colortext\">");
		while(list(,$value) = each($func_array['args']))
		{
			if(substr($value,-3) === "[Y]")
			{
				$value = substr($value,0,-3);
				echo("<li>".$value." - ");
			}
			else
				echo("<li>".$value." - ");

			if(is_array($argument_types[$value]))
			{			   
				echo($argument_types[$value]['description']."</li>");
			}
		}
		echo("</ul>");
	}
	else
		echo("<p class=\"colortext\">No arguments</p>");
}

function display_s_attribute_type_chooser($script_name, $type, $s_attribute_type)
{
	echo("\n<form action=\"$script_name\" method=\"get\">");
	echo("\n<input type=\"hidden\" name=\"op\" value=\"edit\">");
	echo("\n<input type=\"hidden\" name=\"type\" value=\"".$type."\">");

	$lookup_results = fetch_attribute_type_rs();
	echo custom_select("s_attribute_type", $lookup_results, "%s_attribute_type% - %description%", 1, $s_attribute_type, "s_attribute_type", NULL).
				"&nbsp;<input type=button value=\"Edit\" onclick=\"this.form['op'].value='edit'; this.form.submit();\">&nbsp;".
				"<input type=button value=\"New\" onclick=\"this.form['op'].value='new'; this.form.submit();\">";
	echo("</form>");

}

// #################################################################################
// Main Process
// #################################################################################
if (is_opendb_valid_session())
{
	if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if($HTTP_VARS['op'] == 'help')
		{
			echo _theme_header("$type_description - [Function Help]", FALSE);
			echo("\n<h2>Function Help</h2>");

			if($HTTP_VARS['format'] == 'input' && is_array($input_type_functions[$HTTP_VARS['function']]))
			{
				display_function_help($HTTP_VARS['function'], $input_type_functions[$HTTP_VARS['function']], $HTTP_VARS['format']);
			}
			else if($HTTP_VARS['format'] == 'display' && is_array($display_type_functions[$HTTP_VARS['function']])) 
			{
				display_function_help($HTTP_VARS['function'], $display_type_functions[$HTTP_VARS['function']], $HTTP_VARS['format']);
			}
			else
			{
				echo _theme_error('Function ('.$HTTP_VARS['function'].') not found');
			}
		}
		else if($HTTP_VARS['op'] == 'delete_abort' || $HTTP_VARS['op'] == 'delete_confirm' || $HTTP_VARS['op'] == 'update' || $HTTP_VARS['op'] == 'delete' || $HTTP_VARS['op'] == 'insert')
		{
			if(strlen($HTTP_VARS['s_attribute_type'])>0)
			{
				if($HTTP_VARS['op'] == 'delete_abort')
				{
					$page_title = "\n<h3>Delete Attribute type</h3>";	
					$page_message = "\n<div class=\"success\">Attribute Type not deleted</div>";
				}
				else if($HTTP_VARS['op'] == 'delete_confirm' && $HTTP_VARS['confirmed'] != "true")
				{
					$page_title = "\n<h3>Delete Attribute type</h3>";
					if(!is_exists_item_attribute_type(NULL, $HTTP_VARS['s_attribute_type']))
					{
						$page_message = "\n<div class=\"colortext\">Are you sure you want to delete attribute type '".$HTTP_VARS['s_attribute_type']."'?".
								"\n<form action=\"$PHP_SELF\" method=\"get\">".
								"\n<input type=\"hidden\" name=\"op\" value=\"delete_abort\">".
								"\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">".
								"\n<input type=\"hidden\" name=\"confirmed\" value=\"true\">".
								"\n<input type=\"hidden\" name=\"s_attribute_type\" value=\"".$HTTP_VARS['s_attribute_type']."\">".
								"\n<input type=\"button\" value=\" Yes \" onclick=\"this.form.op.value='delete'; this.form.submit();\">&nbsp;".
								"\n<input type=\"button\" value=\" No \" onclick=\"this.form.op.value='delete_abort'; this.form.submit();\">".
								"\n</form>";
					}
					else
					{
						$page_message = format_error_block(array('error'=>'Attribute type ('.$HTTP_VARS['s_attribute_type'].') not deleted.', 'detail'=>'Attribute is linked to at least one system item type'));
					}
				}
				else
				{
					$HTTP_VARS['s_attribute_type'] = strtoupper($HTTP_VARS['s_attribute_type']);
					if($HTTP_VARS['op'] == 'update' || $HTTP_VARS['op'] == 'delete')
					{
						if(is_exists_attribute_type($HTTP_VARS['s_attribute_type']))
						{
							// fetch the current s_field_type
							$s_field_type = fetch_attribute_type_s_field_type($HTTP_VARS['s_attribute_type']);
							
							if($HTTP_VARS['op'] == 'update')
							{
								$page_title = "\n<h3>Update Attribute type</h3>";
								
								if(is_reserved_s_attribute_type($HTTP_VARS['s_attribute_type'])) // For reserved types, only allow update of prompt.
									$update_result = update_s_attribute_type($HTTP_VARS['s_attribute_type'], $HTTP_VARS['description'], $HTTP_VARS['prompt'], FALSE, FALSE, FALSE, FALSE);
								else if($s_field_type == 'RATING')
									$update_result = update_s_attribute_type($HTTP_VARS['s_attribute_type'], $HTTP_VARS['description'], $HTTP_VARS['prompt'], FALSE, FALSE, FALSE, FALSE);
								else if($s_field_type == 'ADDRESS') // for non S_ attributes, but those with an s_field_type of 'ADDRESS' the s_field_type should not be updateable, and the site_type should remain NULL
									$update_result = update_s_attribute_type($HTTP_VARS['s_attribute_type'], $HTTP_VARS['description'], $HTTP_VARS['prompt'], get_rebuilt_function($HTTP_VARS['input_type'], $HTTP_VARS['input_type_args']), get_rebuilt_function($HTTP_VARS['display_type'], $HTTP_VARS['display_type_args']), FALSE, FALSE);
								else
									$update_result = update_s_attribute_type($HTTP_VARS['s_attribute_type'], $HTTP_VARS['description'], $HTTP_VARS['prompt'], get_rebuilt_function($HTTP_VARS['input_type'], $HTTP_VARS['input_type_args']), get_rebuilt_function($HTTP_VARS['display_type'], $HTTP_VARS['display_type_args']), $HTTP_VARS['s_field_type'], $HTTP_VARS['site_type']);
									
								if($update_result)
									$page_message = "<div class=\"success\">Attribute type updated.</div>";
								else
									$page_message = format_error_block(array('error'=>'Attribute type ('.$HTTP_VARS['s_attribute_type'].') not updated','detail'=>mysql_error()));
							}
							else //if($HTTP_VARS['op'] == 'delete')
							{
								$page_title = "\n<h3>Delete Attribute type</h3>";
								if(!is_reserved_s_attribute_type($HTTP_VARS['s_attribute_type']))
								{
									if($s_field_type == 'ADDRESS' && is_exists_addr_attribute_type_rltshp(NULL, $HTTP_VARS['s_attribute_type']))
									{
										$page_message = format_error_block(array('error'=>'Attribute type ('.$HTTP_VARS['s_attribute_type'].') not deleted.', 'detail'=>'Attribute is linked to at least one system address type'));
									}
									else if($s_field_type == 'RATING')
									{
										$page_message = format_error_block(array('error'=>'Attribute type ('.$HTTP_VARS['s_attribute_type'].') not deleted.', 'detail'=>'Attribute is reserved for ratings'));
									}
									else if($s_field_type != 'ADDRESS' && $s_field_type != 'RATING' && is_exists_item_attribute_type(NULL, $HTTP_VARS['s_attribute_type']))
									{
										$page_message = format_error_block(array('error'=>'Attribute type ('.$HTTP_VARS['s_attribute_type'].') not deleted.', 'detail'=>'Attribute is linked to at least one system item type'));
									}
									else
									{
										if(delete_s_attribute_type($HTTP_VARS['s_attribute_type']))
											$page_message = "\n<div class=\"success\">Attribute type '".$HTTP_VARS['s_attribute_type']."' deleted.</a>";
										else
											$page_message = format_error_block(array('error'=>'Attribute type ('.$HTTP_VARS['s_attribute_type'].') not deleted.','detail'=>mysql_error()));
									}
								}
								else
								{
									$page_message = format_error_block('Attribute type\'s with a \'S_\' prefix are reserved for internal use.');
								}
							}
						}
						else
						{
							$page_message = format_error_block('Attribute type ('.$HTTP_VARS['s_attribute_type'].') not found');
						}
					}
					else // if($HTTP_VARS['op'] == 'insert')
					{
						$page_title = "<h3>Insert Attribute type</h3>";
						if(!is_reserved_s_attribute_type($HTTP_VARS['s_attribute_type']))
						{
							// Get rid of all spaces, and illegal characters.
							$HTTP_VARS['s_attribute_type'] = preg_replace("/[\s|'|\\\\|\"]+/", "", trim(strip_tags($HTTP_VARS['s_attribute_type'])));
							if(!is_exists_attribute_type($HTTP_VARS['s_attribute_type']))
							{
								// site type not valid for these
								if($HTTP_VARS['s_field_type'] == 'ADDRESS' || $HTTP_VARS['s_field_type'] == 'RATING')
								{
									$HTTP_VARS['site_type'] = NULL;
								}
								
								if(insert_s_attribute_type($HTTP_VARS['s_attribute_type'], $HTTP_VARS['description'], $HTTP_VARS['prompt'], get_rebuilt_function($HTTP_VARS['input_type'], $HTTP_VARS['input_type_args']), get_rebuilt_function($HTTP_VARS['display_type'], $HTTP_VARS['display_type_args']), $HTTP_VARS['s_field_type'], $HTTP_VARS['site_type']))
								{
									$page_message = "\n<div class=\"success\">Attribute (".$HTTP_VARS['s_attribute_type'].") type inserted.</div>";
								}
								else
								{
									$page_message = format_error_block(array('error'=>'Attribute type ('.$HTTP_VARS['s_attribute_type'].') not inserted','detail'=>mysql_error()));
								}
							}
							else
							{
								$page_message = format_error_block('Attribute type ('.$HTTP_VARS['s_attribute_type'].') already exists.');
							}
						}
						else
						{
							$page_message = format_error_block('Attribute type\'s with a \'S_\' prefix are reserved for internal use.');
						}
					}
				}
				
				// Display the chooser at the top whatever happens.
				display_s_attribute_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_attribute_type'], "is_not_reserved_system_type");
					
				echo $page_title;
				echo $page_message;
			}
			else
			{
				echo format_error_block('Invalid attribute type specified');
			}
		}
		else
		{
			// Include validation javascript here.
			echo get_validation_javascript();

			display_s_attribute_type_chooser($PHP_SELF, $HTTP_VARS['type'], $HTTP_VARS['s_attribute_type']);
				
			if($HTTP_VARS['op'] == 'new')
			{
				echo("\n<br><h3>New Attribute type</h3>");

				echo("\n<table cellspacing=2 border=0>");
				echo("\n<form name=\"s_attribute_type\" action=\"$PHP_SELF\" method=\"post\">");
	
				echo("\n<input type=\"hidden\" name=\"op\" value=\"insert\">");
				echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");
				
				display_edit_form(NULL);
				
				if($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE)
				{
					echo("\n<tr><td align=left nowrap>".
							format_help_block(array(array('img'=>'compulsory.gif', 'text'=>$LANG_VARS['compulsory_field']))).
						"</td><td>&nbsp;</td></tr>");
				}
				
				echo("\n<tr><td colspan=\"2\" align=center>");
				if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
				{
					echo("\n<input type=button value=\"Insert\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form.submit();}\">");
				}
				else
				{
					echo("\n<input type=button value=\"Insert\" onclick=\"this.form.submit();\">");
				}
				echo("\n</td></tr>");
				
				echo("\n</form>");
				echo("\n</table>");
				
				echo(format_help_block($new_sat_form_help));
			}
			else if($HTTP_VARS['op'] == 'edit' && strlen($HTTP_VARS['s_attribute_type'])>0)
			{
				echo("\n<br><h3>Edit Attribute type</h3>");

				$attribute_type_r = fetch_s_attribute_type_r($HTTP_VARS['s_attribute_type']);
				if($attribute_type_r!==FALSE)
				{
					echo("\n<table cellspacing=2 border=0>");
					echo("\n<form name=\"s_attribute_type\" action=\"$PHP_SELF\" method=\"post\">");
	
					echo("\n<input type=\"hidden\" name=\"op\" value=\"update\">");
					echo("\n<input type=\"hidden\" name=\"type\" value=\"".$HTTP_VARS['type']."\">");

					display_edit_form($attribute_type_r);
					
					if($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE)
					{
						echo("\n<tr><td align=left nowrap>".
							format_help_block(array(array('img'=>'compulsory.gif', 'text'=>$LANG_VARS['compulsory_field']))).
							"</td><td>&nbsp;</td></tr>");
					}
				
					echo("\n<tr><td colspan=\"2\" align=center>");
					
					if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
					{
						echo("\n<input type=button value=\"Update\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form.submit();}\">");
						if(!is_reserved_s_attribute_type($attribute_type_r['s_attribute_type']))
						{
							echo("\n&nbsp;<input type=button value=\"Delete\" onclick=\"if(!checkForm(this.form)){return false;}else{this.form['op'].value='delete_confirm'; this.form.submit();}\">");
						}
					}
					else
					{
						echo("\n<input type=button value=\"Update\" onclick=\"this.form.submit();\">");
						if(!is_reserved_s_attribute_type($attribute_type_r['s_attribute_type']))
						{
							echo("\n&nbsp;<input type=button value=\"Delete\" onclick=\"this.form['op'].value='delete_confirm'; this.form.submit();\">");
						}
					}
					echo("\n</td></tr>");

					echo("\n</form>");
					echo("\n</table>");
					
					echo(format_help_block($new_sat_form_help));
				}
				else
				{
					echo format_error_block('Attribute type ('.$HTTP_VARS['s_attribute_type'].') not found');
				}
			}
		}
	}
}//if(is_opendb_valid_session())