/***************************************************************************
 *   Copyright (C) 2006 by Christian Nitschkowski   *
 *   christian.nitschkowski@kdemail.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _OOOQS2IFACE_H_
#define _OOOQS2IFACE_H_

#include <dcopobject.h>

class OOoQs2Iface : virtual public DCOPObject
{
   K_DCOP

   k_dcop:
      virtual void startBase() = 0;
      virtual void startCalc() = 0;
      virtual void startDraw() = 0;
      virtual void startImpress() = 0;
      virtual void startMath() = 0;
      virtual void startTemplate() = 0;
      virtual void startWriter() = 0;

      virtual bool preloading() = 0;
      virtual void enablePreloading( bool ) = 0;
      virtual bool startOnLogin() = 0;
      virtual void enableStartOnLogin( bool ) = 0;
      virtual bool overrideDetection() = 0;
      virtual void setOverrideDetection( bool ) = 0;
      virtual QString overrideBinary() = 0;
      virtual void setOverrideBinary( QString ) = 0;
      virtual QString binary() = 0;
      virtual int instanceOOo() = 0;
      virtual int quickAccess() = 0;
      virtual void setQuickAccess( int ) = 0;
};

#endif
