/*
  jointable: C front-end to jointable.awk.

  Copyright (c) 2004,2006 Carlo Strozzi

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 dated June, 1991.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  $Id: jointable.c,v 1.3 2006/03/10 11:26:13 carlo Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <errno.h>
#include "util.h"

#define PERMS 0600

#ifndef INSTDIR
#define INSTDIR "/usr/local/nosql"
#endif

#define AWKFILE (INSTDIR "/lib/jointable.awk")

void cleanup();
void onintr();

static const char *progname = "jointable";

char *fifo1 = NULL, *fifo2 = NULL;

int main(int argc, char *argv[]) {

    char *s;
    int n, status;
    pid_t pid;
    Strlist *args;
    /* extern void onintr(); */

    args = strlist();
    slappend(args, "mawk");


    /* catch the usual signals 1 2 3 13 15 */

    if (signal(SIGHUP, SIG_IGN) != SIG_IGN)
			signal(SIGHUP, onintr);		/* signal  1 */

    if (signal(SIGINT, SIG_IGN) != SIG_IGN)
			signal(SIGINT, onintr);		/* signal  2 */

    if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
			signal(SIGQUIT, onintr);	/* signal  3 */

    if (signal(SIGPIPE, SIG_IGN) != SIG_IGN)
			signal(SIGPIPE, onintr);	/* signal 13 */

    if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
			signal(SIGTERM, onintr);	/* signal 15 */

    if ((fifo1 = tempnam(NULL,"nosql")) < 0) {
       perror(progname);
       exit(1);
    }

    /*
    while ((fifo1 = tempnam(NULL,"nosql"))) {
       if (mknod(fifo1, S_IFIFO|PERMS, 0) == 0) break;
       if (errno != EEXIST) {
	  perror(progname);
	  exit(1);
       }
    }
    */

    if ((fifo2 = tempnam(NULL,"nosql")) < 0) {
       perror(progname);
       exit(1);
    }

    /*
    while ((fifo2 = tempnam(NULL,"nosql"))) {
       if (mknod(fifo2, S_IFIFO|PERMS, 0) == 0) break;
       if (errno != EEXIST) {
	  perror(progname);
       	  unlink(fifo1);
	  exit(1);
       }
    }
    */

    n = strlen(fifo1) + 10;
    s = emalloc(n);
    snprintf(s, n, "-vfifo1=%s", fifo1);
    slappend(args, s);
    n = strlen(fifo2) + 10;
    s = emalloc(n);
    snprintf(s, n, "-vfifo2=%s", fifo2);
    slappend(args, s);
    slappend(args, "-f");
    slappend(args, AWKFILE);
    slappend(args, "--");

    for (argv++; *argv != NULL; argv++) slappend(args, *argv);
    slappend(args, NULL);

    if ((pid = fork()) < 0) {
       perror("fork");
       exit(1);
    }

    if (pid == 0) {
       execvp("mawk", sl2vec(args));			/* child  */
       perror("mawk");
       exit(1);
    }
    wait(&status);					/* parent */

    /* debug */
    /* for (a=sl2vec(args); *a != NULL; a++) printf("%s\n", *a); */

    cleanup();
    exit(WEXITSTATUS(status)); 		/* report child exit status */
}

void onintr() {
     cleanup();
     exit(1);
}

void cleanup() {
     unlink(fifo1);
     unlink(fifo2);
}

/* EOF */
