/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite.output;

import java.io.Writer;
import java.util.Date;
import nice.tools.testsuite.TestCase;
import nice.tools.testsuite.TestNice;
import nice.tools.testsuite.TestSuite;
import nice.tools.testsuite.output.AbstractOutput;

public class HtmlOutput
extends AbstractOutput {
    public HtmlOutput(Writer out) {
        super(out);
    }

    @Override
    public void startApplication() {
        this.log("<html><head><title>Nice Testsuite</title></head><body>");
        this.log("<h2>");
        this.log(new Date().toString());
        this.log("</h2>");
        this.log("<table border=1>");
    }

    @Override
    public void endApplication() {
        this.log("</table>");
        this.log("<table><tr><td colspan=2 nowrap>");
        this.log("number of testcases:</td>");
        this.log("<td>" + (TestNice.getTestCasesSucceeded() + TestNice.getTestCasesFailed()) + "<td>");
        this.log("</tr><tr>");
        this.log("<td width=30>&nbsp;</td>");
        this.log("<td>succeeded:</td><td>" + TestNice.getTestCasesSucceeded() + "</td>");
        this.log("</tr><tr>");
        this.log("<td width=30>&nbsp;</td>");
        this.log("<td>failed:</td><td>" + TestNice.getTestCasesFailed() + "</td>");
        this.log("</tr><tr>");
        this.log("<td width=30>&nbsp;</td>");
        this.log("<td>warnings:</td><td>" + TestNice.getTestCasesWarning() + "</td>");
        this.log("</tr></table>");
        this.log("</body></html>");
    }

    @Override
    public void startTestSuite(TestSuite testSuite) {
        this.log("<tr><td>testsuite: " + testSuite.getFile() + "</td></tr>");
    }

    @Override
    public void endTestSuite() {
    }

    @Override
    public void startTestCase(TestCase testCase) {
        this.mark();
        this.log("<tr><td><pre>");
    }

    @Override
    public void endTestCase(boolean pass) {
        if (pass) {
            this.reset();
        } else {
            this.log("</pre></td></tr>");
        }
    }

    @Override
    protected String getLineBreak() {
        return "<br>";
    }
}

