/*
 * Decompiled with CFR 0.152.
 */
package nice.lang.inline;

import bossa.util.User;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Procedure2;
import nice.lang.inline.Tools;

public class NumOp
extends Procedure2
implements Inlineable {
    private static final int error = 0;
    private static final int Sub = 1;
    private static final int Add = 2;
    private static final int Mul = 3;
    private static final int Div = 4;
    private static final int Rem = 5;
    private static final int And = 7;
    private static final int IOr = 8;
    private static final int XOr = 9;
    private static final int Shl = 10;
    private static final int Shr = 11;
    private static final int uShr = 12;
    private final PrimType type;
    private final int kind;

    public static NumOp create(String param) {
        PrimType type = Tools.numericType(param.charAt(0));
        if (type == null) {
            User.error("Unknown type in inlined numeric operator: " + param);
        }
        param = param.substring(1);
        int kind = 0;
        if ("Sub".equals(param)) {
            kind = 1;
        } else if ("Add".equals(param)) {
            kind = 2;
        } else if ("Mul".equals(param)) {
            kind = 3;
        } else if ("Div".equals(param)) {
            kind = 4;
        } else if ("Rem".equals(param)) {
            kind = 5;
        } else if ("And".equals(param)) {
            kind = 7;
        } else if ("IOr".equals(param)) {
            kind = 8;
        } else if ("XOr".equals(param)) {
            kind = 9;
        } else if ("Shl".equals(param)) {
            kind = 10;
        } else if ("Shr".equals(param)) {
            kind = 11;
        } else if ("uShr".equals(param)) {
            kind = 12;
        } else {
            User.error("Unknown inlined numeric operator " + param);
        }
        return new NumOp(kind, type);
    }

    private NumOp(int kind, PrimType type) {
        this.kind = kind;
        this.type = type;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        StackTarget stack = new StackTarget(this.type);
        args[0].compile(comp, stack);
        if (this.kind >= 10 && this.kind <= 12) {
            args[1].compile(comp, Tools.intTarget);
            switch (this.kind) {
                case 10: {
                    code.emitShl();
                    break;
                }
                case 11: {
                    code.emitShr();
                    break;
                }
                case 12: {
                    code.emitUshr();
                }
            }
        } else {
            args[1].compile(comp, stack);
            switch (this.kind) {
                case 1: {
                    code.emitSub(this.type);
                    break;
                }
                case 2: {
                    code.emitAdd(this.type);
                    break;
                }
                case 3: {
                    code.emitMul();
                    break;
                }
                case 4: {
                    code.emitDiv();
                    break;
                }
                case 5: {
                    code.emitRem();
                    break;
                }
                case 7: {
                    code.emitAnd();
                    break;
                }
                case 8: {
                    code.emitIOr();
                    break;
                }
                case 9: {
                    code.emitXOr();
                }
            }
        }
        target.compileFromStack(comp, this.type);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return this.type;
    }

    @Override
    public Object apply2(Object arg1, Object arg2) {
        throw new Error("Not implemented");
    }
}

