/* $Id: dbz-v3.h,v 1.6 1999/03/07 14:58:14 src Exp $
 *
 * for dbm and dbz
 *
 * $Log: dbz-v3.h,v $
 * Revision 1.6  1999/03/07 14:58:14  src
 * Read newsconfig supported. Storage API supported.
 *
 * Revision 1.5  1999/03/05 11:20:33  src
 * Delayed decision of dbz v3 vz. 6 to runtime.
 *
 * Revision 1.4  1999/03/04 17:18:36  src
 * Split between dbz v3 and v6 improved
 *
 * Revision 1.3  1999/03/04 16:19:48  src
 * Renamed dbz v3, and introduced DBZV3_READONLY
 *
 * Revision 1.2  1998/07/12 09:39:19  src
 * NewsX version 1.0
 */

typedef struct {
	char *dptr;
	int dsize;
} dbzv3_datum;

/*
 *  use dbz v3 in read/only mode
 */
#define DBZV3_READONLY 1

/* dbz v3 */
extern int dbzv3_dbminit();
extern dbzv3_datum dbzv3_dbmfetch();
extern int dbzv3_dbmclose();

#if !DBZV3_READONLY
extern int dbzv3_dbmstore();
extern int dbzv3_fresh();
extern int dbzv3_again();
extern dbzv3_datum dbzv3_fetch();
extern int dbzv3_store();
extern int dbzv3_sync();
extern long dbzv3_size();
extern long dbzv3_tagmask();
extern int dbzv3_incore();
extern int dbzv3_writethrough();
extern void (*dbzv3_filedesc())();
extern int dbzv3_cancel();
extern int dbzv3_debug();
#endif /* !DBZV3_READONLY */

/*
 * In principle we could handle unlimited-length keys by operating a chunk
 * at a time, but it's not worth it in practice.  Setting a nice large
 * bound on them simplifies the code and doesn't hurt anything.
 */
#define DBZV3_MAXKEY    255

/*
 *  extension:
 *  read dbz version number
 */
int dbz_version();
