/*
 	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com).
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#include "Asn1HashVal.h"
#include <PKI_ERR.h>
#include <openssl/asn1t.h>

ASN1_SEQUENCE(EXTENSION_VALUE) = {
	ASN1_SIMPLE(EXTENSION_VALUE, name, ASN1_UTF8STRING),
	ASN1_SIMPLE(EXTENSION_VALUE, value, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(EXTENSION_VALUE)
ASN1_SEQUENCE(POLICY_VALUE) = {
	ASN1_SIMPLE(POLICY_VALUE, name, ASN1_UTF8STRING),
	ASN1_SIMPLE(POLICY_VALUE, value, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(POLICY_VALUE)
ASN1_SEQUENCE(PLUG_OPTION) = {
	ASN1_SIMPLE(PLUG_OPTION, name, ASN1_UTF8STRING),
	ASN1_SIMPLE(PLUG_OPTION, value, ASN1_UTF8STRING),
}ASN1_SEQUENCE_END(PLUG_OPTION)
ASN1_SEQUENCE(DN_SPECS) = {
	ASN1_SIMPLE(DN_SPECS, Name, ASN1_UTF8STRING),
	ASN1_SIMPLE(DN_SPECS, Default, ASN1_UTF8STRING),
	ASN1_SIMPLE(DN_SPECS, Comment, ASN1_UTF8STRING),
	ASN1_SIMPLE(DN_SPECS, Min, ASN1_INTEGER),
	ASN1_SIMPLE(DN_SPECS, Max, ASN1_INTEGER),
}ASN1_SEQUENCE_END(DN_SPECS)
ExtensionValue ExtensionValue::EmptyInstance;
bool ExtensionValue::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & ExtensionValue::get_name() const
{
	return m_name;
}

mString & ExtensionValue::get_name()
{
	return m_name;
}

bool ExtensionValue::set_value(const mString & c_value)
{
	m_value = c_value;
	return true;
}

const mString & ExtensionValue::get_value() const
{
	return m_value;
}

mString & ExtensionValue::get_value()
{
	return m_value;
}

ExtensionValue::ExtensionValue():NewPKIObject()
{
	resetAll();
}

ExtensionValue::ExtensionValue(const ExtensionValue & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

ExtensionValue::~ExtensionValue()
{
	Clear();
}

void ExtensionValue::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void ExtensionValue::freeAll()
{
}

void ExtensionValue::resetAll()
{
	m_name = "";
	m_value = "";
}

bool ExtensionValue::load_Datas(const EXTENSION_VALUE * Datas)
{
	Clear();
	if(Datas->name)
	{
		m_name = Datas->name;
	}
	if(Datas->value)
	{
		m_value = Datas->value;
	}
	m_isOk=true;
	return true;
}

bool ExtensionValue::give_Datas(EXTENSION_VALUE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (EXTENSION_VALUE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->name && !((*Datas)->name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->name))
	{
		ASN1_UTF8STRING_free((*Datas)->name);
		(*Datas)->name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->value && !((*Datas)->value = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_value.c_ASN1_UTF8STRING(&(*Datas)->value))
	{
		ASN1_UTF8STRING_free((*Datas)->value);
		(*Datas)->value = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool ExtensionValue::operator=(const ExtensionValue & other)
{
	Clear();
	m_name = other.m_name;
	m_value = other.m_value;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * ExtensionValue::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(EXTENSION_VALUE);
}
PolicyValue PolicyValue::EmptyInstance;
bool PolicyValue::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & PolicyValue::get_name() const
{
	return m_name;
}

mString & PolicyValue::get_name()
{
	return m_name;
}

bool PolicyValue::set_value(const mString & c_value)
{
	m_value = c_value;
	return true;
}

const mString & PolicyValue::get_value() const
{
	return m_value;
}

mString & PolicyValue::get_value()
{
	return m_value;
}

PolicyValue::PolicyValue():NewPKIObject()
{
	resetAll();
}

PolicyValue::PolicyValue(const PolicyValue & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

PolicyValue::~PolicyValue()
{
	Clear();
}

void PolicyValue::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void PolicyValue::freeAll()
{
}

void PolicyValue::resetAll()
{
	m_name = "";
	m_value = "";
}

bool PolicyValue::load_Datas(const POLICY_VALUE * Datas)
{
	Clear();
	if(Datas->name)
	{
		m_name = Datas->name;
	}
	if(Datas->value)
	{
		m_value = Datas->value;
	}
	m_isOk=true;
	return true;
}

bool PolicyValue::give_Datas(POLICY_VALUE ** Datas) const
{
	if(!(*Datas) && !(*Datas = (POLICY_VALUE*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->name && !((*Datas)->name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->name))
	{
		ASN1_UTF8STRING_free((*Datas)->name);
		(*Datas)->name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->value && !((*Datas)->value = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_value.c_ASN1_UTF8STRING(&(*Datas)->value))
	{
		ASN1_UTF8STRING_free((*Datas)->value);
		(*Datas)->value = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool PolicyValue::operator=(const PolicyValue & other)
{
	Clear();
	m_name = other.m_name;
	m_value = other.m_value;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * PolicyValue::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(POLICY_VALUE);
}
PlugOption PlugOption::EmptyInstance;
bool PlugOption::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & PlugOption::get_name() const
{
	return m_name;
}

mString & PlugOption::get_name()
{
	return m_name;
}

bool PlugOption::set_value(const mString & c_value)
{
	m_value = c_value;
	return true;
}

const mString & PlugOption::get_value() const
{
	return m_value;
}

mString & PlugOption::get_value()
{
	return m_value;
}

PlugOption::PlugOption():NewPKIObject()
{
	resetAll();
}

PlugOption::PlugOption(const PlugOption & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

PlugOption::~PlugOption()
{
	Clear();
}

void PlugOption::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void PlugOption::freeAll()
{
}

void PlugOption::resetAll()
{
	m_name = "";
	m_value = "";
}

bool PlugOption::load_Datas(const PLUG_OPTION * Datas)
{
	Clear();
	if(Datas->name)
	{
		m_name = Datas->name;
	}
	if(Datas->value)
	{
		m_value = Datas->value;
	}
	m_isOk=true;
	return true;
}

bool PlugOption::give_Datas(PLUG_OPTION ** Datas) const
{
	if(!(*Datas) && !(*Datas = (PLUG_OPTION*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->name && !((*Datas)->name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->name))
	{
		ASN1_UTF8STRING_free((*Datas)->name);
		(*Datas)->name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->value && !((*Datas)->value = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_value.c_ASN1_UTF8STRING(&(*Datas)->value))
	{
		ASN1_UTF8STRING_free((*Datas)->value);
		(*Datas)->value = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool PlugOption::operator=(const PlugOption & other)
{
	Clear();
	m_name = other.m_name;
	m_value = other.m_value;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * PlugOption::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(PLUG_OPTION);
}
DnSpecs DnSpecs::EmptyInstance;
bool DnSpecs::set_comment(const mString & c_comment)
{
	m_comment = c_comment;
	return true;
}

const mString & DnSpecs::get_comment() const
{
	return m_comment;
}

mString & DnSpecs::get_comment()
{
	return m_comment;
}

bool DnSpecs::set_default(const mString & c_default)
{
	m_default = c_default;
	return true;
}

const mString & DnSpecs::get_default() const
{
	return m_default;
}

mString & DnSpecs::get_default()
{
	return m_default;
}

bool DnSpecs::set_max(unsigned long c_max)
{
	m_max = c_max;
	return true;
}

unsigned long DnSpecs::get_max() const
{
	return m_max;
}

bool DnSpecs::set_min(unsigned long c_min)
{
	m_min = c_min;
	return true;
}

unsigned long DnSpecs::get_min() const
{
	return m_min;
}

bool DnSpecs::set_name(const mString & c_name)
{
	m_name = c_name;
	return true;
}

const mString & DnSpecs::get_name() const
{
	return m_name;
}

mString & DnSpecs::get_name()
{
	return m_name;
}

DnSpecs::DnSpecs():NewPKIObject()
{
	resetAll();
}

DnSpecs::DnSpecs(const DnSpecs & other):NewPKIObject()
{
	resetAll();
	*this = other;
}

DnSpecs::~DnSpecs()
{
	Clear();
}

void DnSpecs::Clear()
{
	freeAll();
	resetAll();
	m_isOk=false;
}

void DnSpecs::freeAll()
{
}

void DnSpecs::resetAll()
{
	m_comment = "";
	m_default = "";
	m_max = 0;
	m_min = 0;
	m_name = "";
}

bool DnSpecs::load_Datas(const DN_SPECS * Datas)
{
	Clear();
	if(Datas->Comment)
	{
		m_comment = Datas->Comment;
	}
	if(Datas->Default)
	{
		m_default = Datas->Default;
	}
	if(Datas->Max)
	{
		m_max = ASN1_INTEGER_GET(Datas->Max);
	}
	if(Datas->Min)
	{
		m_min = ASN1_INTEGER_GET(Datas->Min);
	}
	if(Datas->Name)
	{
		m_name = Datas->Name;
	}
	m_isOk=true;
	return true;
}

bool DnSpecs::give_Datas(DN_SPECS ** Datas) const
{
	if(!(*Datas) && !(*Datas = (DN_SPECS*)ASN1_item_new(get_ASN1_ITEM())))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!(*Datas)->Comment && !((*Datas)->Comment = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_comment.c_ASN1_UTF8STRING(&(*Datas)->Comment))
	{
		ASN1_UTF8STRING_free((*Datas)->Comment);
		(*Datas)->Comment = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Default && !((*Datas)->Default = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_default.c_ASN1_UTF8STRING(&(*Datas)->Default))
	{
		ASN1_UTF8STRING_free((*Datas)->Default);
		(*Datas)->Default = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	if(!(*Datas)->Max && !((*Datas)->Max = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Max, m_max) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Max);
		(*Datas)->Max = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Min && !((*Datas)->Min = (ASN1_INTEGER*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_INTEGER))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(ASN1_INTEGER_set((*Datas)->Min, m_min) <= 0)
	{
		ASN1_INTEGER_free((*Datas)->Min);
		(*Datas)->Min = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_UNKNOWN);
		return false;
	}
	if(!(*Datas)->Name && !((*Datas)->Name = (ASN1_UTF8STRING*)ASN1_item_new(ASN1_ITEM_rptr(ASN1_UTF8STRING))))
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	if(!m_name.c_ASN1_UTF8STRING(&(*Datas)->Name))
	{
		ASN1_UTF8STRING_free((*Datas)->Name);
		(*Datas)->Name = NULL;
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_ABORT);
		return false;
	}
	return true;
}

bool DnSpecs::operator=(const DnSpecs & other)
{
	Clear();
	m_comment = other.m_comment;
	m_default = other.m_default;
	m_max = other.m_max;
	m_min = other.m_min;
	m_name = other.m_name;
	m_isOk=true;
	return true;
}



const ASN1_ITEM * DnSpecs::get_ASN1_ITEM()
{
	return ASN1_ITEM_rptr(DN_SPECS);
}
