/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgSplash.cpp: implementation of the DlgSplash class.
//
//////////////////////////////////////////////////////////////////////

#include <NewPKI.h>
#include "DlgSplash.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgSplash, wxDialog)
    EVT_PAINT  (DlgSplash::OnPaint)
END_EVENT_TABLE()

DlgSplash::DlgSplash(wxWindow * Parent):wxDialog(Parent, (wxWindowID)-1, (Parent?_("About NewPKI..."):""), wxDefaultPosition, wxDefaultSize, (Parent?(wxSYSTEM_MENU | wxCAPTION):(wxFRAME_NO_TASKBAR | wxSTAY_ON_TOP)))
{
	time_t tt1;
	time_t tt2;
	wxString Version;
	DlgSplash_SetWindow(this);
	SetBackgroundColour(*wxWHITE);
	CenterOnScreen();

	Version.sprintf(_("Version: %s"), NEWPKI_VERSION);
	((wxStaticText *)FindWindow(IDC_VERSION))->SetLabel(Version);

	if(Parent)
	{
		ShowModal();
	}
	else
	{
		Show(TRUE);
		
		time(&tt1);
		do
		{
			wxYieldIfNeeded();
			time(&tt2);
		}
		while( (tt2-tt1) <= 2);

		Close(TRUE);
	}
}

DlgSplash::~DlgSplash()
{
}


void DlgSplash::OnPaint(wxPaintEvent &event)
{
	wxPaintDC dc(this);
	PrepareDC(dc);

	dc.BeginDrawing();

    dc.SetBackgroundMode( wxSOLID );
    dc.SetBackground( *wxWHITE_BRUSH );
	dc.Clear();
	dc.EndDrawing();
}
