/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddEntity.h: interface for the DlgAddEntity class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGADDENTITY_H
#define DLGADDENTITY_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif
#include "wx/app.h"
#include "wx/dialog.h"


#include <stdio.h>
#include "Error.h"
#include "DlgMessage.h"
#include <PkiClient.h>


class DlgAddEntity: public wxDialog
{
public:
	DlgAddEntity(wxWindow * wParent, const char * Label, PkiClient * ClientPki);
	virtual ~DlgAddEntity();
	bool IsOK();
	
protected:
	void LoadKeyLen(wxComboBox * window);
	bool AddEntity(const char * EntityName, const char * EntityMail, int EntityType, GenPrivateKey & EntityKey, PubCreationReq & pub_create, const char * RepHost, unsigned int RepPort);
	void OnEngineKey(int idc_lbl_engine, int idc_val_engine, int idc_lbl_server, int idc_val_server);
	void OnServerKey(int idc_lbl_engine, int idc_val_engine, int idc_lbl_server, int idc_val_server);	
	bool m_IsOK;
	PkiClient * m_ClientPki;
};

#endif
