/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAcceptPkiCert.h: interface for the DlgAcceptPkiCert class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGACCEPTPKICERT_H
#define DLGACCEPTPKICERT_H

#include <stdio.h>
#include <stdlib.h>

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif
#include "wx/app.h"
#include "wx/dialog.h"




#ifdef _WIN32
	#include <windows.h>
	#undef FindWindow
#endif

#include <PKI_CERT.h>

class DlgAcceptPkiCert: public wxDialog
{
public:
	bool IsAccepted();
	DlgAcceptPkiCert(wxWindow * wParent, PKI_CERT * cert);
	virtual ~DlgAcceptPkiCert();

	void OnNo(wxCommandEvent& event);
	void OnYes(wxCommandEvent& event);
	void OnShowCert(wxCommandEvent& event);

private:
	bool IsOk;

	PKI_CERT * m_cert;

	DECLARE_EVENT_TABLE()
};

#endif
