/*
  The main function of netgen.
  This file is a modification of tkAppInit.c from the Tcl/Tk package
*/

#include <mystdlib.h>
#include "incvis.hpp"
#include <meshing.hpp>


namespace netgen
{
#include "../libsrc/interface/writeuser.hpp"
  extern string ngdir;
}
 
// using namespace netgen;
using netgen::parameters;
using netgen::ngdir;
using netgen::verbose;
using netgen::ARRAY;
using netgen::RegisterUserFormats;


/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */
// extern "C" int matherr();
int *tclDummyMathPtr = (int *) matherr;


/*
 *
 *     The Netgen main function
 *
 */

int main(int argc, char ** argv)
{

#ifdef NGSOLVE
  cout << "NETGEN/NGSolve V4.4" << endl;
#else
  cout << "NETGEN V4.4" << endl;
#endif
 
  cout << "Developed at Johannes Kepler University Linz, Austria" << endl;

#ifdef OCCGEOMETRY
  cout << "Including OpenCascade geometry kernel" << endl;
#endif

#ifdef DEBUG
  cout << "You are running the debug version !" << endl;
#endif

#ifdef USE_SUPERLU
  cout << "Including sparse direct solver SuperLU by Lawrence Berkeley National Laboratory" << endl;
#else
#ifdef USE_PARDISO
  cout << "Including sparse direct solver Pardiso" << endl;
#endif
#endif


  // command line arguments:
  for (int i = 1; i < argc; i++)
    {
      if (argv[i][0] == '-')
	parameters.SetCommandLineFlag (argv[i]);
      else
	parameters.SetFlag ("geofile", argv[i]);
    }


  if (getenv ("NETGENDIR") && strlen (getenv ("NETGENDIR")))
    ngdir = getenv ("NETGENDIR");
  else
    ngdir = ".";
  
  verbose = parameters.GetDefineFlag ("V");

  if (verbose)
    cout << "NETGENDIR = " << ngdir << endl;


  /*
  extern void Netgen_Test();
  Netgen_Test();
  exit (0);

  extern void NGS_Test();
  NGS_Test();
  exit (0);
  */


  // initialize application
  Tcl_Interp * myinterp = Tcl_CreateInterp ();
  if (Tcl_AppInit (myinterp) == TCL_ERROR)
    {
      cerr << "Exit Netgen due to initialization problem" << endl;
      exit (1);
    }



  // parse tcl-script
  int errcode;

  bool internaltcl = 1;

  if (verbose)
    cout << "Tcl version = " << TCL_PATCH_LEVEL << endl;

  if (parameters.GetDefineFlag ("internaltcl"))
    internaltcl=1;
  if (parameters.GetDefineFlag ("externaltcl"))
    internaltcl=0;

  if (internaltcl)
    {
      if (verbose)
	cout << "using internal Tcl-script" << endl;
      
      // connect to one string 
      extern const char * ngscript[];
      const char ** hcp = ngscript;
      int len = 0;
      while (*hcp)
	{
	  len += strlen (*hcp++); 
	  // hcp++;
	}
      char * tr1 = new char[len+1];
      *tr1 = 0;
      hcp = ngscript;
      
      char * tt1 = tr1;
      while (*hcp)
	{
	  strcat (tt1, *hcp); 
	  tt1 += strlen (*hcp++);
	  // hcp++;
	}
      
      errcode = Tcl_Eval (myinterp, tr1);
      delete [] tr1;
    }

  else

    {
      string startfile = ngdir + "/ng.tcl";
      
      if (verbose)
	cout << "Load Tcl-script from " << startfile << endl;
      
      errcode = Tcl_EvalFile (myinterp, (char*)startfile.c_str());
    }



  if (errcode)
    {
      cout << "Error in Tcl-Script:" << endl;
      cout << "result = " << myinterp->result << endl;
      cout << "in line " << myinterp->errorLine << endl;

      if (myinterp->errorLine == 1)
	cout << "\nMake sure to set environment variable NETGENDIR" << endl;

      exit (1);
    }



  // lookup user file formats and insert into format list:
  ARRAY<const char*> userformats;
  RegisterUserFormats (userformats);

  ostringstream fstr;
  for (int i = 1; i <= userformats.Size(); i++)
    fstr << ".ngmenu.file.filetype add radio -label \"" 
	 << userformats.Get(i) << "\" -variable exportfiletype\n";

  Tcl_Eval (myinterp, (char*)fstr.str().c_str());
  Tcl_SetVar (myinterp, "exportfiletype", "Neutral Format", 0);




  // For adding an application, parse the file here,
  // and call the init-procedure below
  // #define DEMOAPP
#ifdef DEMOAPP  
  Tcl_EvalFile (myinterp, "demoapp/demoapp.tcl");
#endif

#ifdef ADDON
  Tcl_EvalFile (myinterp, "addon/addon.tcl");
#endif

  // start event-loop
  Tk_MainLoop();
  Tcl_DeleteInterp (myinterp); 

  return 0;		
}




extern "C" int Tix_Init (Tcl_Interp * interp);
extern "C" int Itcl_Init (Tcl_Interp * interp);
extern "C" int Itk_Init (Tcl_Interp * interp);
extern "C" int Ng_Init (Tcl_Interp * interp);
extern "C" int Ng_Vis_Init (Tcl_Interp * interp);

// extern Tcl_PackageInitProc * Tk_SafeInit;


/*
 *
 * Initialize packages
 *
 */

int Tcl_AppInit(Tcl_Interp * interp)
{

  if (Tcl_Init(interp) == TCL_ERROR) { 
    cerr << "Problem in Tcl_Init: " << endl;
    cerr << interp->result << endl;
    // return TCL_ERROR;
  }
  
  if (Tk_Init(interp) == TCL_ERROR) {
    cerr << "Problem in Tk_Init: " << endl;
    cerr << interp->result << endl;
    // return TCL_ERROR;
  }


  // if ITcl and ITk are installed on the system, then
  // they must also be initialized
  /*
  if (Itcl_Init(interp) == TCL_ERROR) {
    cerr << "Problem in Itcl_Init: " << endl;
    cerr << interp->result << endl;
    // return TCL_ERROR;
    }

  if (Itk_Init(interp) == TCL_ERROR) {
    cerr << "Problem in Itk_Init: " << endl;
    cerr << interp->result << endl;
    // return TCL_ERROR;
    }
  */

  if (Tix_Init(interp) == TCL_ERROR) {
    cerr << "Problem in Tix_Init: " << endl;
    cerr << interp->result << endl;
    // return TCL_ERROR;
  }
  
  if (Ng_Init(interp) == TCL_ERROR) {
    cerr << "Problem in Ng_Init: " << endl;
    cerr << interp->result << endl;
    // return TCL_ERROR;
  }

  if (Ng_Vis_Init(interp) == TCL_ERROR) {
    cerr << "Problem in Ng_Vis_Init: " << endl;
    cerr << interp->result << endl;
    // return TCL_ERROR;
  }


#ifdef DEMOAPP
  extern int DemoApp_Init (Tcl_Interp * interp);
  if (DemoApp_Init(interp) == TCL_ERROR) 
    {
      return TCL_ERROR;
    }
#endif 
#ifdef ADDON
  extern int AddOn_Init (Tcl_Interp * interp);
  if (AddOn_Init(interp) == TCL_ERROR) 
    {
      return TCL_ERROR;
    }
#endif
#ifdef METIS_OLD
  extern int NgMetis_Init (Tcl_Interp * interp)
    if (NgMetis_Init(interp) == TCL_ERROR) 
      {
	return TCL_ERROR;
      }
#endif    

#ifdef TRAFO
  extern int Trafo_Init (Tcl_Interp * interp);
  if (Trafo_Init(interp) == TCL_ERROR) 
    {
      cerr << "Problem in Trafo_Init: " << endl;
      cerr << interp->result << endl;
      return TCL_ERROR;
    }
#endif



  //#define NGSOLVE
  // #undef NGSOLVE


#ifdef NGSOLVE

  extern int NGSolve_Init (Tcl_Interp * interp);
  if (NGSolve_Init(interp) == TCL_ERROR) 
    {
      cerr << "Problem in NgSolve_Init: " << endl;
      cerr << interp->result << endl;
      return TCL_ERROR;
    }
#endif




#ifdef ZUGSTANGE
  extern int Zugstange_Init (Tcl_Interp * interp);
  if (Zugstange_Init(interp) == TCL_ERROR)
    {
      cerr << "Problem in Zugstange_Init: " << endl;
      cerr << interp->result << endl;
      return TCL_ERROR;
    }
#endif




  Tcl_StaticPackage(interp, "Tk", Tk_Init, 0);

  return TCL_OK;

}
