/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
using Sioux;
using Nemerle.Collections;
using Nemerle.Xml;
using System.Xml;
 
namespace Sioux.Cookies
{
    public class CookiesApp : Application
    {
        
        override protected DoGet() : void
        {
            def sb = System.Text.StringBuilder();
            ignore(sb.Append("[html][head][title]Cookies example</title></head>[body][h4]Cookies sent by your browser:</h4>"));
            def cookies = (this.request.Cookies);

            def loop (lst)
            {
                match(lst)
                {
                    | [] => ()
                    | (cookie : Cookie):: rest =>
                      {
                          ignore(sb.Append("[b]Cookie:</b><br/>name: " + cookie.Name + " value: " + cookie.Value +"<br/>"));
                          loop(rest)
                      }
                }
            }
            loop (cookies);
            ignore(sb.Append("<br/>Send cookie to browser: <br/>"));
            ignore(sb.Append("<form action=\"sendcookie.xml\" method=\"POST\">"));
            ignore(sb.Append("Name:  <input type=\"text\" length=\"20\" name=\"cookiename\" /><br/>"));
            ignore(sb.Append("Value:  <input type=\"text\" length=\"20\" name=\"cookievalue\" /><br/>"));
            ignore(sb.Append("<input type=\"submit\" /></form>"));
            ignore(sb.Append("</body></html>"));

            def doc = XmlDocument();
            doc.LoadXml(sb.ToString());
            
            FormTemplate = Some(XmlTemplate(doc));
        }

        override protected DoPost() : void
        {
            when(PageName == "/sendcookie.xml")
            {
                match( (PostVars.Get("cookiename"),PostVars.Get("cookievalue")))
                {
                    | (Some(name),Some(val)) =>  response.AddCookie(Cookie(name,val));
                    | _ => ()
                }
            }
            DoGet()
        }
    }
}
