/*** PATHFINDER ALGORITHM:
  1. look for not marked, not forbidden field
     1a. if none found, align_to_marker, move, goto 1.
  2. go there,
    2.a if fail, check if it is rock, align_to_marker
                          mark here forbid, move, go to 1.
    2.b                else goto 1  (maybe some timeout)
  3. mark compass
  4. if there is food pickup, turn around, goto coming_home_mark_food
  5. if there is enemy, turn around, goto coming_home_mark_enemy
  6. goto 1

*/



module M {
  public Main () : void {
    def stmts = ants { vars (compass (6), {       
      
      /* -- INITIALIZATION --------------------------------------------
            AND ROLE DECIDER */

      vars (rotations (7), {
        label (ant_role_decider);

        if (rotations <= 5) {
          if (home ^ front) {
            turn (right);
            goto (rotations = rotations + 1, ant_role_decider);
          }
          else {
            when (!(home ^ right))
              when (rand (3)) turn (right);
            mark_rev_compass;
            goto (dfs_pathfinder);
          }
        }
        else
          if (rand (30)) goto (perimeter_defender_ant)
          else
            goto (scout_for_resources)
      });

      /** ---------- DFS PATHFINDER ALGORITHM ------------------- */
      label (dfs_pathfinder);

      /// 1. look for not marked, not forbidden field      
      vars (dfs_rotate (7), {
        label (dfs_find_new1);
        
        /// sometimes come back to home
        when (rand (2000)) goto (carry_food_home);
        
        if (dfs_rotate <= 5) {
          if (vector ^ front)
            goto (dfs_rotate = dfs_rotate + 1, dfs_find_new1)
          else {
            when (!(vector ^ left) && rand (2))
		      turn (left);
            goto (dfs_moving2);
          }
        }
        else
          goto (dfs_none_found)
      });

      //// 1a. if none found, align_to_marker, move, goto 1.
      label (dfs_none_found);
      when (rand (10)) align_to_mark;
      label (dfs_none_found_mov);
      if (move) goto (dfs_find_new1) else {
		if (rand (2))
		  turn (left);
		else
		  turn (right);
        goto (dfs_none_found_mov);
      };

      //// 2. go there,
      label (dfs_moving2);
      if (move) {
        //// 3. mark compass        
        mark_rev_compass;
        goto (dfs_check_properties4)
      }
      else {
        /// 2.a if fail, check if it is rock,
        if (rock ^ front) {
          /// align_to_marker, mark here forbid, move, go to 1.
          align_to_mark;
          // mark (B_FORBID);
          move_timeout (20);
          goto (dfs_find_new1);
        }
        ///  2.b  else goto 1          
        /// (maybe some timeout)
        else {
          when (rand (5)) turn (right);
          goto (dfs_find_new1);
        }
      };

      /// 4. if there is food pickup, turn around, goto coming_home_mark_food
      label (dfs_check_properties4);
      if (food ^ here) {
        turn (right); turn (right); turn (right);
        pickup;
        goto (returner_what = 0, returner_from_scouting);        
      }
      else
      /// 5. if there is enemy, turn around, goto coming_home_mark_enemy
      if (foe (home) ^ front) {
        turn (right); turn (right); turn (right);
        pickup;
        goto (returner_what = 1, returner_from_scouting);
      }
      else
        // 6. goto 1
        goto (dfs_find_new1);
       

      /*** ---------- RETURNER WITH DISCOVERY ------------------ */
      vars (returner_what (2), {
        label (returner_from_scouting);        
        if (returner_what == 0)
          mark (B_FOOD);
        else
          mark (B_ENEMY);
        move_timeout (20);

        if (home ^ here) {
          if (returner_what == 0) {
            drop;
            goto (worker_ant);
          }
          else {
            if (rand (3)) goto (warrior_ant);
            else goto (scout_for_resources);
          }
        }
        else {
          align_to_mark;
          goto (returner_from_scouting);
        }
      });
     
        
      /* -- SCOUT FOR RESOURCES -------------------------------------------- */

      label (warrior_ant);
      label (worker_ant);
      label (scout_for_resources);
      
      /* see if there's any food where we're standing */
      if (home ^ front)
      {
        if (move) {}
        else
          if (rand (2)) turn (right); else turn (left);
        goto (scout_for_resources);
      }
      else {
        when (!(vector ^ front)) goto (dfs_pathfinder);
        
        if (pickup)
          goto (carry_food_home);
        else
        if (food ^ left && !(home ^ left)) {
          turn (left);
          move_timeout (20);
	      goto (worker_ant);          
        }
        else if (food ^ right && !(home ^ right)) {
          turn (right);
          move_timeout (20);
	      goto (worker_ant);          
        }
        else
        if (marker (B_FOOD) ^ here) {
          align_to_rev_mark;
          move_timeout (20);
          goto (worker_ant);
        }
        else {
          if (marker (B_FOOD) ^ front) {}
          else if (marker (B_FOOD) ^ right) turn (right)
          else if (marker (B_FOOD) ^ left) turn (left)
            else {
              if (rand (2))
                turn (right)
              else
                turn (left);
            };
          when (rand (5)) align_to_rev_mark;
          if (move) {
            goto (scout_for_resources);
          }
          else {
            move_timeout (20);
            goto (scout_for_resources);
          }
        }
      };

      /* -- CARRY FOOD HOME ------------------------------------------------ */

      label (carry_food_home);
      if (home ^ here)
      {
        drop;
        turn (right);
        turn (right);
        turn (right);
        goto (scout_for_resources);
      }
      else {
        align_to_mark;
		move_timeout (10);
		goto (carry_food_home);
      };

      /** ---- PERIMETER DEFENDER ANT -------------------------------------- */
      /** on init must be on home */

      label (perimeter_defender_ant);
      /// go until nohome is in front of us
      if (home ^ front) {
        move;
        goto (perimeter_defender_ant)
      }
      else {
        /// prepare to walk around home
        label (perimeter_defender_rotate);
        if (home ^ front)
          if (home ^ left) {
            turn (right);
            goto (perimeter_defender_rotate)
          }
          else goto (perimeter_defender_around)
        else {
          turn (right);
          goto (perimeter_defender_rotate)
        }
      };

      /** walk around seeking food to take it inside */
      label (perimeter_defender_around);
      if (food ^ left) {
        turn (left);
        label (perimeter_defender_side);
        if (move) {
          pickup;
          turn (right);
          turn (right);
          move;
          goto (perimeter_defender_inside1)
        }
        else goto (perimeter_defender_side)
      }
      else
      if (food ^ here) {
        pickup;
        turn (right);
        label (perimeter_defender_inside1);
        if (move) {
          turn (right);
          label (perimeter_defender_inside2);
          move_timeout (20);
          drop;
          goto (perimeter_defender_ant)
        }
        else goto (perimeter_defender_inside1)
      }
      else {
        when (move) goto (perimeter_defender_rotate);
        goto (perimeter_defender_around)
      }
   });

    };

    def cc = StmtCompiler (stmts);
    cc.Compile ();
    cc.Optimize ();
    cc.Output ();
  }
}
