using System;
using System.Runtime.InteropServices;

class PlatformInvokeTest
{
    [DllImport("msvcrt.dll")]
    public extern static puts(c : string) : int;

    [DllImport("msvcrt.dll")]
    internal extern static _flushall() : int;
    
    public static Main() : void
    {
        _ = puts("Test");
        _ = _flushall();
    }
}

class PlatformInvokeTest1
{
      [DllImport("gdi32.dll", CharSet=CharSet.Auto)]
      public static extern CreateFontIndirect(
            [In, MarshalAs(UnmanagedType.LPStruct)] lplf :
            LOGFONT   // characteristics
            ) :  IntPtr;

      [DllImport("gdi32.dll")]
      public static extern DeleteObject(handle :
            IntPtr
            ) :  bool;
}


[StructLayout(LayoutKind.Sequential)]
public class LOGFONT
{
    public static LF_FACESIZE :  int = 32;
    public  mutable  lfHeight : int;
    public  mutable  lfWidth : int;
    public  mutable  lfEscapement : int;
    public  mutable  lfOrientation : int;
    public  mutable  lfWeight : int;
    public  mutable  lfItalic : byte;
    public  mutable  lfUnderline : byte;
    public  mutable  lfStrikeOut : byte;
    public  mutable  lfCharSet : byte;
    public  mutable  lfOutPrecision : byte;
    public  mutable  lfClipPrecision : byte;
    public  mutable  lfQuality : byte;
    public  mutable  lfPitchAndFamily : byte;
//    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=32)]
    public  mutable  lfFaceName : string;
}
