#pragma indent
using Nemerle.Utility

[ExtensionPattern ( Node (t1, el, t2) = SNode (t1, el, t2, _) )] \
[ExtensionPattern ( t1 ::: t2 = SNode (t1, _, t2, _) )] \
public variant Tree
  | SNode 
      l : Tree
      e : int
      r : Tree
      size : int
  | Nil
 
  Size : int
    get
      match (this)
        | SNode (_,_,_,s) => s 
        | Nil => 0
 
  public Node (l : Tree, e : int, r : Tree) : Tree
    SNode (l, e, r, l.Size + r.Size + 1)  

  public Insert (e : int) : Tree
    match (this)
      | Node (l, e', r) =>
        if (e < e') l.Insert (e)
        else if (e > e') r.Insert (e)
        else this
      | Nil =>
        Node (Nil (), e, Nil ())
        

def t = Tree.Nil ().Insert (1).Insert (2).Insert (3)

match (t)
  | Node (_, e, _) =>
    System.Console.WriteLine (e)
  | Nil => assert (false)

match (t)
  | Tree.Node (_, e, _) =>
    System.Console.WriteLine (e)
  | Nil => assert (false)

match (t)
  | Tree.Node (el = e) =>
    System.Console.WriteLine (e)
  | Nil => assert (false)

match (t)
  | _ ::: _ => {}
  | Nil => {}

/*
BEGIN-OUTPUT
3
3
3
END-OUTPUT
*/
