#c_geometry.py

#header generated by Swig

import _PyNEC

def _swig_setattr_nondynamic(self,class_type,name,value,static=1):
    if (name == "this"):
        if isinstance(value, class_type):
            self.__dict__[name] = value.this
            if hasattr(value,"thisown"): self.__dict__["thisown"] = value.thisown
            del value.thisown
            return
    method = class_type.__swig_setmethods__.get(name,None)
    if method: return method(self,value)
    if (not static) or hasattr(self,name) or (name == "thisown"):
        self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)

def _swig_setattr(self,class_type,name,value):
    return _swig_setattr_nondynamic(self,class_type,name,value,0)

def _swig_getattr(self,class_type,name):
    method = class_type.__swig_getmethods__.get(name,None)
    if method: return method(self)
    raise AttributeError,name

import types
try:
    _object = types.ObjectType
    _newclass = 1
except AttributeError:
    class _object : pass
    _newclass = 0
del types

#end of the header genrated by Swig



import exceptions

#class "c_geometry"

class c_geometry(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, c_geometry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, c_geometry, name)
    def __repr__(self):
        return "<%s.%s; proxy of C++ c_geometry instance at %s>" % (self.__class__.__module__, self.__class__.__name__, self.this,)
    
    
    
    def wire(*args):
    	"""
	Add a wire to the geometry,

	All co-ordinates are in meters.
	
		void wire(int tag_id, int segment_count,
			double xw1, double yw1, double zw1,
			double xw2, double yw2, double zw2,
			double rad, double rdel, double rrad)
			

		\param tag_id The tag ID.
		\param segment_count The number of segments.
		\param xw1 The x coordinate of the wire starting point.
		\param yw1 The y coordinate of the wire starting point.
		\param zw1 The z coordinate of the wire starting point.
		\param xw2 The x coordinate of the wire ending point.
		\param yw2 The y coordinate of the wire ending point.
		\param zw2 The z coordinate of the wire ending point.
		\param rad The wire radius (meters)
		\param rdel For tapered wires, the. Otherwise set to 1.0
		\param rrad For tapered wires, the. Otherwise set to 1.0
	"""
	if args[10]>0 and args[11]>0 :
		return _PyNEC.c_geometry_wire(*args)
	else:
		error_msg = 'The last two parameters must both be greater than zero.'
		raise exceptions.RuntimeError(error_msg)    
    
    
    
    def arc(*args):
    	"""
	Add an arc to the geometry,

	All co-ordinates are in meters.

		void arc( int tag_id, int segment_count, double rada,
			double ang1, double ang2, double rad )
			

		\param tag_id The tag ID.
		\param segment_count The number of segments.
		\param rada The radius.
		\param ang1 The angle of the arc starting point.
		\param ang2 The angle of the arc end point.
		\param rad The wire radius.
	"""
	return _PyNEC.c_geometry_arc(*args)
    
    
    
    def helix(*args):
    	"""
	Add an helix to the geometry,

	\remark The helix is a versatile element. For example, to generate a spiral printed circuit antenna, use a helix of zero height.	

	All co-ordinates are in meters.
		
		void helix(int tag_id, int segment_count, double s, double hl, double a1, double b1,
			double a2, double b2, double rad)
			
				
		\param tag_id The tag ID.
		\param segment_count The number of segments.
		\param s The turn spacing.
		\param h1 The total length of the helix (negative for a left-handed helix).
		\param a1 x-start radius.
		\param b1 y-start radius.
		\param a2 x-end radius.
		\param b2 y-end radius.
		\param rad The wire radius.
	"""
	return _PyNEC.c_geometry_helix(*args)
    
    
        
    def move(*args):
    	"""
	Move the structure with respect to its coordinate system or reproduces structure in new positions,
	
	All co-ordinates are in meters and angles are in degrees.
	
		void move( double rox, double roy, double roz, double xs,
			double ys, double zs, int its, int nrpt, int itgi )
			
		
		\param rox The angle in degrees through which the structure is rotated about the X-axis. A positive angle causes a right-hand rotation.  
		\param roy The angle of rotation about Y-axis.
		\param roz The angle of rotation about Z-axis.
		\param xs The x component of vector by which the structure is translated with respect to the coordinate system.
		\param ys The y component of vector by which the structure is translated.
		\param zs The z component of vector by which the structure is translated.
		\param its The tag number of the segments that will be moved. If its = 0 then the entire structure is moved.
		\param nrpt The number of new Structures to be generated.
		\param itgi The tag number increment.
	"""
    	return _PyNEC.c_geometry_move(*args)
	
    
	
    def scale(*args):
    	"""
    	Scale all dimensions of a structure by a constant.
		
		void scale( double xw1)
		
		
		\param xw1 All structure dimensions, including wire radius, are multiplied by xw1.
    	"""
    	return _PyNEC.c_geometry_scale(*args)
	
	
	
    def reflect(*args):
    	"""
	Reflects partial structure along x,y, or z axes.
			
		void reflect_along_axis(int ix, int iy, int iz, int itx)
		
			
		\param ix If ix = 1 then the structure is reflected along X axis. 
		\param iy If iy = 1 then the structure is reflected along Y axis.
		\param iz If iz = 1 then the structure is reflected along Z axis.
		\param itx The tag number increment.
	"""
	return _PyNEC.c_geometry_reflect(*args)
	
	
	
    def generate_cylindrical_structure(*args):
    	"""
	Rotates structure along Z-axis to complete a symmetric structure.
	
		void generate_cylindrical_structure(int itx, int nop)
		
		
		\param itx The tag number increment.
		\param nop The total number of times that the structure is to occur in the cylindrical array.
	"""
	return _PyNEC.c_geometry_generate_cylindrical_structure(*args)
	
	
	
    def arbitrary_shaped_patch(*args):
    	"""
	Add a arbitrary-shaped patch to the geometry
		
	All coordinates are in meters, angles are in radians.
	
		void arbitrary_shaped_patch( nec_float ax1, nec_float ay1, nec_float az1,
						nec_float ax2, nec_float ay2, nec_float az2 )
						
		
		\param ax1 The x-coordinate of patch center.
		\param ay1 The y-coordinate of patch center.
		\param az1 The z-coordinate of patch center.
		\param ax2 The elevation angle above the X-Y plane of outward normal vector.
		\param ay2 The azimuth angle from X-axis of outward normal vector.
		\param az2 The patch area if ny=1.
	"""
	return _PyNEC.c_geometry_arbitrary_shaped_patch(*args)
	
	
	
    def rectangular_patch(*args):
    	"""
	Add a rectangular patch to the geometry
		
	All coordinates are in meters.		
	
		void rectangular_patch( nec_float ax1, nec_float ay1, nec_float az1,
						nec_float ax2, nec_float ay2, nec_float az2,
						nec_float ax3, nec_float ay3, nec_float az3 )
						
			
		\param ax1 The x-coordinate of corner 1.
		\param ay1 The y-coordinate of corner 1.
		\param az1 The z-coordinate of corner 1.
		\param ax2 The x_coordinate of corner 2.
		\param ay2 The y_coordinate of corner 2.
		\param az2 The z-coordinate of corner 2.
		\param ax3 The x_coordinate of corner 3.
		\param ay3 The y_coordinate of corner 3.
		\param az3 The z_coordinate of corner 3.
	"""
	return _PyNEC.c_geometry_rectangular_patch(*args)
	
	
	
    def triangular_patch(*args):
    	"""
	Add a triangular patch to the geometry
		
	All coordinates are in meters.		
	
		void triangular_patch( nec_float ax1, nec_float ay1, nec_float az1,
						nec_float ax2, nec_float ay2, nec_float az2,
						nec_float ax3, nec_float ay3, nec_float az3 )
						
			
		\param ax1 The x-coordinate of corner 1.
		\param ay1 The y-coordinate of corner 1.
		\param az1 The z-coordinate of corner 1.
		\param ax2 The x_coordinate of corner 2.
		\param ay2 The y_coordinate of corner 2.
		\param az2 The z-coordinate of corner 2.
		\param ax3 The x_coordinate of corner 3.
		\param ay3 The y_coordinate of corner 3.
		\param az3 The z_coordinate of corner 3.
	"""
	return _PyNEC.c_geometry_triangular_patch(*args)
	
	
	
    def quadrilateral_patch(*args):
    	"""
	Add a quadrilateral patch to the geometry
		
	All coordinates are in meters.		
	
		void quadrilateral_patch( nec_float ax1, nec_float ay1, nec_float az1,
						nec_float ax2, nec_float ay2, nec_float az2,
						nec_float ax3, nec_float ay3, nec_float az3,
						nec_float ax4, nec_float ay4, nec_float az4 )
						
		
		\param ax1 The x-coordinate of corner 1.
		\param ay1 The y-coordinate of corner 1.
		\param az1 The z-coordinate of corner 1.
		\param ax2 The x_coordinate of corner 2.
		\param ay2 The y_coordinate of corner 2.
		\param az2 The z-coordinate of corner 2.
		\param ax3 The x_coordinate of corner 3.
		\param ay3 The y_coordinate of corner 3.
		\param az3 The z_coordinate of corner 3.
		\param ax4 The x_coordinate of corner 4.
		\param ay4 The x_coordinate of corner 4.
		\param az4 The x_coordinate of corner 4.
	"""
	return _PyNEC.c_geometry_quadrilateral_patch(*args)
	
	
	
    def multiple_patch(*args):
    	"""
	Add a multiple patch to the geometry.
		
	All coordinates are in meters.
	
		void multiple_patch( int nx, int ny,
			nec_float ax1, nec_float ay1, nec_float az1,
			nec_float ax2, nec_float ay2, nec_float az2,
			nec_float ax3, nec_float ay3, nec_float az3,
			nec_float ax4, nec_float ay4, nec_float az4 )
			
		
		\param nx The rectangular surface is divided into nx patches from corner 1 to corner 2.
		\param ny The rectangular surface is divided into ny patches from corner 2 to corner 3.
		\param ax1 The x-coordinate of corner 1.
		\param ay1 The y-coordinate of corner 1.
		\param az1 The z-coordinate of corner 1.
		\param ax2 The x_coordinate of corner 2.
		\param ay2 The y_coordinate of corner 2.
		\param az2 The z-coordinate of corner 2.
		\param ax3 The x_coordinate of corner 3.
		\param ay3 The y_coordinate of corner 3.
		\param az3 The z_coordinate of corner 3.
		\param ax4 The x_coordinate of corner 4.
		\param ay4 The x_coordinate of corner 4.
		\param az4 The x_coordinate of corner 4.
	"""
	if args[1]>0 and args[2]>0:
		return _PyNEC.c_geometry_multiple_patch(*args)
	else:
		error_msg='The first two parameters should both be greater than zero.'
		raise exceptions.RuntimeError(error_msg)
	
	
	
    def __init__(self, *args):
        _swig_setattr(self, c_geometry, 'this', _PyNEC.new_c_geometry(*args))
        _swig_setattr(self, c_geometry, 'thisown', 1)
    def __del__(self, destroy=_PyNEC.delete_c_geometry):
        try:
            if self.thisown: destroy(self)
        except: pass


class c_geometryPtr(c_geometry):
    def __init__(self, this):
        _swig_setattr(self, c_geometry, 'this', this)
        if not hasattr(self,"thisown"): _swig_setattr(self, c_geometry, 'thisown', 0)
        _swig_setattr(self, c_geometry,self.__class__,c_geometry)
_PyNEC.c_geometry_swigregister(c_geometryPtr)
