#include <qpopupmenu.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qfontdialog.h>
#include <qfont.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qcursor.h>
#include <mysql.h>

#include "mdiwindow.h"
#include "mainwindow.h"
#include "include/resource.h"

#include "user.h"
#include "table.h"
#include "script.h"
#include "edit.h"
#include "log.h"
#include "about.h"
#include "query.h"
#include "config.h"

#include <stdio.h>
#include <stdlib.h>

void MainWindow::slot_quit()
{
	if(!open)
	{
		return;
	}

	save_query();

	setCaption(QObject::tr("MySQL Navigator ") + VERSION);

	statusBar()->message(tr("Disconnected..."), 3000);
	
	mysql_close(&mysql);	
	
	open = FALSE;

	slot_close_all();
	
	database->clear();
	
	query->clear();
	
	disable_menu();

	log->clear();
	log->hide();
}

void MainWindow::slot_exit()
{
	close(TRUE);
}

bool MainWindow::slot_database()
{
	QList<QString> value = get_database();
	database->slot_value(value);
	emit signal_database();
	return TRUE;
}

void MainWindow::slot_xpm()
{
	if(option.xpm.isEmpty() == FALSE)
	{
		workspace->setBackgroundPixmap(QPixmap(option.xpm));
		emit signal_xpm(option.xpm);
	}
		
	else
	{
		workspace->setBackgroundPixmap(QPixmap(""));
		emit signal_xpm("");
	}
}

void MainWindow::slot_workspace_clicked()
{
	if(open == FALSE)
		return;

	QPopupMenu *z = new QPopupMenu();

	z->setCaption(tr("MySQL"));	

	z->insertItem(tr("&Schema"),this,SLOT(slot_schema2()), 0, ID_SCHEMA);
	z->insertItem(tr("&User"),this,SLOT(slot_user(int)), 0, ID_USER);	
	z->insertItem(tr("&Privilege"),this,SLOT(slot_privilege()), 0, ID_PRIVILEGE);	
	z->insertItem(tr("T&able"),this,SLOT(slot_table()), 0, ID_TABLE);	
	//z->insertItem(tr("&Field"),this,SLOT(slot_create_field()), 0, ID_FIELD);	
	z->insertItem(tr("&Key"),this,SLOT(slot_key(int)), 0, ID_KEY);	
	z->insertItem(tr("&Query"),this,SLOT(slot_query2()), 0, ID_QUERY);
	z->insertItem(tr("&Process"),this,SLOT(slot_process()), 0, ID_PROCESS);
	z->insertItem(tr("&Xport"),this,SLOT(slot_xport()), 0, ID_XPORT);
	z->insertItem(tr("P&assword"),this,SLOT(slot_password()), 0, ID_PASSWORD);
	z->insertItem(tr("&Script"),this,SLOT(slot_script()), 0, ID_SCRIPT);
	z->insertItem(tr("&Edit"),this,SLOT(slot_edit()), 0, ID_EDIT);
	z->insertItem(tr("&Log"),this,SLOT(slot_log()), 0, ID_LOG);

	z->insertSeparator();
	z->insertItem(tr("&Options..."),this,SLOT(slot_option()), 0, ID_OPTION);
	//z->insertItem(tr("&Flush"), this, SLOT(slot_flush()), 0, ID_FLUSH);
		
	z->popup(QCursor::pos());
}

void MainWindow::slot_terminal()
{
	QString language;

	language.sprintf("%s", getenv("LANG"));

	if(language.isEmpty())
	{
		system("xterm &");
	}
	else
	{
		if(language == QString("ko_KR.EUC") || language == QString("ko"))
		{
			system("hanterm &");
		}
		else
		{
			system("xterm &");
		}
	}
}

void MainWindow::slot_clear_query()
{
	clear_query();
}

void MainWindow::slot_save_query()
{
	save_query();
}

void MainWindow::slot_close()
{
	if(workspace->activeWindow())
		workspace->activeWindow()->close();
}

void MainWindow::slot_close_all()
{
	QWidgetList z = workspace->windowList();
	QWidget  *s;

	for(unsigned int _s = 0; _s < z.count(); _s++)
	{
		s = z.at(_s);
		s->close();
	}
}

void MainWindow::slot_close_all_except_schema()
{
	QWidgetList z = workspace->windowList();
	QWidget  *s;

	for(unsigned int _s = 0; _s < z.count(); _s++)
	{
		s = z.at(_s);
		if(s->caption() != tr("Schema"))
		{
			s->close();
		}
	}
}

void MainWindow::slot_variable()
{
	slot_query("mysql", "show variables", tr("Variables"));
}

void MainWindow::slot_highlight(int z)
{
	switch(z)
	{
		case ID_OPEN:
		{
			statusBar()->message(tr("Open"), 3000);
			break;
		}
		case ID_OPEN2:
		{
			statusBar()->message(tr("Quick Open"), 3000);
			break;
		}
		case ID_QUIT:
		{
			statusBar()->message(tr("Quit"), 3000);
			break;
		}
		case ID_NEW:
		{
			statusBar()->message(tr("New"), 3000);
			break;
		}
		case ID_EXIT:
		{
			statusBar()->message(tr("Exit"), 3000);
			break;
		}
		case ID_CLOSE:
		{
			statusBar()->message(tr("Close"), 3000);
			break;
		}
		case ID_CLOSE_ALL:
		{
			statusBar()->message(tr("Close All"), 3000);
			break;
		}
		case ID_CLOSE_ALL_EXCEPT_SCHEMA:
		{
			statusBar()->message(tr("Close All Except Schema"), 3000);
			break;
		}
		case ID_WINDOWS:
		{
			statusBar()->message(tr("Windows"), 3000);
			break;
		}
		case ID_MOTIF:
		{
			statusBar()->message(tr("Motif"), 3000);
			break;
		}
		case ID_MOTIF_PLUS:
		{
			statusBar()->message(tr("Motif Plus"), 3000);
			break;
		}
		case ID_CDE:
		{
			statusBar()->message(tr("CDE"), 3000);
			break;
		}
		case ID_PLATINUM:
		{
			statusBar()->message(tr("Platinum"), 3000);
			break;
		}
		case ID_SGI:
		{
			statusBar()->message(tr("SGI"), 3000);
			break;
		}
		case ID_JFC:
		{
			statusBar()->message(tr("JFC"), 3000);
			break;
		}
		case ID_NEXTSTEP:
		{
			statusBar()->message(tr("NeXTSTEP"), 3000);
			break;
		}
		case ID_XPORT:
		{
			statusBar()->message(tr("Xport"), 3000);
			break;
		}
		case ID_SCHEMA:
		{
			statusBar()->message(tr("Schema"), 3000);
			break;
		}
		case ID_USER:
		{
			statusBar()->message(tr("User"), 3000);
			break;
		}
		case ID_PRIVILEGE:
		{
			statusBar()->message(tr("Privilege"), 3000);
			break;
		}
		case ID_FIND:
		{
			statusBar()->message(tr("Find"), 3000);
			break;
		}
		case ID_TABLE:
		{
			statusBar()->message(tr("Table"), 3000);
			break;
		}
		case ID_FIELD:
		{
			statusBar()->message(tr("Field"), 3000);
			break;
		}
		case ID_LOG:
		{
			statusBar()->message(tr("Log"), 3000);
			break;
		}
		case ID_QUERY:
		{
			statusBar()->message(tr("Query"), 3000);
			break;
		}
		case ID_FLUSH:
		{
			statusBar()->message(tr("Flush"), 3000);
			break;
		}
		case ID_EDIT:
		{
			statusBar()->message(tr("Edit"), 3000);
			break;
		}
		case ID_SCRIPT:
		{
			statusBar()->message(tr("Script"), 3000);
			break;
		}
		case ID_PROCESS:
		{
			statusBar()->message(tr("Process"), 3000);
			break;
		}
		case ID_PASSWORD:
		{
			statusBar()->message(tr("Password"), 3000);
			break;
		}
		case ID_OPTION:
		{
			statusBar()->message(tr("Options"), 3000);
			break;
		}
		case ID_ABOUT:
		{
			statusBar()->message(tr("About..."), 3000);
			break;
		}
		case ID_QT:
		{
			statusBar()->message(tr("About Qt..."), 3000);
			break;
		}
		case ID_KEY:
		{
			statusBar()->message(tr("Key"), 3000);
			break;
		}
		default:
		{
			statusBar()->message("", 3000);
			break;
		}
	}
}

QList<QString> MainWindow::get_database()
{
	MYSQL_RES *result;
	MYSQL_ROW row; 
	QList<QString> value;
	
	result = mysql_list_dbs(&mysql, NULL);

	if(result == NULL)
	{
		return value;
	}

	while((row = mysql_fetch_row(result)))
	{
		QString *s = new QString;
		*s = row[0];
		value.append(s);
	}

	mysql_free_result(result);

	return value;
}

void MainWindow::slot_font(int)
{
	bool s;
    QFont z = QFontDialog::getFont( &s, font(), this );
    if (s )
		qApp->mainWidget()->setFont(z, TRUE);
 }
