#ifndef _OPIE_CHANGES_H_
#define _OPIE_CHANGES_H_

/* 
   MultiSync Opie Plugin - Synchronize Opie/Zaurus Devices
   Copyright (C) 2003 Tom Foottit <tom@foottit.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES 
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, 
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS 
   SOFTWARE IS DISCLAIMED.
*/

/*
 *  $Id: opie_changes.h,v 1.1 2003/07/11 21:21:04 irix Exp $
 */

#include <multisync.h>

/* get the phonebook changes between the previous sync and the current sync */
gboolean opie_get_phonebook_changes(opie_conn *conn,
                                    GList* contacts,
                                    GList **changes,
                                    GList* categories,
                                    gboolean report_all_data,
                                    gboolean* reset);


/* get the calendar changes between the previous sync and the current sync */
gboolean opie_get_calendar_changes(opie_conn *conn,
                                   GList* calendar,
                                   GList **changes,
                                   GList* categories,
                                   gboolean report_all_data,
                                   gboolean* reset);


/* get the todo changes between the previous sync and the current sync */
gboolean opie_get_todo_changes(opie_conn *conn,
                               GList* todos,
                               GList **changes,
                               GList* categories,
                               gboolean report_all_data,
                               gboolean* reset);


#endif
