/* show news

   Written by Matthias Hensler
   Copyright WSPse 1999-2004
   eMail: matthias@wspse.de

Created: 2000/02/12
Updated: 2004/04/15
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "mp3creat.h"

extern void wuuush(int code);
extern char **is_build_array(char *str, int *lines);
extern void is_popup_text(const char **text, int len, int height);
extern char *copy_char_str(char *old);
extern void free_char_array(char **array);
extern char external_version_str[];
extern char *def_version_str;

int news_get_version(const char *ver_str, int *major, int *minor)
{
  char *pat;
  
  *major = 0;
  *minor = 0;

  if(! ver_str) return 1;
  
  pat = strchr(ver_str, '.');
  if(! pat) pat = strchr(ver_str, '-');
  if(! pat) {
    *minor = atoi(ver_str);
    return 0;
  }

  *minor = atoi(pat+1);
  *major = atoi(ver_str);

  return 0;
}

char *news_insert_text(char *curr, char *new)
{
  if((! curr) || (! new)) return curr;

  curr = (char *) realloc(curr, sizeof(char) * (strlen(curr) + strlen(new) + 2));
  if(! curr) {
    wuuush(1);
  }
  
  strcat(curr, new);

  return curr;
}

char *news_insert_news_item(char *curr, int item)
{
  char *new;

  new = curr;
  
  switch(item) {
    case 29:
      new = news_insert_text(curr, _("New in 0.29:\n"
				     "-presets to switch between MP3/lame and OGG/oggenc   \n"
				     " encodings.                                          \n"
				     "-defaults changed to lame and cdda2wav.              \n"
				     "-some changes to make MP3c more generic (and not MP3 \n"
				     " specific)                                           \n"
				     "\n"
				     "The MP3c lives on release, enjoy 0.29\n"
				     "\n"));
      break;

    case 28:
      new = news_insert_text(curr, _("New in 0.28:\n"
				     "-replace spaces with an own defined character instead\n"
				     " of underscore.                                      \n"
				     "-some batchscript fixes.                             \n"
				     "-a lot of bugfixes.                                  \n"
				     "\n"
				     "The MP3c is not dead release, enjoy 0.28\n"
				     "\n"));
      break;

    case 27:
      new = news_insert_text(curr, _("New in 0.27:\n"
				     "-CDDB.com is not longer useable as CDDB-server.      \n"
				     " please switch to \"freedb.freedb.org:8880\" now.      \n"
				     "-added option to protect patternmasks from           \n"
				     " substitution.                                       \n"
				     "-use different patterns for MP3 and M3U files,       \n"
				     " depending if cd is a sampler with different artists \n"
				     " or just a normal cd with one artist.                \n"
				     "-added possibility to use the encoder for tagging the\n"
				     " files too. If your encoder supports tagging, you    \n"
				     " do not need a seperate program any longer and you   \n"
				     " can disable the tag-program by changing the value to\n"
				     " \"0\".                                                \n"
				     "-improved detection of sampler-cds. Furthermore you  \n"
				     " can force sampler-detection by pressing SHIFT+V     \n"
				     " instead of just \"v\" after inserting a new cd.       \n"
				     "-added support for BSD and 64-bit systems.           \n"
				     "-new and updated translations, as well as the usual  \n"
				     " bugfixes.                                           \n"
				     "\n"
				     "I know it took long, but I hope you enjoy 0.27\n"
				     "\n"));
      break;

    case 26:
      new = news_insert_text(curr, _("New in 0.26:\n"
				     "-Replacestring for unknown genre.                    \n"
				     "-Special handling for illegal characters: removing by\n"
				     " default, or using patternmode (and replacing by     \n"
				     " space or underscore, or removing).                  \n"
				     "-Fixed broken ripping (introduced with 0.25).        \n"
				     "\n"));
      break;

    case 25:
      new = news_insert_text(curr, _("New in 0.25:\n"
				     "-Save CDDB entries by pressing 'm' or transmit them  \n"
				     " to CDDB server by pressing 'M' (transmit requires   \n"
				     " proper settings of SMTP-server, see Options->SMTP   \n"
				     " Server, \"CDDB eMail address\" and \"My eMail\").       \n"
				     "-Press 'd' to get rid of dead files on right side.   \n"
				     "-Open tray after encoding (see Options->Open tray    \n"
				     " after encoding).                                    \n"
				     "-Option to change case of filenames (see             \n"
				     " Options->Case Change).                              \n"
				     "-Totally rewrote directory and filerequester. Please \n"
				     " make sure that you activate the requester in option-\n"
				     " menu.                                               \n"
				     "-Improved key-handling, so that backspace and end-key\n"
				     " should now work even in Xterms                      \n"
				     "-MP3c is now also available via CVS (see READMEs)    \n"
				     "\n"));
      break;

    case 24:
      new = news_insert_text(curr, _("New in 0.24:\n"
				     "-Portuguese translation (done by Lucas Correia Villa \n"
				     " Real)                                               \n"
				     "-Improved handling of relative filenames in playlists\n"
				     "-Usage of more CDDB-servers possible (seperate each  \n"
				     " server by a comma in optionmenu).                   \n"
				     "\n"));
      break;
  }

  return new;
}

void news_show_summery(BOOL windowed)
{
  int old_major_ver, old_minor_ver;
  int new_major_ver, new_minor_ver;
  char *text;
  char **text_array;

  if(news_get_version((const char *) def_version_str, &old_major_ver,
		      &old_minor_ver)) return;
  if(news_get_version((const char *) PRG_VERSION, &new_major_ver,
		      &new_minor_ver)) return;

  text = NULL;
  
  if(old_major_ver != new_major_ver || old_minor_ver > new_minor_ver) {
    text = copy_char_str(_("WARNING\n"
			   "-------\n"
			   "Your configfile is newer than this version\n"
			   "of MP3c. So if you run into trouble please\n"
			   "use a recent version of MP3c.             \n"));
  } else if(old_minor_ver < new_minor_ver) {
    text = (char *) malloc(sizeof(char) * 250);
    if(! text) {
      wuuush(1);
    }
    if(! old_minor_ver) {
      sprintf(text, _("HOT-NEWS\n\n"
		      "You just updated MP3c to Version %d.%d\n\n"),
	      new_major_ver, new_minor_ver);
    } else {
      sprintf(text, _("HOT-NEWS\n\n"
		      "You just updated MP3c from V%d.%d to V%d.%d\n\n"),
	      old_major_ver, old_minor_ver, new_major_ver, new_minor_ver);
    }
    while(new_minor_ver > old_minor_ver) {
      text = news_insert_news_item(text, new_minor_ver);
      new_minor_ver--;
    }
  }

  if(text) {
    if(! windowed) {
      fputc('\n', stdout);
      fputs(text, stdout);
    } else {
      while(text[strlen(text)-1] == '\n') text[strlen(text)-1] = 0;
      text_array = is_build_array(text, &new_major_ver);
      is_popup_text((const char **) text_array, 68, 13);
      free_char_array(text_array);
    }
    free(text);
  }
}

