#ifndef _M_ARRAY_H_
#define _M_ARRAY_H_

#include "mdatatypes.h"

typedef struct {
	mdata **data;
	
	size_t *sorted;
	
	size_t used;
	size_t size;
	
	size_t next_power_of_2;
} marray;

marray *marray_init();
void marray_free(marray *a);
int marray_insert(marray *a, mdata *data);
int marray_insert_replace(marray *a, mdata *data);
size_t *marray_sort_by_count(marray *a);
int marray_is_empty(marray *a);
int marray_append (marray *a, mdata *data);
int marray_write(gzFile *fd, marray *a);
int marray_count(marray *a);
mdata *marray_get_data(marray *a, const char *str);
int marray_in_array(marray *a, const char *str);
double marray_sumup(marray *a);
double marray_sumup_vcount(marray *a);

#endif
