/* -*- mode: c; style: linux -*- */

/* keyboard-properties-xkbsk.c
 * Copyright (C) 2007 Jian Han
 *
 * Written by: Jian Han <jian.han@intel.com>
 *             Horace Li <horace.li@intel.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gdk/gdkx.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>
#include <libxml/parser.h>

#include "capplet-util.h"
#include "gconf-property-editor.h"
#include "capplet-stock-icons.h"

#include <libgnomekbd/gkbd-desktop-config.h>

#include "keyboard-properties-xkb.h"

#define GCONF_VIRTUAL_KEYBOARD_ENTRY "/desktop/moblin/peripherals/keyboard/kbd"
#define GCONF_VIRTUAL_KEYBOARD_LAYOUT GCONF_VIRTUAL_KEYBOARD_ENTRY"/layout"
#define GCONF_VIRTUAL_KEYBOARD_MODEL GCONF_VIRTUAL_KEYBOARD_ENTRY"/model"

static gchar *selectable_layout[] =
{
  "default",
  "simple",
  "dvorak",
  "extended",
  "fi",
  "us"
};

enum
{
   COLUMN_NAME,
   COLUMN_DESCRIPTION,
   COLUMN_LAYOUT,
   NUM_COLUMNS
};

static gboolean set_new_layout (GtkTreeSelection *selection, GtkTreeModel *model, GtkTreePath *path, gboolean path_currently_selected, gpointer data)
{
   GConfClient *client = (GConfClient *)data;
   GtkTreeIter iter;
   gchar *layout = NULL;

   layout = g_new0 (gchar, 16);

   if (FALSE == path_currently_selected)
   {
      if (gtk_tree_model_get_iter (model, &iter, path))
      {
         gtk_tree_model_get (model, &iter, COLUMN_LAYOUT, &layout, -1);
         g_print ("selected layout is %s.\n", layout);
         gconf_client_set_string (client, GCONF_VIRTUAL_KEYBOARD_LAYOUT, layout, NULL);
      }
      else
         g_print ("no selected layout at the moment.\n");
   }
   else
      g_print ("this path is currently selected, will be unselected.\n");

   if (layout)
      g_free (layout);

   return TRUE;
}

static void append_model (GtkTreeModel *model, gchar *name, gchar *desc, gchar *layout)
{
   GtkTreeIter iter;

   gtk_list_store_append (GTK_LIST_STORE (model), &iter);
   gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                       COLUMN_NAME, name,
                       COLUMN_DESCRIPTION, desc,
                       COLUMN_LAYOUT, layout,
                       -1);
}

static void generate_layout_tree_view (GtkWidget *treeview, const gchar *layout_list)
{
   GtkTreeModel *model;
   xmlDoc *doc = NULL;
   xmlNode *root = NULL, *list, *iter;
   gchar *name = NULL, *desc = NULL, *layout = NULL, *lang = NULL;
   gchar *deflang;
   int i;

   if((deflang = g_getenv("LANG")) != NULL)
   {
      deflang = g_strdup(deflang);
      g_strdelimit(deflang, ".", '\0');
      g_debug("deflang = %s\n", deflang);
   }

   model = gtk_tree_view_get_model (GTK_TREE_VIEW(treeview));

   doc = xmlParseFile (layout_list);
   root = xmlDocGetRootElement (doc);

   if (NULL == root)
      return;

   for (list = root->children; list != NULL; list = list->next)
   {
      if (strcmp ((gchar *)list->name, "layout"))
         continue;

      name = desc = layout = NULL;

      /* first scan to see if the exact current language is found */
      for (iter = list->children; iter != NULL; iter = iter->next)
      {
         if (!strcmp ((gchar *)iter->name, "name")) {
            if(((lang=(gchar *)xmlNodeGetLang(iter))!=NULL)&&
                deflang && !strcmp (lang, deflang))
                name = g_strstrip ((gchar *)iter->last->content);
         } else if (!strcmp ((gchar *)iter->name, "description")) {
            if(((lang=(gchar *)xmlNodeGetLang(iter))!=NULL)&&
                deflang && !strcmp (lang, deflang))
                desc = g_strstrip ((gchar *)iter->last->content);
         } else if (!strcmp ((gchar *)iter->name, "layoutid")) {
            layout = g_strstrip ((gchar *)iter->last->content);
         }
      }

      /* next scan to see if general current language is found */
      g_strdelimit(deflang, "_", '\0');

      for (iter = list->children; (name == NULL) && (iter != NULL);
           iter = iter->next)
      {
         if (!strcmp ((gchar *)iter->name, "name")) {
            if(((lang=(gchar *)xmlNodeGetLang(iter))!=NULL)&&
                deflang && !strcmp (lang, deflang))
                name = g_strstrip ((gchar *)iter->last->content);
         }
      }

      for (iter = list->children; (desc == NULL) && (iter != NULL);
           iter = iter->next)
      {
         if (!strcmp ((gchar *)iter->name, "description")) {
            if(((lang=(gchar *)xmlNodeGetLang(iter))!=NULL)&&
                deflang && !strcmp (lang, deflang))
                desc = g_strstrip ((gchar *)iter->last->content);
         }
      }

      /* last, scan for the default */
      for (iter = list->children; (name == NULL) && (iter != NULL);
           iter = iter->next)
      {
         if (!strcmp ((gchar *)iter->name, "name"))
            name = g_strstrip ((gchar *)iter->last->content);
      }

      for (iter = list->children; (desc == NULL) && (iter != NULL);
           iter = iter->next)
      {
         if (!strcmp ((gchar *)iter->name, "description"))
            desc = g_strstrip ((gchar *)iter->last->content);
      }

      if (name && desc && layout)
         append_model (model, name, desc, layout);
   }
   if(deflang) g_free(deflang);
}

void setup_xkbsk_tabs (GladeXML * dialog, GConfChangeSet * changeset)
{
  GtkWidget *treeview = WID ("layouts_treeview");
  GtkTreeModel *model;
  GtkTreeSelection *selection;
  GtkCellRenderer *renderer;
  GtkWidget *mokoscroll = WID ("scrolledwindow7");
  GConfClient *client;
  GError *error = NULL;
  gchar *layout_list, *current_layout;
	
  gconf_init (0, NULL, NULL);
  client = gconf_client_get_default ();

  current_layout = gconf_client_get_string (client,
                                            GCONF_VIRTUAL_KEYBOARD_LAYOUT,
                                            &error);

  if (error)
  {
    g_print ("setup_xkbsk_tabs::failed to get current layout, error is %s.\n ", error->message);
    current_layout = NULL;
  }

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
                                               -1,      
                                               _("Name"),  
                                               renderer,
                                               "text", COLUMN_NAME,
                                               NULL);

  renderer = gtk_cell_renderer_text_new ();
  gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
                                               -1,      
                                               _("Description"),  
                                               renderer,
                                               "text", COLUMN_DESCRIPTION,
                                               NULL);

  selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(treeview));
  gtk_tree_selection_set_mode (selection, GTK_SELECTION_SINGLE);
  gtk_tree_selection_set_select_function (selection, set_new_layout, client, NULL);

  model = GTK_TREE_MODEL (gtk_list_store_new (NUM_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING));
  gtk_tree_view_set_model (GTK_TREE_VIEW (treeview), model);

  layout_list = g_build_filename (g_get_home_dir (), ".moblin-applets", "keyboard-layouts.xml", NULL);
  if (!g_file_test (layout_list, G_FILE_TEST_EXISTS))
  {
    gchar *default_layout_list;
    gsize default_layout_list_len;

    if ((!g_mkdir_with_parents (g_path_get_dirname (layout_list), 755)) &&
        (g_file_get_contents (MA_XML_DIR "/keyboard-layouts.xml", 
                              &default_layout_list, 
                              &default_layout_list_len, NULL)))
      g_file_set_contents (layout_list, default_layout_list, default_layout_list_len, NULL);
  }

  generate_layout_tree_view (treeview, layout_list);

  g_object_set (G_OBJECT(mokoscroll), "hindicator_mode", 2);
  g_object_set (G_OBJECT(mokoscroll), "vindicator_mode", 0);

  gtk_container_add (GTK_CONTAINER(mokoscroll), treeview);
  gtk_widget_show (mokoscroll);

  gtk_widget_hide (WID ("auto_launch_tb"));
  gtk_widget_hide (WID ("checkbutton2"));
#if 0
  //Set up previously selected layouts.
  for (guint index = 0; (current_layout && selectable_layout[index]); index++)
  {
    if (!g_ascii_strcasecmp(current_layout, selectable_layout[index]))
    {
      gtk_combo_box_set_active (GTK_COMBO_BOX(WID("layout_select_cb")), index);
      break;
    }
  }
#endif
}

