///////////////////////////////////////////////////////////////////////////////
// $Id: maptool.h,v 1.1 2004/03/28 20:44:09 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    maptool.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the base class for map editor tools
*/

#ifndef MAPTOOL_H
#define MAPTOOL_H

// forward declarations
class MapDocument;
class QRect;

class MapTool
{
public:
	MapTool(MapDocument* doc) : m_doc(doc) {}

	virtual ~MapTool() {}

	virtual void activate() = 0;

	virtual bool usedMousePress(uint /*row*/, uint /*col*/, int /*button*/) {
		return false;
	}

	virtual bool usedMouseRelease(uint /*row*/, uint /*col*/, int /*button*/) {
		return false;
	}

	virtual bool usedMouseDoubleClick(uint /*row*/, uint /*col*/, int /*button*/) {
		return false;
	}

	virtual bool usedMouseMove(uint /*row*/, uint /*col*/, int /*buttons*/) {
		return false;
	}

	virtual bool coversTileAt(uint /*row*/, uint /*col*/) const = 0;

	virtual QRect coverArea() const = 0;

protected:
	MapDocument* m_doc;
};

#endif

// End of file
