#ifndef GRENADE_H
#define GRENADE_H

#include "MovingObjectBase.h"

class MortarBarrel;
class MortarBase;

#define GRENADE_VELOCITY 300


//----------------------------------------------------------------------------
class GrenadeSurfaces : public SingleSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(GrenadeSurfaces);

  public:
    //------------------------------------------------------------------------
    void getGrenadeSize(Uint16 &w, Uint16 &h) const;
};


//----------------------------------------------------------------------------
#undef DECLARE_WARHEAD_STRATEGY
#define DECLARE_WARHEAD_STRATEGY(c) \
    class c; \
    friend class c; \
    class c : public WarheadStrategy \
    { \
        STRATEGY_OBJECT(c); \
      public: \
        c() {} \
        ~c() {} \
        void onCreateExplosionParticles(const Grenade *grenade) const; \
    }


//----------------------------------------------------------------------------
class Grenade : public MovingObjectBase
{
  public:
    //------------------------------------------------------------------------
    enum EnumWarheadStrategy
    {
        WH_NONE,
        WH_STARBURST
    };

  private:

    //------------------------------------------------------------------------
    /**
     * A base class for all warhead strategies.
     */
    class WarheadStrategy
    {
      public:
        virtual ~WarheadStrategy() {}

        virtual void onCreateExplosionParticles(const Grenade *grenade) const = 0;

        static WarheadStrategy *getStrategy(EnumWarheadStrategy s);

      protected:
        WarheadStrategy() {}
    };

    DECLARE_WARHEAD_STRATEGY(NoWarheadStrategy);
    DECLARE_WARHEAD_STRATEGY(StarBurstWarheadStrategy);


  public:

    //------------------------------------------------------------------------
    Grenade(EnumWarheadStrategy warhead, const unsigned creatorId);
    virtual ~Grenade();

    //------------------------------------------------------------------------
    inline bool isExplode() const { return m_explode; }

    //------------------------------------------------------------------------
    void update();

    //------------------------------------------------------------------------
    void updateSurface();

    //------------------------------------------------------------------------
    /**
     * Called via the CreateExplosionParticleConstVisitor.
     */
    inline void onCreateExplosionParticles() const
    {
        m_warheadStrategy->onCreateExplosionParticles(this);
    }

    //------------------------------------------------------------------------
    inline void setLifeCount(unsigned lifeCount)
    {
        m_lifeCount = lifeCount;
    }

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    //------------------------------------------------------------------------
    /// The number of frames, this grenade will live.
    unsigned m_lifeCount;

    /// Set to true, if this grenade shall be removed from the playground.
    bool m_explode;

    //------------------------------------------------------------------------
    WarheadStrategy *m_warheadStrategy;
};

#endif //GRENADE_H
