***********************************************************************

C        MORTRAN 2.79 (BRACKETED KEYWORD MACROS OF 09/28/81)
C THIS IS A COLLECTION OF SUBROUTINES -WRITTEN IN FORTRAN-
C THAT WILL SMOOTH A GIVEN SEQUENCE OF DATA POINTS.
C THE ALGORITHM IS BY J W TUKEY AND ALBERTO TUBILLIO, AND THE
C CODING IS MOSTLY BY ROGER CHAFFEE.
C TO USE IT MAKE THE FOLLOWING CALL :
C
C             CALL SMCTRL (SMY,Y,N,LEVEL,F,E)
C WHERE
C SMY,Y,F,E ARE ONE-DIMENSIONAL ARRAYS OF BINS N AND
C LEVEL IS A SMOOTHING LEVEL, FROM 0 TO 5.
C Y SHOULD CONTAIN THE SEQUENCE TO BE SMOOTHED,
C AT THE COMPLETION OF THE CALL  Y IS LEFT UNMODIFIED AND
C SMY GIVES THE SMOOTHED SEQUENCE.
C F AND E ARE DUMMY ARRAYS NEEDED IN THE COMPUTATION.
C SMOOTH CALLS IN TURN THE SUBROUTINES:
C              SMRMED
C              SMRMEN
C              SMQHAN
C              SMSORT
C THESE FORM THE REST OF THE COLLECTION.
C        ***********NOTES***************
C Y IS ASSUMED TO BE THE SEQUENCE OF OBSERVED VALUES OF A
C FUNCTION  AT EQUALLY SPACED INTERVALS.
C THE SMOOTHER PROCEDURE IS A NON-LINEAR ONE WHICH SO FAR
C HAS PROVED TO BE THE BEST AMONG SEVERAL ONES CURRENTLY
C STUDIED  AT SLAC.
C AS OPPOSED TO LINEAR PROCEDURES ITS PERFORMANCE SHOULDN'T
C BE IMPAIRED IF THE DATA IS NOT WELL BEHAVED.
      SUBROUTINE SMCTRL (G,D,K,LEVEL,F,E)
      DIMENSION G(K),D(K),F(K),E(K)
      DIMENSION N1LEV(6),N2LEV(6)
      DATA N1LEV(1),N1LEV(2),N1LEV(3),N1LEV(4),
     1   N1LEV(5),N1LEV(6) /1,3,5,7,9,11/
      DATA N2LEV(1),N2LEV(2),N2LEV(3),N2LEV(4),
     1   N2LEV(5),N2LEV(6) /1,1,3,3,5,5/
C
      IF (K.LE.0) RETURN
      L=MAX0(0,MIN0(5,LEVEL))+2
 10   L=L-1
      N1=N1LEV(L)
      N2=N2LEV(L)
      IF (N1.GT.K) GO TO 10
      CALL SMRMED (G,D,K,N1)
         IF (K.LT.3) RETURN
C                 ENDPOINTS ARE SPECIAL
C                 USE G(1)=MEDIAN(D(1),G(2),3G(2)-2G(3))
         E(1)=D(1)
         E(2)=G(2)
         E(3)=3.*G(2)-2.*G(3)
         CALL SMSORT (E,3)
         G(1)=E(2)
         E(1)=D(K)
         E(2)=G(K-1)
         E(3)=3.*G(K-1)-2.*G(K-2)
         CALL SMSORT (E,3)
         G(K)=E(2)
      CALL SMRMED (F,G,K,N2)
      CALL SMQHAN (G,F,K)
      DO 20 KR=1,K
      F(KR)=D(KR)-G(KR)
 20   E(KR)=F(KR)
C                 G HAS SMOOTH. E AND F HAVE RESIDUALS
C                            GET 25-PERCENTILE POINTS
      CALL SMSORT (E,K)
      KM=MAX0(1,K/4)
      DQU=E(KM)
      I=K+1-KM
      UQU=E(I)
      STEP=AMAX1(0.2,1.5*(UQU-DQU))
      STEP2=STEP+STEP
C              CHANGE LARGE RESIDUALS
      DO 30 I=1,K
         IF (ABS(F(I)).GT.STEP) F(I)=SIGN(DIM(STEP2,ABS(F(I))),F(I))
 30   CONTINUE
C              SMOOTH THE CHANGED RESIDUALS
      CALL SMRMEN (E,F,K,N1)
      CALL SMRMED (F,E,K,N2)
      CALL SMQHAN (E,F,K)
C              ADD THEM BACK TO THE FIRST SMOOTHED VALUES
      DO 40 KR=1,K
 40   G(KR)=G(KR)+E(KR)
C                 END OF SMOOTH.  DO ANOTHER, W/O CHANGING RESIDUALS
      CALL SMRMEN (E,G,K,N1)
      CALL SMRMED (F,E,K,N2)
      CALL SMQHAN (E,F,K)
      DO 50 KR=1,K
 50   F(KR)=G(KR)-E(KR)
      CALL SMRMEN (G,F,K,N1)
      CALL SMRMED (F,G,K,N2)
      CALL SMQHAN (G,F,K)
      DO 60 KR=1,K
 60   G(KR)=E(KR)+G(KR)
      RETURN
      END
