      PROGRAM MN_LATEX
C      subroutine MN_LATEX
C
C     CONVERTS THE MN_FIT_HELP AND MINUIT_HELP FILES TO A LATEX
C     WRITE-UP
C
#include "mndir.inc"
#include "mnchar.inc"
C
      INTEGER MLINE_PP
      PARAMETER (MLINE_PP = 46)
C
      LOGICAL QVERB,QUPC,QPRINT,QEXAMPLE,QNOSWITCH,QIGNORE
      CHARACTER*255 TXTI,TXTO,TEXT
      CHARACTER*80 CONCT0
      CHARACTER*10 TJUNK(1)
      CHARACTER*80 COMAND(4),COMND2(4),TTMP
      CHARACTER*20 SECTION(4)
      CHARACTER*8 TVERS,TVERS2,TFORMAT
      CHARACTER*255 TFILE
      integer lenh,lend,lens,lnblnk
C
      DATA TJUNK/' '/
      DATA SECTION/4*' '/
C
      TAB = CHAR(9)
      BSL = CHAR(92)
      section(1) = bsl // 'section'
      section(2) = bsl // 'subsection'
      section(3) = bsl // 'subsubsection'
      section(4) = bsl // 'paragraph'
      CALL TYPINI
C
      CALL M_HOME
C
C     Find out whether the full document is required
C
500   CONTINUE
*ICB      CALL WAITYP(
*ICB     + 'Give Mn_Util version number n/mm.ll (0 for complete manual): ')
*ICB      NCHAR = ISTTYP(.TRUE.,IDELIM,TVERS)
*ICB      IF(NCHAR.LE.0) GOTO 9900
      TVERS = '0'
      NCHAR = 1
      IF(TVERS(1:NCHAR).EQ.'0') THEN
          NVERS1 = 0
          TVERS2 = ' '
      ELSE
          IND1 = INDEX(TVERS(1:NCHAR),'/')
          IND2 = INDEX(TVERS(1:NCHAR),'.')
          IF(IND1.LE.0 .OR. IND2.LE.0) THEN
              WRITE(6,'('' Error in version number: '',A
     +         ,'', Set to 0'')')
     +         TVERS(1:NCHAR)
              NVERS1 = 0
              TVERS2 = ' '
              GOTO 600
          ENDIF
          NCH = IND1 - 1
          WRITE(TFORMAT,'(''(I'',I1)') NCH
          READ(TVERS(1:IND1-1),TFORMAT) NVERS1
          NCH = IND2 - IND1 - 1
          WRITE(TFORMAT,'(''(I'',I1)') NCH
          READ(TVERS(1:IND1-1),TFORMAT) NVERS2
          NCH = NCHAR - IND2
          WRITE(TFORMAT,'(''(I'',I1)') NCH
          READ(TVERS(1:IND1-1),TFORMAT) NVERS3
          TVERS2 = TVERS(1:IND1-1) // '_' //
     +             TVERS(IND1+1:IND2-1) // '_' //
     +             TVERS(IND2+1:NCHAR)
          LVERS2 = LNBLNK(TVERS2)
      ENDIF
 600  CONTINUE
c
      CALL ICMSYM('_-'//BSL)
C
      LENH = LNBLNK(TMNHLP)
      LEND = LNBLNK(TMNDOC)
      LENS = LNBLNK(TMNSRC)
      TFILE = TMNDOC(1:LEND) // 'mn_fit.tex'
      OPEN(UNIT=10,FILE=TFILE,STATUS='UNKNOWN',FORM='FORMATTED'
#if ( defined(VMS) )
     2 ,CARRIAGECONTROL='LIST')
#endif
#if ( !defined(VMS) )
     2 )
#endif

C
      TFILE = TMNSRC(1:LENS) // 'manual/mn_header.tex'
      OPEN(UNIT=11,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
      TFILE = TMNSRC(1:LENS) // 'manual/mn_intro.tex'
      OPEN(UNIT=12,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
      TFILE = TMNSRC(1:LENS) // 'manual/min_intro.tex'
      OPEN(UNIT=13,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
      TFILE = TMNSRC(1:LENS) // 'manual/mn_appendix.tex'
      OPEN(UNIT=22,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
      TFILE = TMNHLP(1:LENH) // 'mn_fit_help.fil'
      OPEN(UNIT=2,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
      TFILE = TMNHLP(1:LENH) // 'minuit_help.fil'
      OPEN(UNIT=3,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
C     First write out the LaTeX header and the title page
C
      NUNIT = 11
1000  CONTINUE
      TXTI = ' '
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 1100
      CALL MN_WRIT(TXTI)
      GOTO 1000
C
C     WRITE OUT THE INTRODUCTION
C
1100  CONTINUE
      QVERB = .FALSE.
      QIGNORE = .FALSE.
      QNOSWITCH = .FALSE.
      NUNIT = 2
1500  CONTINUE
      TXTI = ' '
      CALL MN_READ(10+NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 1900
      IF(TXTI.EQ.BSL//'begin{verbatim}') THEN
          QVERB = .TRUE.
      ELSEIF(TXTI.EQ.BSL//'end{verbatim}}') THEN
          QVERB = .FALSE.
      ENDIF
      CALL MN_INTERP(TXTI,QVERB,1)
C
C     Convert "see HELP ..." into see section nn (...)
C
      CALL MN_XREF(TXTI)
      CALL MN_WRIT(TXTI)
      GOTO 1500
C
C     GET ALL THE LOWER CASE HELP STUFF FIRST. JUST LATEX THIS
C     BUT SWITCH TO VERBATIM FOR LISTS
C     SKIP ALL THIS IN MINUIT. JUST USE THE INTRODUCTION THERE
C
1900  CONTINUE
      QVERB = .FALSE.
2000  CONTINUE
      IF(NUNIT.EQ.3) GOTO 2900
      TXTI = ' '
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 2900
      IF(TXTI(1:1).EQ.'!') GOTO 2000
      CALL MN_INTERP(TXTI,QVERB,0)
      IF(TXTI(1:1).EQ.' ' .OR. TXTI(1:1).EQ.TAB) GOTO 2000
2100  CONTINUE
      CALL QUOTYP(TXTI)
      LENT = LNBLNK(TXTI)
      LEVEL = INTTYP(.TRUE.,IDELIM)
      IF(ICHAR(TXTI(4:4)).GE.ICHAR('A') .AND.
     1   ICHAR(TXTI(4:4)).LE.ICHAR('Z')) GOTO 2000
      TEXT = TXTI(3:LENT)
      COMAND(LEVEL) = TEXT
C
C     SKIP MENUS, INTRODUCTION, AND EXAMPLES EXCEPT THE TOP LEVEL
C     AND ALSO SKIP CHANGES AND NUMBERS
C
      IF(TEXT.EQ.'Menu') GOTO 2000
      IF(TEXT.EQ.'Introduction') GOTO 2000
      IF(TEXT.EQ.'Changes') GOTO 2000
      IF(TEXT.EQ.'Numbers') GOTO 2000
c      IF(TEXT.EQ.'Text') GOTO 2000
      IF(LEVEL.GT.1 .AND. TEXT(1:7).EQ.'Example') GOTO 2000
      IF((NUNIT.EQ.2 .AND. LEVEL.GT.1) .OR.
     1   (NUNIT.EQ.3 .AND. LEVEL.GT.2))GOTO 2000
C
      LENS = LNBLNK(SECTION(LEVEL))
      LENO = LNBLNK(COMAND(LEVEL))
C
C     If there is an \_ in the title and the next character is an upper case
C     or the next 2 characters are upper case followed by lower case
C     or the next character is lower case
C     and the text is not Mn_Fit get rid of the _
C
      N1 = 1
      COMND2(LEVEL) = COMAND(LEVEL)
      LEN2 = LENO
 2140 CONTINUE
      IND = INDEX(COMND2(LEVEL)(n1:),BSL//'_')
      IF(IND.GT.0) THEN
          n2 = N1 + IND - 1
          IF((ICHAR(COMND2(LEVEL)(N2+2:N2+2)).GE.ICHAR('A') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+2:N2+2)).LE.ICHAR('Z') .AND.
     +        ICHAR(COMND2(LEVEL)(N2-1:N2-1)).GE.ICHAR('a') .AND.
     +        ICHAR(COMND2(LEVEL)(N2-1:N2-1)).LE.ICHAR('z')) .OR.
     +       (ICHAR(COMND2(LEVEL)(N2+2:N2+2)).GE.ICHAR('a') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+2:N2+2)).LE.ICHAR('z')) .OR.
     +       (ICHAR(COMND2(LEVEL)(N2+2:N2+2)).GE.ICHAR('A') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+2:N2+2)).LE.ICHAR('Z') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+3:N2+3)).GE.ICHAR('a') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+3:N2+3)).LE.ICHAR('z'))) THEN
              IF(COMND2(LEVEL)(N2-2:N2+4).EQ.'Mn'//BSL//'_Fit' .OR.
     +           COMND2(LEVEL)(N2-2:N2+4).EQ.'MN'//BSL//'_FIT') THEN
              ELSE
                  TTMP = COMND2(LEVEL)(:N2-1) //
     +             ' ' // COMND2(LEVEL)(N2+2:)
                  COMND2(LEVEL) = TTMP
                  LEN2 = LEN2 - 1
              ENDIF
              N1 = N2 + 1
              IF(N1.LT.LENO) GOTO 2140
          ENDIF
      ENDIF
C
C     NOW WE HAVE A LOWER CASE ITEM
C
      NREC = 0
      QVERB = .FALSE.
      CALL MN_WRIT(' ')
      WRITE(TXTO,'(A,''{'',A,''}%'')') SECTION(LEVEL)(1:LENS)
     1 ,COMND2(LEVEL)(1:LEN2)
      CALL MN_WRIT(TXTO)
C
C     Add an index reference
C
      TXTO = BSL//'index{'
      do i=1,level
          if(i.gt.1) then
              ttmp = conct0(txto,'!')
              txto = ttmp
          endif
          LENc = LNBLNK(comnd2(i))
          ttmp = conct0(txto,comnd2(i)(:lenc))
          txto = ttmp
      enddo
      ttmp = txto
*ICB      txto = conct0(ttmp,'|bb}%')
      txto = conct0(ttmp,'|textbf}%')
      CALL MN_WRIT(TXTO)
C
CICB      ttmp = conct0(txto,BSL//'label{')
CICB      TXTO = ttmp
      txto = BSL//'label{'
      CALL M_LUPC(COMAND(LEVEL),TTMP)
2160  CONTINUE
      IND = INDEX(TTMP,BSL)
      IF(IND.GT.0) THEN
          TEXT = TTMP(1:IND-1) // TTMP(IND+1:)
          TTMP = TEXT
          GOTO 2160
      ENDIF
      LENT = LNBLNK(TTMP)
      TEXT = CONCT0(TXTO,TTMP)
      TXTO = CONCT0(TEXT,'}')
      CALL MN_WRIT(TXTO)
C
2200  CONTINUE
      TXTI = ' '
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 2900
C
      IF(QIGNORE) THEN
          QIGNORE = .FALSE.
          GOTO 2200
      ENDIF
C
      CALL MN_COMMENT(TXTI,QVERB,QIGNORE,QNOSWITCH,IERR)
      IF(IERR.NE.0) GOTO 2200
      CALL MN_INTERP(TXTI,QVERB,0)
C
C     IF WE FIND THE NEXT HELP TOPIC AT THE SAME LEVEL THEN CHECK
C     IT OUT, OTHERWISE JUST MAKE A SUBTOPIC AND KEEP GOING
C
      NREC= NREC + 1
      IF(QVERB .AND. TXTI.EQ.' ') THEN
          IF(NREC.GT.1) THEN
              CALL MN_WRIT(BSL//'end{verbatim}}')
              CALL MN_WRIT(BSL//'par'//BSL//'noindent')
              QVERB = .FALSE.
          END IF
          GOTO 2200
      END IF
C
      IF(TXTI(1:1).NE.' ' .AND. TXTI(1:1).NE.TAB) THEN
          CALL QUOTYP(TXTI)
          LEVEL2 = INTTYP(.TRUE.,IDELIM)
          IF(LEVEL.EQ.LEVEL2) THEN
              GOTO 2100
          ELSE
              LENT = LNBLNK(TXTI)
              TEXT = TXTI(3:LENT)
              COMAND(LEVEL2) = TEXT
              LENS = LNBLNK(SECTION(LEVEL2))
              LENC = LNBLNK(COMAND(LEVEL2))
              WRITE(TXTO,'(A,''{'',A,''}'')')
     1         SECTION(LEVEL2)(1:LENS),COMAND(LEVEL2)(1:LENC)
              CALL MN_WRIT(' ')
              CALL MN_WRIT(TXTO)
              GOTO 2200
          END IF
      END IF
C
C     Convert "see HELP ..." into see section nn (...)
C
      CALL MN_XREF(TXTI)
      LENO = MAX0(1,LNBLNK(TXTI))
      CALL MN_WRIT(TXTI)
      IF(.NOT.QVERB .AND. LENO.GT.0 .AND. TXTI(LENO:LENO).EQ.':') THEN
          CALL MN_WRIT(' ')
          CALL MN_WRIT('{'//BSL//'small')
          CALL MN_WRIT(BSL//'begin{verbatim}')
          QVERB = .TRUE.
          NREC = 0
      END IF
      GOTO 2200
C
C     GET ALL THE MENUS
C
2900  CONTINUE
      IF(NUNIT.EQ.2) THEN
          TXTO = BSL//'chapter{Menu of all the Available Commands}%'
          CALL MN_WRIT(TXTO)
*ICB          TXTO = BSL//'index{Menus|bb}'//BSL//'label{MENU}'
          TXTO = BSL//'index{Menus|textbf}'//BSL//'label{MENU}'
          CALL MN_WRIT(TXTO)
      END IF
C
      COMAND(1) = ' '
      LEVEL = 0
      REWIND NUNIT
3000  CONTINUE
      TXTI = ' '
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 3500
      IF(TXTI(1:1).EQ.'!') GOTO 3000
      CALL MN_INTERP(TXTI,QVERB,0)
      IF(TXTI(1:1).EQ.' ' .OR. TXTI(1:1).EQ.TAB) GOTO 3000
3100  CONTINUE
      CALL QUOTYP(TXTI)
      LENT = LNBLNK(TXTI)
      LEVEL = INTTYP(.TRUE.,IDELIM)
      TEXT = TXTI(3:LENT)
      COMAND(LEVEL)  = TEXT
      IF(TEXT.NE.'Menu') GOTO 3000
C
C     NOW WE HAVE A MENU
C
C     IF(NUNIT.EQ.2) THEN
          MENLEV = 2
C     ELSE
C         MENLEV = 3
C     END IF
C
C      CALL MN_WRIT(BSL//'newpage')
      nline = 0
      LENS = LNBLNK(SECTION(MENLEV))
      IF(NUNIT.EQ.2) THEN
          IF(LEVEL.EQ.1 .AND. COMAND(LEVEL).EQ.'Menu') THEN
              TEXT = 'Menu of Top Level Commands'
              TTMP = ' '
          ELSE
              TEXT = 'Menu of Commands inside ' //
     1         COMAND(MENLEV-1)
              TTMP = COMAND(MENLEV - 1)
          END IF
      ELSE
          TEXT = 'Menu of MINUIT Commands'
C          // ' Inside ' // COMAND(MENLEV-1)
          TTMP = 'MINUIT'
      END IF
      LENO = LNBLNK(TEXT)
      IF(TTMP.NE.' ') THEN
          WRITE(TXTO,'(A,''{'',A,''}%'')') SECTION(MENLEV-1)(1:LENS)
     1     ,TEXT(1:LENO)
      ELSE
          WRITE(TXTO,'(A,''{'',A,''}'')') SECTION(MENLEV-1)(1:LENS)
     1     ,TEXT(1:LENO)
      ENDIF
      nline = nline + 1
      CALL MN_WRIT(TXTO)
C
C     Add a label and an index item to the menu
C
      IF(TTMP.NE.' ') THEN
          TXTO = BSL//'index{Menus!'
          TEXT = CONCT0(TXTO,TTMP)
          TXTO = CONCT0(TEXT,'}%')
          CALL MN_WRIT(TXTO)
*
          TXTO = BSL//'label{'
          CALL CLTOU(TTMP)
3160      CONTINUE
          IND = INDEX(TTMP,BSL)
          IF(IND.GT.0) THEN
              TEXT = TTMP(1:IND-1) // TTMP(IND+1:)
              TTMP = TEXT
              GOTO 3160
          ENDIF
          LENT = LNBLNK(TTMP)
          TEXT = CONCT0(TXTO,TTMP)
          TXTO = CONCT0(TEXT,':MENU}')
          CALL MN_WRIT(TXTO)
      ENDIF
C
C     LOOP OVER THE HEADER LINES FIRST. USE A BLANK LINE AS TRIGGER
C     FOR THE MENU
C
3200  CONTINUE
      TXTI = ' '
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.NE.0) GOTO 9100
      IF(TXTI.EQ.' ') GOTO 3290
      CALL MN_COMMENT(TXTI,QVERB,QIGNORE,QNOSWITCH,IERR)
      IF(IERR.NE.0) GOTO 3200
      CALL MN_INTERP(TXTI,QVERB,0)
C
C     Convert "see HELP ..." into see section nn (...)
C
      CALL MN_XREF(TXTI)
      LENT = MAX0(1,LNBLNK(TXTI))
      nline = nline + 1
      if(lent.gt.90) nline = nline + 1
      CALL MN_WRIT(TXTI)
      GOTO 3200
C
C     Make the menu entry
C
3290  CONTINUE
      CALL MN_MENU(0,NUNIT,IERR,TXTI)
      IF(IERR.NE.0) GOTO 9900
      GOTO 3000
C
3500  CONTINUE
      NUNIT = NUNIT + 1
      IF(NUNIT.LE.3) GOTO 1500
C
C     THIS IS THE REFERENCE MANUAL PART
C     NOW GO THROUGH THE STANDARD COMMANDS
C     LOGIC IS AS FOLLOW:
C     AFTER THE COMMAND SWITCH TO VERBATIM, UNTIL A BLANK LINE IS
C     FOUND
C     AFTER THAT DO USUAL TEX FORMATTING. IF A COLON IS FOUND AT THE
C     END OF A LINE SWITCH TO VERBATIM THERE
C     EXAMPLES ARE no longer done in verbatim, but the header stuff treatment
C     should be skipped.
C     An ! at the beginning of the line is taken as TeX control if
C     the second character is not a blank
C     != means don't switch into or out of verbatim on the next line
C
      NUNIT = 2
5000  CONTINUE
      REWIND NUNIT
      IF(NUNIT.EQ.2) THEN
          TXTO = BSL//'chapter{Reference Manual for Mn'//BSL//'_Fit}'
      ELSE
          TXTO = BSL//'chapter{Reference Manual for MINUIT}'
      END IF
      CALL MN_WRIT(TXTO)
C
      QVERB  = .FALSE.
      QPRINT = .FALSE.
      LEVEL = 0
6000  CONTINUE
      TXTI = ' '
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 6500
      IF(TXTI(1:1).EQ.'!') GOTO 6000
      IF(TXTI(1:1).EQ.' ' .OR. TXTI(1:1).EQ.TAB) GOTO 6000
      CALL MN_INTERP(TXTI,QVERB,0)
6100  CONTINUE
      QNOSWITCH = .FALSE.
      QIGNORE   = .FALSE.
      CALL QUOTYP(TXTI)
      LENT = LNBLNK(TXTI)
      LEVEL = INTTYP(.TRUE.,IDELIM)
      TEXT = TXTI(3:LENT)
C
C     CHECK THAT WE ARE NOT IN VERBATIM MODE
C
      IF(QVERB) THEN
          CALL MN_WRIT(BSL//'end{verbatim}}')
          CALL MN_WRIT(' ')
          QVERB = .FALSE.
          CALL MN_INTERP(TEXT,QVERB,0)
      END IF
C
C     SKIP MIXED CASE HEADINGS AS THEY HAVE BEEN DONE ALREADY, BUT
C     NOT WHEN INSIDE FUNCTION BECAUSE THEY ARE FUNCTION DESCRIPTIONS
C     Skip menus as they have been done already
C     DON'T SKIP EXAMPLES
C     ALWAYS SKIP THEM INSIDE MINUIT??
C     SKIP LEVEL 1 HELP
C
      IF((NUNIT.EQ.2 .AND. LEVEL.EQ.1) .OR.
     1   (NUNIT.EQ.3 .AND. LEVEL.EQ.2)) THEN
          QUPC = .TRUE.
          IF(ICHAR(TEXT(2:2)).GE.ICHAR('a') .AND.
     1       ICHAR(TEXT(2:2)).LE.ICHAR('z')) THEN
              QUPC = .FALSE.
              QPRINT = .FALSE.
              GOTO 6000
          ELSEIF(TEXT(1:3).eq.'Y2K') then
              QUPC = .FALSE.
              QPRINT = .FALSE.
              GOTO 6000
          ELSEIF(TEXT(1:4).EQ.'HELP') THEN
              QPRINT = .FALSE.
              GOTO 6000
          END IF
      END IF
      IF(TEXT(1:4).EQ.'Menu') THEN
          QPRINT = .FALSE.
          GOTO 6000
      ENDIF
      IF(NUNIT.EQ.2 .AND.
     1   (QUPC .OR.
     1    (LEVEL.GT.1 .AND. QPRINT .AND. TEXT(1:7).EQ.'Example') .OR.
     1    COMAND(1).EQ.'FUNCTION')) then
        GOTO 6150
      endif
      IF(NUNIT.EQ.3 .AND.
     1 (QUPC .OR.
     1 (LEVEL.GT.2 .AND. TEXT(1:7).EQ.'Example'))) then
C       1    (LEVEL.GT.2 .AND. QPRINT .AND. TEXT(1:7).EQ.'Example')))
        GOTO 6150
      endif
      QPRINT = .FALSE.
      GOTO 6000
6150  CONTINUE
C
C     NOW WE HAVE A STANDARD COMMAND
C
      QPRINT = .TRUE.
      IF(TEXT(1:7).EQ.'Example') THEN
          QEXAMPLE = .TRUE.
      ELSE
          QEXAMPLE = .FALSE.
      ENDIF
C
      NL1 = 1
      NL2 = LEVEL
      IF(NUNIT.EQ.2) THEN
          NLEV = LEVEL
      ELSE
          NLEV = LEVEL
          IF(LEVEL.GT.1) THEN
              NLEV = LEVEL - 1
              NL1 = 2
              NL2 = LEVEL
          ENDIF
      ENDIF
      COMAND(LEVEL) = TEXT
C
C     Label the section with its full tree separated by :
C     Convert the label to upper case to avoid problems
C
      LENS = LNBLNK(SECTION(NLEV))
      LENO = LNBLNK(COMAND(LEVEL))
C
C     If there is an _ in the title and the next character is an upper case
C     and the text is not Mn_Fit get rid of the _
C
      N1 = 1
      COMND2(LEVEL) = COMAND(LEVEL)
      LEN2 = LENO
 6140 CONTINUE
      IND = INDEX(COMND2(LEVEL)(n1:),BSL//'_')
      IF(IND.GT.0) THEN
          n2 = N1 + IND - 1
          IF((ICHAR(COMND2(LEVEL)(N2+2:N2+2)).GE.ICHAR('A') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+2:N2+2)).LE.ICHAR('Z') .AND.
     +        ICHAR(COMND2(LEVEL)(N2-1:N2-1)).GE.ICHAR('a') .AND.
     +        ICHAR(COMND2(LEVEL)(N2-1:N2-1)).LE.ICHAR('z')) .OR.
     +       (ICHAR(COMND2(LEVEL)(N2+2:N2+2)).GE.ICHAR('a') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+2:N2+2)).LE.ICHAR('z')) .OR.
     +       (ICHAR(COMND2(LEVEL)(N2+2:N2+2)).GE.ICHAR('A') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+2:N2+2)).LE.ICHAR('Z') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+3:N2+3)).GE.ICHAR('a') .AND.
     +        ICHAR(COMND2(LEVEL)(N2+3:N2+3)).LE.ICHAR('z'))) THEN
              IF(COMND2(LEVEL)(N2-2:N2+4).EQ.'Mn'//BSL//'_Fit' .OR.
     +           COMND2(LEVEL)(N2-2:N2+4).EQ.'MN'//BSL//'_FIT') THEN
              ELSE
                  TTMP = COMND2(LEVEL)(:N2-1) //
     +             ' ' // COMND2(LEVEL)(N2+2:)
                  COMND2(LEVEL) = TTMP
                  LEN2 = LEN2 - 1
              ENDIF
              N1 = N2 + 1
              IF(N1.LT.LENO) GOTO 6140
          ENDIF
      ENDIF
C
      WRITE(TXTO,'(A,''{'',A,''}%'')') SECTION(NLEV)(1:LENS)
     1 ,COMND2(LEVEL)(1:LEN2)
      CALL MN_WRIT(' ')
      CALL MN_WRIT(TXTO)
C
C     Add an index reference
C
      if(nunit.eq.3 .and. level.gt.1) then
          TXTO = BSL//'index{MINUIT'
      else
          TXTO = BSL//'index{'
      endif
      if(level.le.3) then
          do i=nl1,nl2
              if(i.gt.1) then
                  ttmp = conct0(txto,'!')
                  txto = ttmp
              endif
              LENc = LNBLNK(comnd2(i))
              ttmp = conct0(txto,comnd2(i)(:lenc))
              txto = ttmp
          enddo
      else
          do i=nl1+2,nl2
              if(i.gt.3) then
                  ttmp = conct0(txto,'!')
                  txto = ttmp
              endif
              lenc = lnblnk(comnd2(i))
              ttmp = conct0(txto,comnd2(i)(:lenc))
              txto = ttmp
          enddo
      endif
*ICB      ttmp = conct0(txto,'|bb}%')
      ttmp = conct0(txto,'|textbf}%')
      txto = ttmp
      CALL MN_WRIT(TXTo)
C
      IF(NUNIT.EQ.3 .AND. LEVEL.GT.1) THEN
          txto = BSL//'label{MINUIT:'
      else
          txto = BSL//'label{'
      ENDIF
C
      DO 6170 I=NL1,NL2
          CALL M_LUPC(COMAND(I),TTMP)
6160      CONTINUE
          IND = INDEX(TTMP,BSL)
          IF(IND.GT.0) THEN
              TEXT = TTMP(1:IND-1) // TTMP(IND+1:)
              TTMP = TEXT
              GOTO 6160
          ENDIF
          LENT = LNBLNK(TTMP)
          TEXT = CONCT0(TXTO,TTMP(1:LENT))
          IF(I.LT.NLEV) THEN
              TXTO = CONCT0(TEXT,':')
          ELSE
              TXTO = TEXT
          ENDIF
6170  CONTINUE
      TEXT = CONCT0(TXTO,'}')
      CALL MN_WRIT(TEXT)
      NREC = 0
C
C     FOR EXAMPLE do not into verbatim, but SKIP STRAIGHT TO MEAT
C
      IF(QEXAMPLE) THEN
c          CALL MN_WRIT(BSL//'begin{verbatim}')
c          QVERB = .TRUE.
          GOTO 6300
      ENDIF
C
C     FIRST DO THE HEADER STUFF, BLANK LINE TRIGGERS THE END
C
6200  CONTINUE
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 9100
      CALL MN_COMMENT(TXTI,QVERB,QIGNORE,QNOSWITCH,IERR)
      IF(IERR.NE.0) GOTO 6200
      NREC = NREC + 1
      IF(NREC.EQ.1) THEN
          IF(TXTI.EQ.' ') THEN
              NREC = 0
              GOTO 6300
          ELSE
              CALL MN_WRIT('{'//BSL//'small')
              CALL MN_WRIT(BSL//'begin{verbatim}')
              QVERB = .TRUE.
          END IF
      END IF
C
      IF(TXTI.EQ.' ') THEN
          CALL MN_WRIT(BSL//'end{verbatim}}')
          CALL MN_WRIT(' ')
          QVERB = .FALSE.
          NREC = 0
          GOTO 6300
      END IF
      LENO = LNBLNK(TXTI)
      CALL MN_WRIT(TXTI)
      GOTO 6200
C
C     NOW GOT TO THE MEAT OF A HELP SECTION, LOOK OUT FOR A COLON
C     and an ! as these have special meaning
C
6300  CONTINUE
      CALL MN_MEAT(0,NUNIT,QIGNORE,IERR,TXTI)
      IF(IERR.EQ.2) GOTO 6500
      GOTO 6100
C
6500  CONTINUE
      NUNIT = NUNIT + 1
      IF(NUNIT.LE.3) GOTO 5000
C
C     NOW WRITE OUT the appendicies and THE END
C
8000  CONTINUE
      nunit = 2
      IF(QVERB) THEN
          CALL MN_WRIT(BSL//'end{verbatim}}')
          QVERB = .FALSE.
      END IF
C
8100  CONTINUE
      TXTI = ' '
      CALL MN_READ(20+NUNIT,TXTI,IERR)
      if(ierr.eq.2) goto 8500
      IF(TXTI.EQ.BSL//'begin{verbatim}') THEN
          QVERB = .TRUE.
      ELSEIF(TXTI.EQ.BSL//'end{verbatim}}') THEN
          QVERB = .FALSE.
      ENDIF
      CALL MN_INTERP(TXTI,QVERB,1)
C
C     Convert "see HELP ..." into see section nn (...)
C
      CALL MN_XREF(TXTI)
      CALL MN_WRIT(TXTI)
      goto 8000
C
8500  continue
C
C     Add the Mn_Fit demo macros
C
      CALL MN_DEMO(TVERS2)
C
C     NOW ADD THE CHANGES
C
      CALL MN_CHANGES
C
      call mn_writ(BSL//'bibliography{mn_fit}')
      call mn_writ(BSL//'printindex')
      CALL MN_WRIT(BSL//'end{document}')
C
9000  CONTINUE
      GOTO 9900
C
9100  CONTINUE
      WRITE(6,'('' *** Illegal error on read:'',I4)')
C
9900  CONTINUE
      CLOSE(UNIT=1)
      CLOSE(UNIT=2)
      CLOSE(UNIT=3)
      CLOSE(UNIT=10)
      END
C
      SUBROUTINE MN_READ(NUNIT,TXTI,IERR)
C
#include "mnchar.inc"
C
      CHARACTER*(*) TXTI
C
      IERR = 0
C
      TXTI = ' '
      READ(NUNIT,'(A)',ERR=8100,END=8200) TXTI
      LENI = LNBLNK(TXTI)
      IF(LENI.EQ.0 .OR. TXTI.EQ.' ') RETURN
C
      GOTO 9000
8100  CONTINUE
      TXTI = ' '
      IERR = 1
      RETURN
C
8200  CONTINUE
      TXTI = ' '
      IERR = 2
      RETURN
C
9000  CONTINUE
      END
C
      SUBROUTINE MN_INTERP(TXTI,QVERB,NMODE)
C
#include "mnchar.inc"
C
      CHARACTER*(*) TXTI
      CHARACTER*255 TXTO
      LOGICAL QVERB
      PARAMETER (MSPEC = 7, MMATH = 5, MEXTRA = 2)
      CHARACTER*1 TSPEC(MSPEC),TMATH(MMATH),TEXTRA(MEXTRA)
      DATA TSPEC/'$','&','%','#','_','{','}'/
      DATA TMATH/'+','=','|','<','>'/
      DATA TEXTRA/'^','~'/
C
      LENI = LNBLNK(TXTI)
      IF(LENI.EQ.0 .OR. TXTI.EQ.' ') RETURN
C
C     GET RID OF TABS
C
      N1 = 1
500   CONTINUE
      IND = INDEX(TXTI(N1:),TAB)
      IF(IND.EQ.0) GOTO 1000
      NN = N1 + IND -1
      LENT = LNBLNK(TXTI)
      WRITE(6,'('' *** Tab found in line. Get rid of it ***'',/,1X,A)')
     1 TXTI(1:LENT)
      IF(NN.GT.1 .AND. NN.LT.LENT) THEN
          TXTO = TXTI(1:NN-1) // '        ' // TXTI(NN+1:)
      ELSE IF(NN.GT.1) THEN
          TXTO = TXTI(1:NN-1) // '        '
      ELSE
          TXTO = '       ' // TXTI(NN+1:)
      END IF
      TXTI = TXTO
      N1 = NN + 8
      GOTO 500
1000  CONTINUE
C
C     DON'T MESS AROUND IN VERBATIM
C
      IF(QVERB) RETURN
C
C     If we are in introduction or somewhere special do not do
C     special character conversion
C
      IF(NMODE.NE.0) GOTO 5000
C
      DO 2000 I=1,MSPEC
          N1 = 1
1500      CONTINUE
          IND = INDEX(TXTI(N1:),TSPEC(I))
          IF(IND.EQ.0) GOTO 2000
          NN = N1 + IND - 1
          IF(NN.GT.1) THEN
              TXTO = TXTI(1:NN-1) // BSL // TXTI(NN:)
          ELSE
              TXTO = BSL // TXTI(NN:)
          END IF
          TXTI = TXTO
          N1 = NN + 2
          GOTO 1500
2000  CONTINUE
C
      DO 3000 I=1,MMATH
          N1 = 1
2500      CONTINUE
          IND = INDEX(TXTI(N1:),TMATH(I))
          IF(IND.EQ.0) GOTO 3000
          NN = N1 + IND - 1
          IF(NN.GT.1) THEN
              TXTO = TXTI(1:NN-1) // '$' // TXTI(NN:NN) // '$' //
     1         TXTI(NN+1:)
          ELSE
              TXTO = '$' // TXTI(NN:NN) // '$' //
     1         TXTI(NN+1:)
          END IF
          TXTI = TXTO
          N1 = NN + 3
          GOTO 2500
3000  CONTINUE
C
      DO 4000 I=1,MEXTRA
          N1 = 1
3500      CONTINUE
          IND = INDEX(TXTI(N1:),TEXTRA(I))
          IF(IND.EQ.0) GOTO 4000
          NN = N1 + IND - 1
          IF(NN.GT.1 .AND. NN.LT.LNBLNK(TXTI)) THEN
              TXTO = TXTI(1:NN-1) // BSL // TEXTRA(I) // '{ }' //
     +         TXTI(NN+1:)
          ELSE IF(NN.GT.1) THEN
              TXTO = TXTI(1:NN-1) // BSL // TEXTRA(I) // '{ }'
          ELSE
              TXTO = BSL // TEXTRA(I) // '{ }' // TXTI(NN+1:)
          END IF
          TXTI = TXTO
          N1 = NN + 5
          GOTO 3500
4000  CONTINUE
C
C     Replace chi**2 with the proper text
C
5000  CONTINUE
      IND1 = INDEX(TXTI,'chi**2')
      IND2 = INDEX(TXTI,'Chi**2')
      IF(IND1.GT.0 .AND. IND2.GT.0) THEN
          IND = MIN0(IND1,IND2)
      ELSEIF(IND1.GT.0) THEN
          IND = IND1
      ELSEIF(IND2.GT.0) THEN
          IND = IND2
      ELSE
          IND = 0
      ENDIF
      LENI = LNBLNK(TXTI)
      IF(IND.GT.0) THEN
          IF(TXTI(IND+6:IND+6).EQ.',' .OR. TXTI(IND+6:IND+6).EQ.'.' .OR.
     +       TXTI(IND+6:IND+6).EQ.';' .OR. TXTI(IND+6:IND+6).EQ.':' .OR.
     +       TXTI(IND+6:IND+6).EQ.'!' .OR. TXTI(IND+6:IND+6).EQ.'?')THEN
              IF(IND.GT.1 .AND. IND+6.LE.LENI) THEN
                  TXTO = TXTI(1:IND-1) // BSL//'chisq ' // TXTI(IND+6:)
              ELSEIF(IND.GT.1) THEN
                  TXTO = TXTI(1:IND-1) // BSL//'chisq '
              ELSEIF(IND+6.LE.LENI) THEN
                  TXTO = BSL//'chisq ' // TXTI(IND+6:)
              ELSE
                  TXTO = BSL//'chisq '
              ENDIF
          ELSE
              IF(IND.GT.1 .AND. IND+6.LE.LENI) THEN
                TXTO = TXTI(1:IND-1) // BSL//'chisq'//BSL//' ' //
     +           TXTI(IND+6:)
              ELSEIF(IND.GT.1) THEN
                  TXTO = TXTI(1:IND-1) // BSL//'chisq'//BSL//' '
              ELSEIF(IND+6.LE.LENI) THEN
                  TXTO = BSL//'chisq'//BSL//' ' // TXTI(IND+6:)
              ELSE
                  TXTO = BSL//'chisq'//BSL//' '
              ENDIF
          ENDIF
          TXTI = TXTO
          GOTO 5000
      ENDIF
C
C     Look for ` ' and change the text inside it to \tt
C     If ` '' is found then chop off one ' and continue
C
      N1 = 1
6000  CONTINUE
      IND1 = INDEX(TXTI(N1:),'`')
      IND2 = INDEX(TXTI(N1+IND1:),'''')
      LENI = LNBLNK(TXTI)
      IF(IND1.GT.0 .AND. IND2.GT.0) THEN
          N2 = N1 + IND1 - 1
          N3 = N1 + IND1 + IND2 - 1
 6100     CONTINUE
          IF(N3+1.LE.LENI .AND. TXTI(N3+1:N3+1).EQ.'''') THEN
              TXTO = TXTI(1:N3-1) // TXTI(N3+1:)
              TXTI = TXTO
              LENI = LENI - 1
              IND2 = INDEX(TXTI(N3+1:),'''')
              IF(IND2.GT.0) THEN
                  N3 = N3 + IND2
                  GOTO 6100
              ELSE
                  GOTO 6500
              ENDIF
          ENDIF
          IF(N2.GT.1 .AND. N3+1.LE.LENI) THEN
            TXTO = TXTI(1:N2-1) // '{'//BSL//'tt ' //
     +       TXTI(N2+1:N3-1) //
     +       '}' // TXTI(N3+1:)
          ELSEIF(N2.GT.1) THEN
            TXTO = TXTI(1:N2-1) // '{'//BSL//'tt ' //
     +       TXTI(N2+1:N3-1) //
     +       '}'
          ELSEIF(N3+1.LE.LENI) THEN
              TXTO = '{'//BSL//'tt ' // TXTI(N2+1:N3-1) //
     +         '}' // TXTI(N3+1:)
          ELSE
              TXTO = '{'//BSL//'tt ' // TXTI(N2+1:N3-1) //
     +         '}'
          ENDIF
          TXTI = TXTO
          N1 = N2
C
C         Look for \! and replace it by \\!
C
          ind1 = index(txti(n1:),BSL//'!')
          if(ind1.gt.1) then
              n3 = n1 + ind1 - 1
              if(txti(n3-1:n3-1).ne.BSL) then
                  txto = txti(:n3-1) // BSL // txti(n3:)
                  txti = txto
              endif
          endif
          GOTO 6000
      ENDIF
 6500 CONTINUE
C
C     Get rid of any $$ which means out of math mode and straight back in
C
      N1 = 1
7000  CONTINUE
      IND = INDEX(TXTI(N1:),'$$')
      LENI = LNBLNK(TXTI)
      IF(IND.GT.0) THEN
          N2 = N1 + IND - 1
          N3 = N1 + IND
          IF(N2.GT.1 .AND. N3+1.LE.LENI) THEN
              TXTO = TXTI(1:N2-1) // TXTI(N3+1:)
          ELSEIF(N2.GT.1) THEN
              TXTO = TXTI(1:N2-1)
          ELSEIF(N3+1.LE.LENI) THEN
              TXTO = TXTI(N3+1:)
          ELSE
              TXTO = ' '
          ENDIF
          TXTI = TXTO
          N1 = N2
          GOTO 7000
      ENDIF
C
9000  CONTINUE
      END
C
      SUBROUTINE MN_XREF(TXTI)
C
      implicit none
C
#include "mnchar.inc"
C
      CHARACTER*(*) TXTI
      CHARACTER*255 TXTO,TEXT
      CHARACTER*80 THELP,THLP2,THLPO,TINDX,TIND2
C
      INTEGER I,N1,N2,N3,NN,NEXTRA,IND,IND1,IND2,N4,N5
      INTEGER INDH,indi,LENH,LENHO,LENT,leni
      INTEGER LNBLNK
C
      N1 = 1
      N2 = 1
6400  CONTINUE
      IF(N1.EQ.1) THEN
          IND1 = INDEX(TXTI(N1:),'see HELP')
          IND2 = INDEX(TXTI(N1:),'See HELP')
          NEXTRA = 9
      ELSE
          IND1 = INDEX(TXTI(N1:),'HELP')
          IND2 = INDEX(TXTI(N1:),'HELP')
          NEXTRA = 5
      ENDIF
      IF(IND1.GT.0 .AND. IND2.GT.0) THEN
          IND = MIN0(IND1,IND2)
      ELSEIF(IND1.GT.0) THEN
          IND = IND1
      ELSEIF(IND2.GT.0) THEN
          IND = IND2
      ELSE
          IND = 0
      ENDIF
      IF(IND.GT.0) THEN
          N2 = N1 + IND - 1
C
C         Find the help topic name
C         Require the character after the space to be in lower case to
C         signal the end of the HELP topic string
C         Also look for a . or , at the end of the string
C         Convert the help topic to upper case to agree with the label
C
          N3 = N2 + NEXTRA - 2
6405      CONTINUE
          LENT = LNBLNK(TXTI)
          DO 6410 I=N3+2,LENT
              IF(TXTI(I:I).EQ.' ' .OR. TXTI(I:I).EQ.'.' .OR.
     +           TXTI(I:I).EQ.',' .OR. TXTI(I:I).EQ.')') THEN
                 N3 = I - 1
                 GOTO 6420
              ENDIF
6410      CONTINUE
          N3 = LNBLNK(TXTI)
6420      CONTINUE
          IF(N3.LT.LENT+2 .AND.
     +       ICHAR(TXTI(N3+2:N3+2)).GE.ICHAR('A') .AND.
     +       ICHAR(TXTI(N3+2:N3+2)).LE.ICHAR('Z')) THEN
              GOTO 6405
          ENDIF
C
          THELP = TXTI(N2+NEXTRA:N3)
          THLPO = THELP
          CALL M_LUPC(THELP,THLP2)
          THELP = THLP2
C
C         Replace any blanks in THELP by colons
C         and check for multiple blanks
C
6450      CONTINUE
          LENH = LNBLNK(THELP)
          INDH = INDEX(THELP(1:LENH),' ')
          IF(INDH.GT.0) THEN
              IF(INDH.GT.1 .AND. THELP(INDH-1:INDH-1).EQ.':') THEN
                  THLP2 = THELP(1:INDH-1) // THELP(INDH+1:)
              ELSE
                  THLP2 = THELP(1:INDH-1) // ':' // THELP(INDH+1:)
              ENDIF
              THELP = THLP2
              GOTO 6450
          ENDIF
C
          tindx = thlpo
          leni = lnblnk(tindx)
C
C         Make an index entry also - convert a space to !
C
 6500     continue
          indi = index(tindx(:leni),' ')
          if(indi.gt.0) then
              if(indi.gt.1 .and. tindx(indi-1:indi-1).eq.'!') then
                  tind2 = tindx(:indi-1) // tindx(indi+1:)
              else
                  tind2 = tindx(:indi-1) // '!' // tindx(indi+1:)
              endif
              tindx = tind2
              goto 6500
          endif
C
C         If there is an _ in the title and the next character is an upper case
C         and the text is not Mn_Fit get rid of the _
C
          N4 = 1
 6510     CONTINUE
          IND = INDEX(tindx(n4:),BSL//'_')
          IF(IND.GT.0) THEN
              N5 = N4 + IND - 1
              IF((ICHAR(TINDX(N5+2:N5+2)).GE.ICHAR('A') .AND.
     +            ICHAR(TINDX(N5+2:N5+2)).LE.ICHAR('Z') .AND.
     +            ICHAR(TINDX(N5-1:N5-1)).GE.ICHAR('a') .AND.
     +            ICHAR(TINDX(N5-1:N5-1)).LE.ICHAR('z')) .OR.
     +           (ICHAR(TINDX(N5+2:N5+2)).GE.ICHAR('a') .AND.
     +            ICHAR(TINDX(N5+2:N5+2)).LE.ICHAR('z')) .OR.
     +           (ICHAR(TINDX(N5+2:N5+2)).GE.ICHAR('A') .AND.
     +            ICHAR(TINDX(N5+2:N5+2)).LE.ICHAR('Z') .AND.
     +            ICHAR(TINDX(N5+3:N5+3)).GE.ICHAR('a') .AND.
     +            ICHAR(TINDX(N5+3:N5+3)).LE.ICHAR('z'))) THEN
                  if(tindx(N5-2:N5+4).EQ.'Mn'//BSL//'_Fit' .OR.
     +               tindx(N5-2:N5+4).EQ.'MN'//BSL//'_FIT') THEN
                  ELSE
                      tind2 = tindx(:N5-1) //
     +                 ' ' // tindx(N5+2:)
                      tindx = tind2
                      leni = leni - 1
                  ENDIF
                  N4 = N5 + 1
                  IF(N4.LT.LENi) GOTO 6510
              ENDIF
          ENDIF
C
C         Save the title for cross-reference
C
          thlpo = tindx
C
C         Remove any ! from the cross-reference
C
          LENHO = LNBLNK(THLPO)
          CALL CTRANS('!',' ',thlpo,1,lenho)
C
C         Remove \ from help label
C
6520      CONTINUE
          LENH = LNBLNK(THELP)
          IND = INDEX(THELP,BSL)
          IF(IND.GT.0) THEN
              THLP2 = THELP(1:IND-1) // THELP(IND+1:)
              THELP = THLP2
              GOTO 6520
          ENDIF
C
          IF(N1.EQ.1) THEN
              NN = N2 + 3
          ELSE
              NN = N2 - 1
          ENDIF
          TEXT = TXTI(1:NN) // 'section~'//BSL//'ref{' //
     +     THELP(1:LENH) // '} on page~'//BSL//'pageref{' //
     +     THELP(1:LENH) // '} (' // THLPO(1:LENHO) // ')' //
     +     BSL//'index{' // tindx(:leni) // '}'
          N1 = LNBLNK(TEXT)
          IF(N3.LT.LNBLNK(TXTI)) THEN
              TXTO = TEXT(1:N1) //
     +         TXTI(N3+1:)
              TXTI = TXTO
          ELSE
              TXTI = TEXT
          ENDIF
          GOTO 6400
      ENDIF
C
      END
C
      SUBROUTINE MN_WRIT(TXTO)
C
#include "mnchar.inc"
C
      CHARACTER*(*) TXTO
C
      LENO = MAX0(1,LNBLNK(TXTO))
      IF(LENO.LE.80 .or. index(txto(1:leno),BSL//'verb').gt.0) THEN
          WRITE(10,'(A)') TXTO(1:LENO)
      ELSEIF(LENO.LE.160) THEN
          DO 1500 I=80,1,-1
              IF(TXTO(I:I).EQ.' ') THEN
                  WRITE(10,'(A)') TXTO(1:I-1)
                  WRITE(10,'(A)') TXTO(I+1:LENO)
                  GOTO 1510
              END IF
1500      CONTINUE
          WRITE(6,'('' No space found in line: '',A)') TXTO(1:LENO)
          WRITE(10,'(A,''%'')') TXTO(1:80)
          WRITE(10,'(A)') TXTO(81:LENO)
1510      CONTINUE
      ELSE
          DO 1600 I=160,80,-1
              IF(TXTO(I:I).EQ.' ') THEN
                  II = I
                  DO 1590 J=80,1,-1
                      IF(TXTO(J:J).EQ.' ') THEN
                          WRITE(10,'(A)') TXTO(1:J-1)
                          WRITE(10,'(A)') TXTO(J+1:II-1)
                          WRITE(10,'(A)') TXTO(II+1:LENO)
                          GOTO 1610
                      END IF
1590              CONTINUE
              END IF
1600      CONTINUE
          WRITE(6,'('' No space found in line: '',A)') TXTO(1:LENO)
          WRITE(10,'(A,''%'')') TXTO(1:80)
          WRITE(10,'(A,''%'')') TXTO(81:160)
          WRITE(10,'(A)') TXTO(161:LENO)
1610      CONTINUE
      END IF
C
      END
C
      SUBROUTINE MN_COMMENT(TXTI,QVERB,QIGNORE,QNOSWITCH,IERR)
C
C     Look for a ! in the first column
C
#include "mnchar.inc"
C
      CHARACTER*(*) TXTI
      LOGICAL QVERB,QIGNORE,QNOSWITCH
      INTEGER IERR
C
      CHARACTER*255 TXTL
      INTEGER LENL,LNBLNK
C
      IERR = 0
      IF(TXTI.EQ.' ') GOTO 9900
C
      IF(TXTI(1:1).EQ.'!') THEN
          IF(TXTI(2:2).EQ.' ' .OR. TXTI(2:2).EQ.TAB) THEN
              GOTO 9100
          ELSEIF(TXTI(2:2).EQ.'=') THEN
              IF(QVERB) THEN
                  QNOSWITCH = .TRUE.
                  GOTO 9100
              ELSE
                  LENL = LNBLNK(TXTL)
                  LENL = MAX0(1,MIN0(LENL,60))
                  WRITE(6,'('' Found a != while not in verbatim''
     +             ,/,'' Previous text: '',A)')
     +             TXTL(1:LENL)
                  GOTO 9100
              ENDIF
          ELSEIF(TXTI(2:2).EQ.'^') THEN
              QIGNORE = .TRUE.
              GOTO 9100
          ELSE
              CALL MN_WRIT(TXTI(2:))
              GOTO 9100
          ENDIF
      ENDIF
      GOTO 9900
C
9100  CONTINUE
      IERR = 1
9900  CONTINUE
      TXTL = TXTI
      END
C
      SUBROUTINE MN_MENU(NMODE,NUNIT,IERR,TXTI)
C
C     Makes a menu list.
C     End of the menu is triggered by a blank line.
C     RETURN is triggered by new command in mode 0.
C     RETURN is triggered by blank line in mode 1
C     NMODE = 0 is normal menu 3.6cm wide
C     NMODE = 1 is changes list 4.0cm wide
C
#include "mnchar.inc"
C
      INTEGER NUNIT,IERR
      CHARACTER*(*) TXTI
      LOGICAL QDESC,QVERB,QIGNORE,QNOSWITCH
      CHARACTER*255 TXTO,TEXT
      CHARACTER*50 COMAND
      CHARACTER*5   TWID1,TWID2
C
      IF(NMODE.EQ.0) THEN
          TWID1 = '3.6cm'
          TWID2 = '3.2cm'
      ELSE
          TWID1 = '4.0cm'
          TWID2 = '3.6cm'
      ENDIF
C
      CALL MN_WRIT(BSL//'begin{menu}{' // TWID1 // '}{' // TWID2 // '}')
      QDESC = .TRUE.
      QVERB = .FALSE.
      QIGNORE = .FALSE.
      QNOSWITCH = .FALSE.
      NREC = 0
3300  CONTINUE
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 9100
      CALL MN_COMMENT(TXTI,QVERB,QIGNORE,QNOSWITCH,IERR)
      IF(IERR.NE.0) GOTO 3300
      CALL MN_INTERP(TXTI,QVERB,0)
C
C     Convert "see HELP ..." into see section nn (...)
C
      CALL MN_XREF(TXTI)
C
      NREC = NREC + 1
C
      IF(QDESC .AND. NREC.GT.1 .AND. TXTI.EQ.' ') THEN
          CALL MN_WRIT(BSL//'end{menu}')
          QDESC = .FALSE.
          IF(NMODE.EQ.0) THEN
              GOTO 3300
          ELSE
              GOTO 9900
          ENDIF
      ELSE IF(TXTI(1:1).NE.' ' .AND. TXTI(1:1).NE.TAB) THEN
          IF(QDESC) THEN
              CALL MN_WRIT(BSL//'end{menu}')
              QDESC  = .FALSE.
          END IF
          GOTO 9900
      END IF
C
      IF(QDESC) THEN
          IF(TXTI(1:5).EQ.' ') THEN
              IF(NREC.GT.1) THEN
                  LENO = MAX0(1,LNBLNK(TXTI))
                  CALL MN_WRIT(TXTI(1:LENO))
              else
                  nrec = 0
              END IF
          ELSE
              CALL QUOTYP(TXTI)
              IF(NMODE.EQ.0) THEN
                  NCH = ISTTYP(.TRUE.,IDELIM,COMAND)
                  IF(IDELIM.EQ.0) THEN
                      ISTR = ISTRNG(.TRUE.,TEXT,LENO)
                  ELSE
                      TEXT = ' '
                  END IF
              ELSE
                  ISTR = ISTRNG(.TRUE.,TXTO,LENO)
                  IND = INDEX(TXTO(1:LENO),'  ')
                  IF(IND.LE.0) THEN
                      LENI = MAX0(1,LNBLNK(TXTI))
                      WRITE(6
     +                 ,'('' Error in command description: '')')
                      WRITE(6,*) TXTI(1:LENI)
                      GOTO 3300
                  ENDIF
                  COMAND = TXTO(1:IND-1)
                  CALL QUOTYP(TXTO(IND+2:))
                  ISTR = ISTRNG(.TRUE.,TEXT,LENO)
              ENDIF
              LENO = MAX0(1,LNBLNK(TEXT))
              LENS = LNBLNK(COMAND)
C              WRITE(TXTO,'(A,''item['',A,''bf '',A,A,''hfill] '',A)')
C     1         BSL,BSL,COMAND(1:LENS),BSL,TEXT(1:LENO)
              WRITE(TXTO,'(A,''item['',A,''] '',A)')
     1         BSL,COMAND(1:LENS),TEXT(1:LENO)
              CALL MN_WRIT(TXTO)
          END IF
      ELSE
          LENO = MAX0(1,LNBLNK(TXTI))
          CALL MN_WRIT(TXTI)
          IF(TXTI(LENO:LENO).EQ.':') THEN
            CALL MN_WRIT(BSL//'begin{menu}{' // TWID1 // '}{' //
     +       TWID2 //
     +       '}')
            QDESC = .TRUE.
            NREC = 0
          ENDIF
      ENDIF
      GOTO 3300
C
9100  CONTINUE
      WRITE(6,'('' *** Illegal error on read:'',I4)')
C
9900  CONTINUE
      END
C
      SUBROUTINE MN_ITEM(NMODE,NUNIT,IERR,TXTI)
C
C     Makes a item list. Each item is triggered by a blank line.
C     End of the item list is triggered by a line with +++ as first non-blank
C     characters.
C
#include "mnchar.inc"
C
      INTEGER NUNIT,IERR
      CHARACTER*(*) TXTI
      LOGICAL QITEM,QVERB,QIGNORE,QNOSWITCH
      CHARACTER*255 TEXT
C
      IERR = 0
      CALL MN_WRIT(BSL//'begin{itemize}')
      QITEM = .TRUE.
      QVERB = .FALSE.
      QIGNORE = .FALSE.
      QNOSWITCH = .FALSE.
      NREC = 0
3300  CONTINUE
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 9900
      IF(TXTI(1:1).GE.'1' .AND. TXTI(1:1).LE.'9') THEN
          CALL MN_WRIT(BSL//'end{itemize}')
          CALL MN_INTERP(TXTI,QVERB,0)
          GOTO 9900
      ENDIF
C
      IF(.NOT.QITEM) THEN
          QITEM = TXTI.EQ.' '
          IF(QITEM) GOTO 3300
C
C     Ignore blank lines if waiting to start an item
C
      ELSE
          IF(TXTI.EQ.' ') GOTO 3300
      ENDIF
C
      IF(QITEM) THEN
          CALL QUOTYP(TXTI)
          NCHAR = ISTTYP(.TRUE.,IDELIM,TEXT)
          IF(NCHAR.GE.3 .AND. TEXT(1:3).EQ.'+++') THEN
              CALL MN_WRIT(BSL//'end{itemize}')
              CALL MN_INTERP(TXTI,QVERB,0)
              GOTO 9900
          ENDIF
          CALL MN_WRIT(BSL//'item')
          QITEM = .FALSE.
      ENDIF
C
      CALL MN_COMMENT(TXTI,QVERB,QIGNORE,QNOSWITCH,IERR)
      IF(IERR.NE.0) GOTO 3300
      CALL MN_INTERP(TXTI,QVERB,0)
C
C     Convert "see HELP ..." into see section nn (...)
C
      CALL MN_XREF(TXTI)
C
      LENO = MAX0(1,LNBLNK(TXTI))
      CALL MN_WRIT(TXTI(1:LENO))
      GOTO 3300
C
9900  CONTINUE
      END
C
      SUBROUTINE MN_CHANGES
C
C     Writes out the changes in Mn_Fit since the given version.
C     New title must start with +++ to be recognized.
C     For now no special processing goes on in here except for
C     cross-references.
C
#include "mnchar.inc"
C
      CHARACTER*255 TXTI,TXTO
      CHARACTER*50 COMAND
      CHARACTER*10 TVERS,TVERS2
      character*10  TDATE
      LOGICAL QVERB,QIGNORE,QNOSWITCH,QMENU
C
      IERR = 0
      REWIND 2
      NUNIT = 2
      QVERB = .FALSE.
      QIGNORE = .FALSE.
      QNOSWITCH = .FALSE.
1000  CONTINUE
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 9900
      CALL MN_INTERP(TXTI,QVERB,0)
      IF(TXTI(1:1).EQ.' ' .OR. TXTI(1:1).EQ.TAB) GOTO 1000
      CALL QUOTYP(TXTI)
      LEVEL = INTTYP(.TRUE.,IDELIM)
      NCH = ISTTYP(.TRUE.,IDELIM,COMAND)
      IF(COMAND.NE.'CHANGES') GOTO 1000
C
      CALL MN_WRIT(' ')
      CALL MN_WRIT(BSL//'chapter{List of Changes}')
      CALL MN_WRIT(BSL//'label{APPENDIX:CHANGES}')
C
C     Write out the changes text until the next header is found
C
      QIGNORE = .FALSE.
      CALL MN_MEAT(0,NUNIT,QIGNORE,IERR,TXTI)
      IF(IERR.EQ.2) GOTO 9900
C
C     Got the next header. Interpret it.
C
3000  CONTINUE
      CALL QUOTYP(TXTI)
      LEVEL = INTTYP(.TRUE.,IDELIM)
      NCHV = ISTTYP(.TRUE.,IDELIM,TVERS)
      NCHD = ISTTYP(.TRUE.,IDELIM,TDATE)
C
C     Make a nice version number
C
      IND = INDEX(TVERS(1:NCHV),BSL//'_')
      if(tvers(ind+6:ind+7).eq.'  ') then
          TVERS2 = TVERS(2:IND-1) // '.' // TVERS(IND+2:IND+3)
      else
          TVERS2 = TVERS(2:IND-1) // '.' // TVERS(IND+2:IND+3) //
     +     '/' // TVERS(IND+6:IND+7)
      endif
C
C     Ignore all changes before Version 4.01
C
      IF(TVERS(1:6).LT.'V4'//BSL//'_01') THEN
C      IF(TVERS(1:2).LT.'V3') THEN
C      IF(TVERS(1:6).LT.'V2'//BSL//'_05') THEN
3100      CONTINUE
          CALL MN_READ(NUNIT,TXTI,IERR)
          IF(IERR.EQ.2) GOTO 9900
          IF(TXTI(1:1).GT.'1' .AND. TXTI(1:1).LT.'9') THEN
              CALL MN_INTERP(TXTI,QVERB,0)
              GOTO 3000
          ELSE
              GOTO 3100
          ENDIF
      ENDIF
C
C     Got a changes section I want to write out
C
      TXTO = BSL//'section{Version ' // TVERS2 // ' ' //
     + TDATE(1:NCHD) // '}'
      CALL MN_WRIT(TXTO)
C
C     Process the text normally up to the next heading that starts with +++
C
      QIGNORE = .FALSE.
      CALL MN_MEAT(1,NUNIT,QIGNORE,IERR,TXTI)
      IF(IERR.EQ.2) GOTO 9900
C
C     Process the title and then go to item or menu subroutine
C
4000  CONTINUE
      QMENU = .FALSE.
      QVERB = .FALSE.
      LENI = LNBLNK(TXTI)
C
C     Get rid of the +++
C
      IND = INDEX(TXTI(1:LENI),'$+++$')
      IF(IND.GT.0) THEN
          N1 = IND + 5
      ELSE
          N1 = 1
      ENDIF
      TXTO = BSL//'subsection*{' // TXTI(N1:LENI) // '}'
      CALL MN_WRIT(TXTO)
C
C     If this is the new or modified commands topic treat it as a menu
C     Read in the _____ line
C
      QMENU = INDEX(TXTI,'Command').GT.0
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(QMENU) THEN
          CALL MN_MENU(1,NUNIT,IERR,TXTI)
      ELSE
          CALL MN_ITEM(0,NUNIT,IERR,TXTI)
      ENDIF
      IF(IERR.NE.0) GOTO 9900
C
C     Keep reading until a non-blank line is found
C
4500  CONTINUE
      IF(TXTI.EQ.' ') THEN
          CALL MN_READ(NUNIT,TXTI,IERR)
          IF(IERR.EQ.2) GOTO 9900
          CALL MN_INTERP(TXTI,QVERB,0)
          GOTO 4500
      ENDIF
      IF(TXTI(1:1).GE.'1' .AND. TXTI(1:1).LE.'9') GOTO 3000
      GOTO 4000
C
9900  CONTINUE
      END
C
      SUBROUTINE MN_MEAT(NMODE,NUNIT,QIGNORE,IERR,TXTI)
C
C     Interprets the meat of a help section.
C     End is triggered by end of file or by a new help section.
C     For mode=1 end is triggered by text starting with +++
C
#include "mnchar.inc"
C
      INTEGER NUNIT,IERR
      LOGICAL QIGNORE
      CHARACTER*(*) TXTI
C
      LOGICAL QVERB,QNOSWITCH
      CHARACTER*255 TEXT
C
      IERR = 0
      QVERB = .FALSE.
      qnoswitch = .false.
6300  CONTINUE
      TXTI = ' '
      CALL MN_READ(NUNIT,TXTI,IERR)
      IF(IERR.EQ.2) GOTO 9900
      IF(QIGNORE) THEN
          QIGNORE = .FALSE.
          GOTO 6300
      ENDIF
C
      CALL MN_COMMENT(TXTI,QVERB,QIGNORE,QNOSWITCH,IERR)
      IF(IERR.NE.0) GOTO 6300
C
      CALL MN_INTERP(TXTI,QVERB,0)
      IF(TXTI(1:1).NE.' ' .AND. TXTI(1:1).NE.TAB) GOTO 9900
C
C     If mode=1 see if first non-blank characters are $+++$
C
      IF(NMODE.EQ.1) THEN
          CALL QUOTYP(TXTI)
          NCHAR = ISTTYP(.TRUE.,IDELIM,TEXT)
          IF(TEXT(1:5).EQ.'$+++$') GOTO 9900
      ENDIF
C
      NREC= NREC + 1
      if(QVERB .AND. TXTI.EQ.' ') THEN
          IF(QNOSWITCH) THEN
              CALL MN_WRIT(' ')
              QNOSWITCH = .FALSE.
          ELSEIF(NREC.GT.1) THEN
              CALL MN_WRIT(BSL//'end{verbatim}}')
              CALL MN_WRIT(BSL//'par'//BSL//'noindent')
              QVERB = .FALSE.
          END IF
          GOTO 6300
      END IF
C
C     Convert "see HELP ..." into see section nn (...)
C
      CALL MN_XREF(TXTI)
C
      LENO = MAX0(1,LNBLNK(TXTI))
      CALL MN_WRIT(TXTI)
      IF(.NOT.QVERB .AND. LENO.GT.0 .AND. TXTI(LENO:LENO).EQ.':') THEN
          CALL MN_WRIT(' ')
          CALL MN_WRIT('{'//BSL//'small')
          CALL MN_WRIT(BSL//'begin{verbatim}')
          QVERB = .TRUE.
          NREC = 0
      END IF
      GOTO 6300
C
9900  CONTINUE
      END
C
      SUBROUTINE MN_DEMO(TVERS)
C
C     All typeout is done in verbatim and user typin is underlined.
C     Writes out the Mn_Fit demo macros and the commands for the
C     resultant pictures in a nice format.
C     The prompt is recognized by ending in '> ' and being at position < 20
C     Otherwise 'Give' followed by ': ' is searched for.
C     User typin follows a prompt until a ! is found that is not inside single
C     or double quotation marks.
C
      implicit none
*
#include "mndir.inc"
#include "mnchar.inc"
C
      CHARACTER*(*) TVERS
C
      CHARACTER*255 TXTI,TXTO,TEXT
      CHARACTER*80 TPRMPT,TTYPIN,TCOMM
      CHARACTER*255 TFILE
      CHARACTER*6  TDFILE
      CHARACTER*1 TQUOTE(2)
*
      integer lenv,lenh,lens,leno,nunit,ierr
      integer ndemo,ldemo,leni,indx,ind,lprmpt,n1,n2,ind1,nquote
      integer i,n3,n4
      integer ltypin,lcomm
C
      INTEGER MDEMO
      PARAMETER (MDEMO = 7)
*ICB      PARAMETER (MDEMO = 6)
C
      CHARACTER*60 TDEMO(MDEMO)
      LOGICAL QVERB
C
      DATA TDEMO/
     +  'Simple Fetch and Plot'
     + ,'Simple Gaussian Fit'
     + ,'Plotting with overlays, inserts, colours and fonts'
     + ,'Different ways of displaying 2-D histograms'
     + ,'Simultaneous fit of 2 plots with function overlays'
     + ,'Drawing Possibilities'
     + ,'Display of an L3 Luminosity Monitor Event'
     + /
      DATA TQUOTE/'''','"'/
C
      LENV = LNBLNK(TVERS)
      LENH = LNBLNK(TMNHLP)
      LENS = LNBLNK(TMNSRC)
C
C     Write out the examples introduction
C
      nunit = 31
      TFILE = TMNSRC(1:LENS) // 'manual/mn_demos.tex'
      OPEN(UNIT=NUNIT,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
1000  CONTINUE
C
      CALL MN_READ(NUNIT,TXTI,IERR)
      if(ierr.eq.2) goto 1500
      CALL MN_INTERP(TXTI,QVERB,1)
      CALL MN_WRIT(TXTI)
      goto 1000
1500  continue
      CLOSE(UNIT=NUNIT)
C
C     Set up the figure sizes
C
c     CALL MN_WRIT(BSL//'newlength{'//BSL//'epsfxsave}')
c     CALL MN_WRIT(BSL//'setlength{'//
*     BSL//'epsfxsave}{'//BSL//'epsfxsize}')
c     CALL MN_WRIT(BSL//'setlength{'//
*     BSL//epsfxsize}{'//BSL//'textwidth}')
C
      NUNIT = 32
      QVERB = .FALSE.
      DO 5000 NDEMO = 1,MDEMO
          WRITE(TDFILE,'(''demo'',I2.2)') NDEMO
          TFILE = TMNSRC(1:LENS) // 'help/demo_log/' // TDFILE // '.out'
          OPEN(UNIT=NUNIT,FILE=TFILE,STATUS='OLD',FORM='FORMATTED')
C
          CALL MN_WRIT(BSL//'clearpage')
          LDEMO = LNBLNK(TDEMO(NDEMO))
          WRITE(TXTO,'(A,''section{Demo '',I2,'': ''
     +     ,A,''}'')') BSL,NDEMO,TDEMO(NDEMO)(1:LDEMO)
          CALL MN_WRIT(TXTO)
          CALL MN_WRIT(BSL//'begin{tabbing}')
C         Define the tab stop
          CALL MN_WRIT('ABCDEFGHIJKLMNOPQRSTUVWXY '//
     +     BSL//'= '//BSL//'kill')
C
2000      CONTINUE
          CALL MN_READ(NUNIT,TXTI,IERR)
          IF(IERR.EQ.2) GOTO 4500
          IF(TXTI.EQ.' ') GOTO 2000
          LENI = LNBLNK(TXTI)
C
C         Look for the prompt.
C         Next version of Mn_Fit will use ## to signal the end of the prompt
C         so no gymnastics will be needed.
C
          INDX = 0
          TPRMPT = ' '
          IND = INDEX(TXTI,'##')
          IF(IND.GT.0) THEN
              TPRMPT = TXTI(1:IND-1)
              INDX = IND + 2
          ENDIF
          LPRMPT = LNBLNK(TPRMPT)
C
C         Get the user typin if there is a prompt
C
          IF(LPRMPT.GT.0) THEN
C
C             Look for a ! that is not inside '' or ""
C
              N1 = INDX
3000          CONTINUE
              IND1 = INDEX(TXTI(N1:),'!')
              IF(IND1.GT.0) THEN
                  N2 = N1 + IND1 - 1
C
C                 Count the number of single and double quotes before the !
C
                  NQUOTE = 0
                  DO 4000 I=1,2
                      N3 = INDX
3500                  CONTINUE
                      IND = INDEX(TXTI(N3:),TQUOTE(I))
                      IF(IND.LE.0) GOTO 3600
                      N4 = N3 + IND - 1
                      IF(N4.GT.N2) GOTO 3600
                      NQUOTE = NQUOTE + 1
3600                  CONTINUE
                      IF(MOD(NQUOTE,2).EQ.1) THEN
                          N1 = N2 + 1
                          GOTO 3000
                      ENDIF
4000              CONTINUE
C
C                 Found an ! not inside quotes
C
                  IF(N2.GT.INDX) THEN
                      TTYPIN = TXTI(INDX:N2-1)
                  ELSE
                      TTYPIN = ' '
                  ENDIF
                  TCOMM  = TXTI(N2:)
              ELSE
                  TTYPIN = TXTI(INDX:)
                  TCOMM  = ' '
              ENDIF
C
C             Make and write out the line
C
              CALL MN_INTERP(TPRMPT,QVERB,0)
              CALL MN_INTERP(TTYPIN,QVERB,0)
              CALL MN_INTERP(TCOMM,QVERB,0)
              LPRMPT = LNBLNK(TPRMPT)
              LTYPIN = LNBLNK(TTYPIN)
              LCOMM  = LNBLNK(TCOMM)
C
              TXTO = BSL//'bf ' // TPRMPT(1:LPRMPT)
              LENO = LPRMPT + 4
              IF(LTYPIN.GT.0) THEN
                  TXTO(LENO+1:) = ' '//BSL//'underline{'//BSL//'tt ' //
     +             TTYPIN(1:LTYPIN) // '}'
                  LENO = LENO + LTYPIN + 17
              ENDIF
C
C             If the prompt + typin is too long, move the comment to the
C             line before.
C
              IF(LCOMM.GT.0) THEN
                IF(LENO.GT.60) THEN
                  TEXT = BSL//'bf ' // TPRMPT(1:LPRMPT) //
     +             ' {'//BSL//'it ' // TCOMM(1:LCOMM) // '}'//
     +             BSL // BSL
                  CALL MN_WRIT(TEXT)
                  TXTO(LENO+1:) = BSL // BSL
                ELSEIF(LTYPIN.GT.0) THEN
                  TXTO(LENO+1:) = ' '//BSL//'> {'//
     +             BSL//'it ' // TCOMM(1:LCOMM) //
     +             '}' // BSL // BSL
                ELSE
                  TXTO(LENO+1:) = ' {'//BSL//'it ' // TCOMM(1:LCOMM) //
     +             '}' // BSL // BSL
                ENDIF
              ELSE
                  TXTO(LENO+1:) = BSL // BSL
              ENDIF
              CALL MN_WRIT(TXTO)
C
C         See if line is a comment line
C
          ELSEIF(TXTI(1:1).EQ.'!' .OR. TXTI(1:2).EQ.' !') THEN
              TCOMM = TXTI
              CALL MN_INTERP(TCOMM,QVERB,0)
              LCOMM  = LNBLNK(TCOMM)
              TXTO = '{'//BSL//'it ' // TCOMM(1:LCOMM) // '}' //
     +         BSL // BSL
C
C         Just dump the complete line

          ELSE
CICB              CALL QUOTYP(TXTI(1:LENI))
CICB              ISTR = ISTRNG(.TRUE.,TEXT,LENT)
            TXTO = '{'//BSL//'small'//BSL//'verb`' // TXTI(1:LENI) //
     +       '`}' // BSL // BSL
            CALL MN_WRIT(TXTO)
          ENDIF
          GOTO 2000
C
C         Clean up and put in the commands for the picture
C         Reduce the picture size to the text width
C         Demo05 has a 2 page picture
C
4500      CONTINUE
          CLOSE(UNIT=NUNIT)
          CALL MN_WRIT(BSL//'end{tabbing}')
          CALL MN_WRIT(BSL//'begin{figure}[p]')
          CALL MN_WRIT(BSL//'begin{center}')
          IF(NDEMO.EQ.5) THEN
              CALL MN_WRIT(BSL//'includegraphics[height=18cm]{' //
     +         TDFILE // 'a}')
              CALL MN_WRIT(BSL//'end{center}')
              CALL MN_WRIT(BSL//'end{figure}')
              CALL MN_WRIT(BSL//'begin{figure}[hbp]')
              CALL MN_WRIT(BSL//'begin{center}')
              CALL MN_WRIT(BSL//'includegraphics[height=18cm]{' //
     +         TDFILE // 'b}')
          ELSEIF(NDEMO.EQ.6) THEN
              CALL MN_WRIT(BSL//'includegraphics[height=15cm]{' //
     +         TDFILE // '}')
          ELSEIF(NDEMO.EQ.2 .or. ndemo.eq.7) THEN
              CALL MN_WRIT(BSL//'includegraphics[height=18cm]{' //
     +         TDFILE // '}')
          ELSE
              CALL MN_WRIT(BSL//'includegraphics[height=16cm]{' //
     +         TDFILE // '}')
          ENDIF
          WRITE(TXTO,'(A,''caption{Demo '',I2,'' --- ''
     +     ,A,''.}'')') BSL,NDEMO,TDEMO(NDEMO)(1:LDEMO)
          CALL MN_WRIT(TXTO)
          WRITE(TXTO,'(A,''label{fig:demo'',I2.2,''}'')') BSL,NDEMO
          CALL MN_WRIT(TXTO)
          CALL MN_WRIT(BSL//'end{center}')
          CALL MN_WRIT(BSL//'end{figure}')
5000  CONTINUE
C
9900  CONTINUE
      END
