//  $Id: mmdb_mask.cpp,v 1.4 2004/01/28 17:22:33 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    24.04.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :   MMDB_Mask  <implementation>
//       ~~~~~~~~~
//  **** Project :   MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//
//  **** Classes :   CMask  ( atom selection mask  )
//       ~~~~~~~~~   
//
//  E. Krissinel 2000-2003
//
//  =================================================================
//

#ifndef  __STRING_H
#include <string.h>
#endif

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __MMDB_Mask__
#include "mmdb_mask.h"
#endif


//  ====================  CMask  ========================

CMask::CMask() : CStream()  {
  InitMask();
}

CMask::CMask ( RPCStream Object ) : CStream(Object)  {
  InitMask();
}

CMask::~CMask()  {
  ClearMask();
}

void CMask::InitMask()  {
  mlen = 0;
  m    = NULL;
}

void CMask::SetMaskBit ( int BitNo )  {
int n,i;
  n = BitNo/(8*sizeof(word));
  Expand ( n+1 );
  i = BitNo - n*(8*sizeof(word));
  m[n] |= ((word)1 << i);  
}

void CMask::Expand ( int n )  {
wvector m1;
int     i;
  if (mlen<n)  {
    m1 = new word[n];
    for (i=0;i<mlen;i++)
      m1[i] = m[i];
    for (i=mlen;i<n;i++)
      m1[i] = 0;
    if (m)  delete[] m;
    m    = m1;
    mlen = n;
  }
}

void  CMask::NewMask ( PPCMask Mask, int nMasks )  {
int  i,nlen;
word w;
  ClearMask();
  if (Mask && (nMasks>0))  {
    nlen = 0;
    w    = 0;
    while (w==0)  {
      for (i=0;i<nMasks;i++)
        if (Mask[i])  {
          if (nlen<Mask[i]->mlen)
            w |= Mask[i]->m[nlen];
        }
      nlen++;
      w = ~w;
    }
    Expand ( nlen );
    i    = nlen-1;
    m[i] = 1;
    while (!(m[i] & w))
      m[i] <<= 1;
  } else  {
    Expand ( 1 );
    m[0] = 1;
  }
}

void  CMask::CopyMask ( PCMask Mask )  {
int i;
  if (mlen!=Mask->mlen)  ClearMask();
  if (Mask)  {
    mlen = Mask->mlen;
    if (mlen>0)  {
      m = new word[mlen];
      for (i=0;i<mlen;i++)
        m[i] = Mask->m[i];
    }
  }
}

void  CMask::SetMask ( PCMask Mask )  {
int i;
  if (Mask) {
    Expand ( Mask->mlen );
    for (i=0;i<Mask->mlen;i++)
      m[i] |= Mask->m[i]; 
  }
}

void  CMask::RemoveMask ( PCMask Mask )  {
int i,l;
  if (Mask) {
    l = IMin(mlen,Mask->mlen);
    for (i=0;i<l;i++)
      m[i] &= ~Mask->m[i]; 
  }
}

void  CMask::SelMask ( PCMask Mask )  {
int i,l;
  if (Mask)  {
    l = IMin(mlen,Mask->mlen);
    for (i=0;i<l;i++)
      m[i] &= Mask->m[i];
    for (i=l;i<mlen;i++)
      m[i] = 0;
  } else
    ClearMask();
}

void  CMask::XadMask ( PCMask Mask )  {
int i;
  if (Mask) {
    Expand ( Mask->mlen );
    for (i=0;i<Mask->mlen;i++)
      m[i] ^= Mask->m[i]; 
  }
}

void  CMask::ClearMask()  {
  if (m)  delete[] m;
  m = NULL;
  mlen = 0;
}

void  CMask::NegMask()  {
int i;
  for (i=0;i<mlen;i++)
    m[i] = ~m[i];
}

Boolean  CMask::CheckMask ( PCMask Mask )  {
int i,l;
  if (Mask)  {
    i = 0;
    l = IMin(mlen,Mask->mlen);
    while ((i<l) && (!(m[i] & Mask->m[i])))  i++;
    return (i<l);
  } else
    return False;
}

Boolean  CMask::isMask()  {
int i=0;
  while ((i<mlen) && (!m[i]))  i++;
  return (i<mlen);
}

pstr  CMask::Print ( pstr S )  {
int  i,j,k;
word w;
  j = 0;
  for (i=0;i<mlen;i++)  {
    w = 1;
    for (k=0;k<8*sizeof(word);k++)  {
      if (w & m[i])  S[j] = '1';
               else  S[j] = '0';
      w <<= 1;
      j++;
    }
  }
  S[j] = char(0);
  return S;
}

void  CMask::write ( RCFile f )  {
int i;
  f.WriteInt ( &mlen );
  for (i=0;i<mlen;i++)
    f.WriteWord ( &(m[i]) );
}
   
void  CMask::read ( RCFile f )  {
int i;
  if (m)  {
    delete[] m;
    m = NULL;
  }
  f.ReadInt ( &mlen );
  if (mlen>0)  {
    m = new word[mlen];
    for (i=0;i<mlen;i++)
      f.ReadWord ( &(m[i]) );
  }
}


MakeStreamFunctions(CMask)


