%define name mediatomb 
%define version 0.11.0
%define release 8%{?dist}

Version: %{version}
Summary: MediaTomb - UPnP AV Mediaserver for Linux
Name: %{name}
Release: %{release}
License: GPLv2
Group: Applications/Multimedia
Source: http://downloads.sourceforge.net/mediatomb/%{name}-%{version}.tar.gz
URL: http://mediatomb.cc
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n) 
BuildRequires: sqlite-devel, mysql-devel, libexif-devel, taglib-devel, file-devel, js-devel, zlib-devel
Requires: mysql
Requires(pre): shadow-utils
Requires(post): /sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(preun): /sbin/service

%description
MediaTomb is an open source (GPL) UPnP MediaServer with a nice web user 
interface, it allows you to stream your digital media through your home
network and listen to/watch it on a variety of UPnP compatible devices.

MediaTomb implements the UPnP MediaServer V 1.0 specification that can 
be found on http://www.upnp.org/.
%prep 
%setup -q

%build
%configure --enable-taglib
%{__make} %{?_smp_mflags}


%install
%{__rm} -rf $RPM_BUILD_ROOT

%{__install} -p -D -m0755 scripts/mediatomb-service-fedora $RPM_BUILD_ROOT%{_initrddir}/mediatomb
%{__install} -p -D -m0644 config/mediatomb-conf-fedora $RPM_BUILD_ROOT%{_sysconfdir}/mediatomb.conf
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"

# make all files under %%_sysconfdir/mediatomb are owned by
# this package
%{__mkdir_p} $RPM_BUILD_ROOT%{_sysconfdir}/mediatomb
touch $RPM_BUILD_ROOT%{_sysconfdir}/mediatomb/{config.xml,mediatomb.db,mediatomb.html}
%{__mkdir_p}  $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d

%{__cat} > $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name} << 'EOF'
/var/log/mediatomb {
create 644 root root
	monthly
        compress
        missingok
}
EOF

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%pre
getent group mediatomb >/dev/null || groupadd -r mediatomb
getent passwd mediatomb >/dev/null || \
useradd -r -g mediatomb -d %{_sysconfdir}/mediatomb -s /sbin/nologin \
    -c "To run Mediatomb" mediatomb
exit 0

%post
/sbin/chkconfig --add mediatomb

%preun
if [ $1 = 0 ]; then
        /sbin/service mediatomb stop >/dev/null 2>&1
        /sbin/chkconfig --del mediatomb
fi

%files
%defattr(-,root,root,-)
%doc README README.UTF_8 AUTHORS ChangeLog COPYING doc/doxygen.conf
%doc doc/scripting.txt doc/scripting_utf8.txt
%attr(-,mediatomb,mediatomb)%config(noreplace) %{_sysconfdir}/mediatomb.conf
%attr(-,mediatomb,mediatomb)%dir %{_sysconfdir}/%{name}/
%attr(-,mediatomb,mediatomb)%ghost %{_sysconfdir}/%{name}/*
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%{_bindir}/mediatomb
%{_datadir}/%{name}/*
%{_mandir}/man1/*
%{_initrddir}/mediatomb

%changelog
* Fri Jan 4 2008 Sergey Bostandzhyan <jin@mediatomb.cc> 0.10.0-8
- Removed libextractor and enabled taglib instead of id3lib

* Thu Jan 3 2008 Marc Wiriadisastra <marc@mwiriadi.id.au> 0.10.0-7
- Added mysql-devel to build requires

* Thu Jan 3 2008 Marc Wiriadisastra <marc@mwiriadi.id.au> 0.10.0-6
- Cleaned up spec file

* Wed Jan 2 2008 Marc Wiriadisastra <marc@mwiriadi.id.au> 0.10.0-5
- Added mysql-libs for build requires instead of mysql-devel

* Wed Jan 2 2008 Marc Wiriadisastra <marc@mwiriadi.id.au> 0.10.0-4
- Actually added the patches to the file.
- Added the ownership changes (Mamoru Tasaka)
- Libextractor enabled

* Wed Jan 2 2008 Marc Wiriadisastra <marc@mwiriadi.id.au> 0.10.0-3
- Added patchs to patch ownership of /etc/mediatomb.conf and /etc/mediatomb
- Adjusted pre and post scripts and add user and group mediatomb
- Changed attributes so files are owned by mediatomb
- Cleaned Requires and added two files for build-requires

* Sun Dec 23 2007 Marc Wiriadisastra <marc@mwiriadi.id.au> 0.10.0-2
- Altered spec file for inclusion into Fedora
* Wed Jul 11 2007 Sergey Bostandzhyan <jin@mediatomb.cc> 0.10.0-1
- Version is now filled in by the configure script.
* Sun May 27 2007 Sergey Bostandzhyan <jin@mediatomb.cc> 0.9.1-1
- updated the init script
* Sun Mar 25 2007 Sergey Bostandzhyan <jin@mediatomb.cc> 0.9.0-1
- Synced with the new script naming and adjusted for the release,
  added man page.
* Mon Feb 26 2007 Sergey Bostandzhyan <jin@mediatomb.cc>
- Removed some files that were no longer needed.
* Wed Sep  7 2005 Sergey Bostandzhyan <jin@mediatomb.cc>
- Removed some buildrequires, our configure script should handle different
  scenarios itself.
* Wed Jun 15 2005 Sergey Bostandzhyan <jin@mediatomb.cc>
- Added init.d script + chkconfig
* Thu Apr 14 2005 Sergey Bostandzhyan <jin@mediatomb.cc>
- Initial release

