/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __TRANSPONDER_H__
#define __TRANSPONDER_H__

#include <glib.h>
#include "channel.h"

class Channel;

class Transponder
{
public:
	Transponder();

	struct dvb_frontend_parameters	frontend_parameters;
	guint							polarisation;
	guint							satellite_number;
	gboolean						hi_band;
	GHashTable*						channels;

	int get_frequency() const { return frontend_parameters.frequency; }
	
	void add_channel(Channel* channel);
	Channel* get_channel(int service_id);
};

#endif
