/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __CONFIGURATION_H__
#define __CONFIGURATION_H__

#include "xml.h"

class Configuration
{
private:
	XmlDocument	document;
	gboolean	is_dirty;
	xmlNodePtr	general_node;

	void cleanup();
	
public:
	Configuration();
	~Configuration();
	
	XmlDocument& get_document();
	void set_dirty();
	void load(const String& configuration_file);
	void save();

	void set_int_value (const String& key, int value);
	void set_boolean_value (const String& key, gboolean value);
	void set_string_value(const String& key, const String& value);
	gboolean has_value(const String& key);
	String get_string_value(const String& key);
	guint get_int_value(const String& key);	
	gboolean get_boolean_value(const String& key);
	void set_default_string_value(const String& key, const String& default_value);
	void set_default_int_value(const String& key, int default_value);
	void set_default_boolean_value(const String& key, gboolean default_value);
};

#endif
