""" An 'editor action' to save the plot as a project view. """


# Enthought library imports.
from enthought.envisage import get_application
from enthought.envisage.ui import Editor
from enthought.naming.api import Binding
from enthought.pyface.api import OK
from enthought.pyface.action.api import Action
from enthought.pyface.image_resource import ImageResource
from enthought.traits.api import Instance

# Plugin imports.
from enthought.envisage.project.wizard.save_as_wizard import SaveAsWizard


class SaveAction(Action):
    """ An 'editor action' to save the plot as a project view. """
    
    # The editor whose resource we wish to save.
    editor = Instance(Editor)  
    
    # The icon to display on toolbar.
    image = ImageResource('save')
    
    name = 'Save'
    
    # The tooltip for the toolbar.
    tooltip = 'Save'

    ###########################################################################
    # 'object' interface.
    ###########################################################################
    
    def __init__(self, editor, **traits):
        
        # Base class constructor.
        super(SaveAction, self).__init__(**traits)
        
        # Set required traits.
        self.editor = editor
        
        return
        
    ###########################################################################
    # Action interface.
    ###########################################################################

    def perform(self, event = None):
        """ Save the editor's resource. """
        
        # Get the resource that we wish to bind in the project.
        resource = self.editor.resource

        # If there's nothing to save, don't save anything.
        if resource is None:
            pass
        
        # Otherwise, save the resouce.
        else:
            # If the resource is already saved, just rebind it.
            resource_name = self.editor.resource_name
            if len(resource_name) > 0:
                workspace = self._get_workspace()
                workspace.rebind(resource_name, resource)
            
            # Otherwise, present the user with a save as.
            else:
                save_as_wizard = SaveAsWizard(self.editor, resource)
                if save_as_wizard.open() == OK:
                    save_as_wizard.create_resource()
            
        return
        
    ###########################################################################
    # Private interface.
    ###########################################################################

    def _get_workspace(self):
        """ Get the workspace used to save the resource. """
        
        workspace = get_application().service_registry.get_service(
                  'enthought.envisage.project.IWorkspace'
            )
        
        return workspace
        
#### EOF ######################################################################
