""" Base class for all extension items. """


# Enthought library imports.
from enthought.traits.api import HasPrivateTraits


class ExtensionItem(HasPrivateTraits):
    """ Base class for all extension items.

    Extension items are classes that are referenced by extension points, but are
    not themselves extension points.
    
    Extension items are intended to be *declarative* and should *not* contain
    any methods (other than those inherited from HasPrivateTraits).

    """

    # For now this class exists solely to encourage use of 'HasPrivateTraits'
    # throughout an extension point definition. However, it could come in
    # useful later to allow the framework to attach other information to the
    # extension items.
    pass

#### EOF ######################################################################
