""" Example plugin definition. """


# Enthought library imports.
from enthought.envisage.api import PluginDefinition
from enthought.traits.api import Bool

# Plugin definition imports.
from enthought.envisage.core.core_plugin_definition import \
     Preferences

from enthought.envisage.ui.ui_plugin_definition import \
     Action, Group, Menu, UIActions, UIViews, View

from enthought.envisage.ui.preference.preference_plugin_definition import \
     PreferencePages, Page


# The plugin's globally unique identifier (also used as the prefix for all
# identifiers defined in this module).
ID = 'enthought.envisage.examples.plugin.simple_ui'


###############################################################################
# Extensions.
###############################################################################

#### Preferences ##############################################################

preferences = Preferences(
    defaults = {
        'flip_the_flop'    : True,
        'explode_on_exit'  : True,
        'background_color' : 'red',
        'label_font'       : '',
    }
)

#### Preference pages #########################################################

preference_pages = PreferencePages(
    pages = [
        Page(
            id         = ID + "ExamplePreferencePage",
            class_name = ID + ".example_preference_page.ExamplePreferencePage",
            name       = "Example Stuff",
            category   = "",
        ),

        Page(
            id         = ID + "AnotherPreferencePage",
            class_name = ID + ".another_preference_page.AnotherPreferencePage",
            name       = "More Stuff",
            category   = ID + "ExamplePreferencePage",
        )
    ]
)

#### Menus/Actions ############################################################

file_menu = Menu( 
    id     = "FileMenu",
    #name   = "File",
    path   = "FileGroup",
            
    groups = [
        Group(id = "AnExampleGroup"),
        Group(id = "AnotherGroup"),
    ]
)

sub_menu = Menu( 
    id     = "SubMenu",
    name   = "Sub",
    path   = "FileMenu/AnExampleGroup",
            
    groups = [
        Group(id = "MainGroup"),
        Group(id = "RadioGroup"),
    ]
)

do_it_action = Action(
    id            = ID + ".action.example_action.DoItAction",
    class_name    = ID + ".action.example_action.ExampleAction",
    name          = "Do It!",
    image         = "action/images/do_it",
    description   = "An action's description can appear in the status bar",
    tooltip       = "A simple example action",
    menu_bar_path = "FileMenu/SubMenu/MainGroup",
    tool_bar_path = "additions",
    style         = "push",
)

highest_action = Action(
    id            = ID + ".action.example_action.HighestAction",
    class_name    = ID + ".action.example_action.ExampleAction",
    name          = "Highest",
    image         = "action/images/higher",
    description   = "An action's description can appear in the status bar",
    tooltip       = "A simple example action",
    menu_bar_path = "FileMenu/SubMenu/RadioGroup",
    tool_bar_path = "RadioGroup",
    style         = "radio",
)

higher_action = Action(
    id            = ID + ".action.example_action.HigherAction",
    class_name    = ID + ".action.example_action.ExampleAction",
    name          = "Higher",
    image         = "action/images/higher",
    description   = "An action's description can appear in the status bar",
    tooltip       = "A simple example action",
    menu_bar_path = "FileMenu/SubMenu/RadioGroup",
    tool_bar_path = "RadioGroup",
    style         = "radio",
    checked       = True
)

lower_action = Action(
    id            = ID + ".action.example_action.LowerAction",
    class_name    = ID + ".action.example_action.ExampleAction",
    name          = "Lower",
    image         = "action/images/lower",
    description   = "An action's description can appear in the status bar",
    tooltip       = "A simple example action",
    menu_bar_path = "FileMenu/SubMenu/RadioGroup",
    tool_bar_path = "RadioGroup",
    style         = "radio",
)

lowest_action = Action(
    id            = ID + ".action.example_action.LowestAction",
    class_name    = ID + ".action.example_action.ExampleAction",
    name          = "Lowest",
    image         = "action/images/lower",
    description   = "An action's description can appear in the status bar",
    tooltip       = "A simple example action",
    menu_bar_path = "FileMenu/SubMenu/RadioGroup",
    tool_bar_path = "RadioGroup",
    style         = "radio",
)

overdrive_action = Action(
    id            = ID + ".action.example_action.OverdriveAction",
    class_name    = ID + ".action.example_action.ExampleAction",
    name          = "Overdrive",
    image         = "action/images/overdrive",
    description   = "An action's description can appear in the status bar",
    tooltip       = "A simple example action",
    menu_bar_path = "FileMenu/SubMenu/",
    tool_bar_path = "additions",
    style         = "toggle",
)

ui_actions = UIActions(
    menus = [
        sub_menu, file_menu
    ],

    actions = [
        do_it_action, highest_action, higher_action, lower_action,
        lowest_action, overdrive_action
    ]
)

#### Views ####################################################################

ui_views = UIViews(
    views = [
        View(
            name       = "Stuff View",
            image      = "images/example_view.png",
            id         = ID + ".view.ExampleView",
            class_name = ID + ".view.ExampleView"
        )
    ]
)

###############################################################################
# The plugin definition!
###############################################################################

class SimpleUIPluginDefinition(PluginDefinition):
    """ An example using the UI plugin. """

    # The plugin's globally unique identifier.
    id = ID

    # The name of the class that implements the plugin.
    class_name = ID + ".plugin_implementation.SimpleUIPlugin"

    # General information about the plugin.
    name          = "Envisage Simple UI Plugin"
    version       = "1.0.0"
    provider_name = "Enthought Inc"
    provider_url  = "www.enthought.com"

    # The Id's of the plugins that this plugin requires.
    requires = [
        "enthought.envisage.ui",
        "enthought.envisage.ui.preference"
    ]

    # The extension points offered by this plugin,
    extension_points = []
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [ui_actions, ui_views, preferences, preference_pages]

#### EOF ######################################################################
