""" Displays the generic new resource wizard. """


# Enthought library imports.
from enthought.pyface.api import OK

# Plugin imports.
from enthought.envisage import get_application
from enthought.envisage.project import CookieManager
from enthought.envisage.project.wizard import NewOtherWizard
from enthought.envisage.resource.resource_ui_plugin import ResourceUIPlugin

# Local imports.
from new_resource_action import NewResourceAction
from open_cookie import OpenCookie


class NewOtherAction(NewResourceAction):
    """ Displays the generic new resource wizard. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event):
        """ Performs the action. """                

        wizards = get_application().service_registry.get_service(
                     ResourceUIPlugin.IWIZARD_MANAGER
            )

        # Create and open the wizard.
        wizard = NewOtherWizard(
            parent         = self.window.control,
            root           = wizards,
            default_folder = self._get_default_folder()
        )
        if wizard.open() == OK:
            # Create the resource!
            resource = wizard.create_resource()

            # If the resource can be opened then open it.
            if resource is not None:
                cookie_manager = CookieManager()
                
                cookie = cookie_manager.get_cookie(OpenCookie, resource.obj)
                if cookie is not None:
                    cookie.open(self.window, resource)
            
        return

#### EOF ######################################################################
