/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <klocale.h>
#include <kpopupmenu.h>
#include <qcursor.h>
#include "mainwidget.h"
#include "programitem.h"
#include "program.h"
#include "blistmaster.h"
//-----------------------------------------------------------------------------------------------------------------------
BlistMaster::BlistMaster(MainWidget *parent)
{
	m_parent = parent;
	loadBlacklist();
	
	connect(m_parent->lv_blacklist, SIGNAL(contextMenu(KListView*, QListViewItem*, const QPoint&)), this, SLOT(showPopupMenu(KListView*, QListViewItem*, const QPoint&)));
}
//-----------------------------------------------------------------------------------------------------------------------
BlistMaster::~BlistMaster()
{
	saveBlacklist();
}
//-----------------------------------------------------------------------------------------------------------------------
void BlistMaster::loadBlacklist(KConfig *cfg)
{
	if(!cfg->hasGroup("Blacklist"))
		return;
	cfg->setGroup("Blacklist");
	m_blacklist.clear();
	m_parent->lv_blacklist->clear();
	m_blacklist = cfg->readListEntry("blacklist");
	rebuildBlacklist();
}
//-----------------------------------------------------------------------------------------------------------------------
void BlistMaster::saveBlacklist(KConfig *cfg)
{
	cfg->setGroup("Blacklist");
	cfg->writeEntry("blacklist", m_blacklist);
	cfg->sync();
}
//-----------------------------------------------------------------------------------------------------------------------
bool BlistMaster::isBlacklisted(QString title)
{
	for(QStringList::Iterator it = m_blacklist.begin(); it != m_blacklist.end(); ++it)
		if(*it == title)
			return(true);
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
void BlistMaster::addBlacklist()
{
	QListViewItemIterator it(m_parent->activeView()->listView(), QListViewItemIterator::Selected);
	if(!it.current()) return;
	QString title;

	title = ((ProgramItem*)it.current())->program()->title();
	m_blacklist.append(title);
	new QListViewItem(m_parent->lv_blacklist, title);
	m_parent->activeView()->listView()->clearSelection();
	m_parent->refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void BlistMaster::showPopupMenu(KListView*, QListViewItem*, const QPoint&)
{
	QListViewItemIterator it(m_parent->lv_blacklist, QListViewItemIterator::Selected);
	
	if(!it.current()) return;
	KPopupMenu *blMenu = new KPopupMenu(m_parent);

	blMenu->insertItem(i18n("Remove from Blacklist"), this, SLOT(removeStringBlacklist()));
	blMenu->exec(QCursor::pos());

	delete blMenu;
}
//-----------------------------------------------------------------------------------------------------------------------
void BlistMaster::removeStringBlacklist()
{
	QListViewItemIterator it(m_parent->lv_blacklist, QListViewItemIterator::Selected);
	while(it.current()) {
		m_blacklist.remove(it.current()->text(0));
		++it;
	}
	m_parent->lv_blacklist->clear();
	rebuildBlacklist();
	m_parent->refresh();
}
//-----------------------------------------------------------------------------------------------------------------------
void BlistMaster::rebuildBlacklist()
{
	for(QStringList::Iterator it = m_blacklist.begin(); it != m_blacklist.end(); ++it)
		new QListViewItem(m_parent->lv_blacklist, *it);
}
//-----------------------------------------------------------------------------------------------------------------------
