(* Copyright (C) 2004-2005, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

exception AlreadyDefined of UriManager.uri

val set_object_declaration_hook : (UriManager.uri -> Cic.obj -> unit) -> unit

(* this is a pointer to the function which builds the inversion principle *)
val build_inversion_principle: (UriManager.uri-> Cic.obj -> (UriManager.uri * Cic.obj) list) ref

(* adds an object to the library together with all auxiliary lemmas on it *)
(* (e.g. elimination principles, projections, etc.)                       *)
(* it returns the list of the uris of the auxiliary lemmas generated      *)
val add_obj: 
  RefinementTool.kit -> 
  UriManager.uri -> Cic.obj -> 
    UriManager.uri list

(* inverse of add_obj;                                                   *)
(* Warning: it does not remove the dependencies on the object and on its *)
(* auxiliary lemmas!                                                     *)
val remove_obj: UriManager.uri -> unit

(* Informs the library that [uri] is a coercion.                         *)
(* This can generate some composite coercions that, if [add_composites]  *)
(* is true are added to the library.                                     *)
(* The list of added objects is returned.                                *)
val add_coercion: 
  add_composites:bool -> 
  RefinementTool.kit -> UriManager.uri -> int (* arity *) ->
   int (* saturations *) -> string (* baseuri *) ->
    (UriManager.uri * int * int) list (* URI, arity, saturations *)

(* inverse of add_coercion, removes both the eventually created composite   *)
(* coercions and the information that [uri] and the composites are coercion *)
val remove_coercion: UriManager.uri -> unit

(* mh... *)
val remove_all_coercions: unit -> unit

