(* Copyright (C) 2004-2005, HELM Team.
 * 
 * This file is part of HELM, an Hypertextual, Electronic
 * Library of Mathematics, developed at the Computer Science
 * Department, University of Bologna, Italy.
 * 
 * HELM is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * HELM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with HELM; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA  02111-1307, USA.
 * 
 * For details, see the HELM World-Wide-Web page,
 * http://helm.cs.unibo.it/
 *)

val add_obj:
  RefinementTool.kit ->
  UriManager.uri -> Cic.obj -> GrafiteTypes.status ->
   GrafiteTypes.status * UriManager.uri list

val add_coercion:
  RefinementTool.kit ->
  add_composites:bool -> GrafiteTypes.status ->
  UriManager.uri -> int -> int ->
  string (* baseuri *) ->
    GrafiteTypes.status * (UriManager.uri * int * int) list
     (* URI, arity, saturations *)

val time_travel: 
  present:GrafiteTypes.status -> past:GrafiteTypes.status -> unit

  (* also resets the imperative part of the status *)
val init: unit -> GrafiteTypes.status
