/*
 * Long integer square root function.
 *
 * Copyright (C) 2007 George Gesslein II.
 */

#include <stdio.h>

#define	true	1
#define	false	0

#if	false
/*
 * Return the truncated integer square root using the Babylonian iterative approximation method.
 * Return -1 on error.
 */
long
lsqrt(long y)
{
	long	x_old, x_new;
	long	testy;
	int	nbits;
	int	i;

	if (y <= 0) {
		if (y != 0) {
			fprintf(stderr, "Domain error in %s().\n", __func__);
			return -1L;
		}
		return 0L;
	}
/* select a good starting value using binary logarithms: */
	nbits = (sizeof(y) * 8) - 1;	/* subtract 1 for sign bit */
	for (i = 4, testy = 16L;; i += 2, testy <<= 2L) {
		if (i >= nbits || y <= testy) {
			x_old = (1L << (i / 2L));	/* x_old = sqrt(testy) */
			break;
		}
	}
/* x_old >= sqrt(y) */
/* use the Babylonian method to arrive at the integer square root: */
	for (;;) {
		x_new = (y / x_old + x_old) / 2L;
		if (x_old <= x_new)
			break;
		x_old = x_new;
	}
/* optional test code to make sure that the answer is right: */
	if ((long long) x_old * x_old > y || ((long long) x_old + 1) * ((long long) x_old + 1) <= y) {
		fprintf(stderr, "Error in %s().\n", __func__);
		return -1L;
	}
	return x_old;
}
#else
/*
 * Faster and simpler binary digit algorithm for calculating the truncated integer square root.
 * Returns -1 on error.
 */
long
lsqrt(long num)
{
	long op = num;
	long res = 0;
	long one = 1L << (sizeof(num) * 8 - 2); // The second-to-top bit is set

	if (num <= 0) {
		if (num != 0) {
			fprintf(stderr, "Domain error in %s().\n", __func__);
			return -1L;
		}
		return 0L;
	}
// "one" starts at the highest power of four <= the argument.
	while (one > op)
		one >>= 2;

	while (one != 0) {
		if (op >= res + one) {
			op -= res + one;
			res += 2 * one;
		}
		res >>= 1;
		one >>= 2;
	}
	return res;
}
#endif
