/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
void Form1::init()
{
    // Set up variables for scrolling S meter
    sgrafX = 0; // X coord
    sgrafY = 0; // Y coord
    sgrafK = 0; // Array position counter
    cylon = 0;
    for(int u = 0; u<=86; u++){
	sgrf[u] = 0;
    }
}

//***************************************************************************//

void Form1::graf_it( int dt )
{

// sgrf[X] is array of S meter samples 
// sgrafK holds count of sample currently being parsed
if(sgrafK < 86){
    sgrf[sgrafK] = dt * 10; // save new sample and scale it for Y axis
    cylon = sgrafK;
    sgrafK++; // bump the position counter by one, max # of samples is 56
}else{
    // deal with max samples
    for(int n = 0; n<=85; n++){
	sgrf[n] = sgrf[n+1];
	sgrf[sgrafK] = dt * 10; // save new sample and scale it for Y axis
	if(cylon >= 85){
	    cylon = 0;
	}
	cylon += 1;
    }
}
    paintr.begin( &pic );               // paint in picture
    //paintr.setWindow( 0, 0, 392, 100 );
    
    paintr.drawRect(0,0,602,110);    // This initializes the window
    paintr.setPen( Qt::black ); // Rect outline color
    paintr.setBrush(Qt::green);   // Rect fill color
// Now begin the loops to dump the sample array to the picture
    for(int i = 1; i <= 86; i++){
	paintr.drawRect(sgrafX,100-sgrf[i],5,sgrf[i]);
//	paintr.setPen( Qt::green );
//	paintr.drawLine(sgrafX, 105, sgrafX+5, 105);
	paintr.setPen( Qt::red );
	paintr.setBrush(Qt::red);
//	paintr.drawLine((cylon * 7), 105, ((cylon * 7) +5), 105);	
	paintr.drawRect((cylon * 7), 105, 5, 3);
	paintr.setPen( Qt::black );
	paintr.setBrush(Qt::green);
	sgrafX += 7;
    }

	
    paintr.end();                       // painting done
    sgrafX = 0;
    // Actually at this point we have only created the picture.  Next we have to display it.
    sgraphLBL->setPicture(pic); // Display the picture in the appropiate QLabel box
    //qDebug("DEBUG painted");
}

//***************************************************************************//
	
	

