/* UndoRedoCommand.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */
package be.ugent.caagt.swirl.undoredo;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;
import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;
import org.pietschy.command.Face;

/**
 * Common super class of both {@link UndoCommand} and {@link RedoCommand}.
 */
abstract class UndoRedoCommand extends ActionCommand implements UndoListener {

    // Autogenerated proxy constructor.
    protected UndoRedoCommand(CommandManager commandManager, String id) {
        super(commandManager, id);
        this.undoManager = (UndoManager)((AttributedCommandManager)commandManager).getAttribute (KEY);
        undoManager.addUndoListener (this);
	Face face = getFace(FACE);
	disabledText = face.getText();
	disabledDescription = face.getDescription();
	super.setEnabled(false);
    }

    //
    protected abstract String getCaption();

    // implements Command
    protected abstract void handleExecute();

    // implements UndoListener
    public abstract void undoStateChanged();
    
    //
    private static final String KEY = UndoManager.class.getName();
    
    //
    private static final String FACE = "undoredo";
    
    /**
     * Undo manager for this command.
     */
    protected UndoManager undoManager;
    
    //
    private  final String disabledText;
    
    //
    private  final String disabledDescription;
    
    // extends Command
    public void setEnabled (boolean newValue) {
        super.setEnabled (newValue);
	String text = disabledText;
	String description = disabledDescription;
	if (newValue) {
	    String newCaption = getCaption();
	    if (newCaption != null) {
		text = newCaption;
		description = newCaption;
	    }
	}
	Face face = getFace(FACE);
	face.setText (text);
	face.setDescription(description);
    }

}
