/* package-info.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

/**
 * Provides simple dialog windows with
 * slightly more possibilities than the standard <code>JOptionPane</code> dialogs.<p>
 * 
 * A dialog window of this kind has three components: a central panel, an optional icon 
 * on the left hand side and an OK and CANCEL button to the bottom right.<p>
 * If the central component is of type 
 * {@link be.ugent.caagt.swirl.dialogs.DialogPanel} the dialog window title can be 
 * easily internationalized.<p>
 *
 * A typical usage pattern is the following:
 * <ul>
 * <li>Create an extension {@code MyDialogPanel}
 * of {@link be.ugent.caagt.swirl.dialogs.DialogPanel} which populates the panel
 * with some content (e.g., some labels and textfields).</li>
 * <li>Instantiate an object of type {@code MyDialogPanel}.</li>
 * <li>Create a corresponding dialog window from this object
 * by means of one of the {@code createDialog} methods inherited 
 * from {@code DialogPanel}.</li>
 * <li>Launch this dialog with one of the methods
 * {@link be.ugent.caagt.swirl.dialogs.SimpleDialog#launch()},
 * {@link be.ugent.caagt.swirl.dialogs.SimpleDialog#launch(int,int)} or
 * {@link be.ugent.caagt.swirl.dialogs.SimpleDialog#launchAtPointerPosition()}.
 *</li>
 * <li>The return value of each of these methods indicates whether the user pressed
 * OK, CANCEL or simply closed the dialog window.</li>
 * <li>The components of {@code MyDialogPanel} can then be queried for their values.
 * </li>
 *</ul>
 */
package be.ugent.caagt.swirl.dialogs;

